package com.ejianc.business.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.material.bean.MonthOrgDetailEntity;
/**
 * 物资消耗月度分析表-组织
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_month_org")
public class MonthOrgEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织name
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="agent_id")
    private Long agentId; // 经办人
    @TableField(value="agent_name")
    private String agentName; // 经办人姓名
    @TableField(value="dept_id")
    private Long deptId; // 经办部门id
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="month")
    private Date month; // 月份
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="monthOrgDetailService", pidName = "mid")
    private List<MonthOrgDetailEntity> monthOrgDetailList = new ArrayList<>(); // 物资消耗月度分析表-组织子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    

    public List<MonthOrgDetailEntity> getMonthOrgDetailList() {
        return monthOrgDetailList;
    }

    public void setMonthOrgDetailList(List<MonthOrgDetailEntity> monthOrgDetailList) {
        this.monthOrgDetailList = monthOrgDetailList;
    }
}
