package com.ejianc.business.material.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 物资采购总计划明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_procurementplandetail")
public class ProcurementplandetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="serial_number")
    private Long serialNumber; // 序号
    @TableField(value="item_code")
    private String itemCode; // 物料编码
    @TableField(value="item_name")
    private String itemName; // 物料名称
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="model")
    private String model; // 规格型号
    @TableField(value="category")
    private String category; // 采购类别
    @TableField(value="budget_price")
    private BigDecimal budgetPrice; // 预算价（万元）
    @TableField(value="profit_estimates")
        private BigDecimal profitEstimates; // 利润预估率
    @TableField(value="tendering_methods")
    private String tenderingMethods; // 分供方招标方式（1.公开 2.邀请 3.独家议标）
    @TableField(value="cycle")
    private String cycle; // 工期/供货/租赁周期
    @TableField(value="schedule_tender_times")
    private java.util.Date scheduleTenderTimes; // 计划招标时间
    @TableField(value="planned_start_date")
    private java.util.Date plannedStartDate; // 计划开工日期
    @TableField(value="planned_completion_date")
    private java.util.Date plannedCompletionDate; // 计划完工日期
    @TableField(value="quantity")
    private BigDecimal quantity; // 拟选择分供方数量
    @TableField(value="mid")
    private Long mid; // 总计划的单据ID
    @TableField(value = "purchase_quantity")
    private BigDecimal purchaseQuantity; // 采购数量


    public BigDecimal getPurchaseQuantity() {
        return purchaseQuantity;
    }

    public void setPurchaseQuantity(BigDecimal purchaseQuantity) {
        this.purchaseQuantity = purchaseQuantity;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 序号
     */
    public Long getSerialNumber() {
        return serialNumber;
    }

    /**
     * 序号
     */
    public void setSerialNumber(Long serialNumber) {
        this.serialNumber = serialNumber;
    }
    /**
     * 物料编码
     */
    public String getItemCode() {
        return itemCode;
    }

    /**
     * 物料编码
     */
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }
    /**
     * 物料名称
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * 物料名称
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getModel() {
        return model;
    }

    /**
     * 规格型号
     */
    public void setModel(String model) {
        this.model = model;
    }
    /**
     * 采购类别
     */
    public String getCategory() {
        return category;
    }

    /**
     * 采购类别
     */
    public void setCategory(String category) {
        this.category = category;
    }

    public BigDecimal getBudgetPrice() {
        return budgetPrice;
    }

    public void setBudgetPrice(BigDecimal budgetPrice) {
        this.budgetPrice = budgetPrice;
    }

    public BigDecimal getProfitEstimates() {
        return profitEstimates;
    }

    public void setProfitEstimates(BigDecimal profitEstimates) {
        this.profitEstimates = profitEstimates;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    /**
     * 分供方招标方式（1.公开 2.邀请 3.独家议标）
     */
    public String getTenderingMethods() {
        return tenderingMethods;
    }

    /**
     * 分供方招标方式（1.公开 2.邀请 3.独家议标）
     */
    public void setTenderingMethods(String tenderingMethods) {
        this.tenderingMethods = tenderingMethods;
    }
    /**
     * 工期/供货/租赁周期
     */
    public String getCycle() {
        return cycle;
    }

    /**
     * 工期/供货/租赁周期
     */
    public void setCycle(String cycle) {
        this.cycle = cycle;
    }
    /**
     * 计划招标时间
     */
    public java.util.Date getScheduleTenderTimes() {
        return scheduleTenderTimes;
    }

    /**
     * 计划招标时间
     */
    public void setScheduleTenderTimes(java.util.Date scheduleTenderTimes) {
        this.scheduleTenderTimes = scheduleTenderTimes;
    }
    /**
     * 计划开工日期
     */
    public java.util.Date getPlannedStartDate() {
        return plannedStartDate;
    }

    /**
     * 计划开工日期
     */
    public void setPlannedStartDate(java.util.Date plannedStartDate) {
        this.plannedStartDate = plannedStartDate;
    }
    /**
     * 计划完工日期
     */
    public java.util.Date getPlannedCompletionDate() {
        return plannedCompletionDate;
    }

    /**
     * 计划完工日期
     */
    public void setPlannedCompletionDate(java.util.Date plannedCompletionDate) {
        this.plannedCompletionDate = plannedCompletionDate;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    
}
