package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * @Author liyongjia
 * @Date 2020/6/10  仓库实体
 * @Description StoreEntity
 */

@TableName("ejc_material_store")
public class StoreEntity extends BaseEntity {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

    /**
     * 仓库名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 仓库类型（1、组织仓库，2、项目仓库）
     */
    @TableField(value = "project_type")
    private String projectType;

    /**
     * 仓库状态（1、启用，0、停用）
     */
    @TableField(value = "state")
    private String state;

    /**
     * 所属项目
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 所属项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 所属项目编码
     */
    @TableField(value = "project_code")
    private String projectCode;

    /**
     * 所属组织
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;
	/**
	 * 是否影响成本 0-是 1-否
	 */
	@TableField(value = "is_influence_cost")
	private Integer isInfluenceCost;
	/**
	 * 仓库类型 0-成品库 1-废旧物资库 2-资产库
	 */
	@TableField(value = "store_type")
	private Integer storeType;

	/**
	 * 项目部id
	 */
	@TableField(value="project_department_id")
	private java.lang.Long projectDepartmentId; // 项目部id

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getProjectType() {
		return projectType;
	}

	public void setProjectType(String projectType) {
		this.projectType = projectType;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

	public Integer getIsInfluenceCost() {
		return isInfluenceCost;
	}

	public void setIsInfluenceCost(Integer isInfluenceCost) {
		this.isInfluenceCost = isInfluenceCost;
	}

	public Integer getStoreType() {
		return storeType;
	}

	public void setStoreType(Integer storeType) {
		this.storeType = storeType;
	}
}
