package com.ejianc.business.material.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IDeviceexitrecordsdetailService;
import com.ejianc.business.material.service.IDeviceverificationrecordsService;
import com.ejianc.business.material.service.IDeviceverificationrecordsdetailService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.ProcurementplanVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.material.service.IDeviceexitrecordsService;
import com.ejianc.business.material.vo.DeviceexitrecordsVO;

/**
 * 设备退场记录
 *
 * @author generator
 */
@Controller
@RequestMapping("deviceexitrecords")
public class DeviceexitrecordsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "DE_TC_CODE";//此处需要根据实际修改

    @Autowired
    private IDeviceexitrecordsService service;
    @Autowired
    private IDeviceexitrecordsdetailService detailService;
    @Autowired
    private IDeviceverificationrecordsService DeviceverificationrecordsService;
    @Autowired
    private IDeviceverificationrecordsdetailService deviceverificationrecordsdetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeviceexitrecordsVO> saveOrUpdate(@RequestBody DeviceexitrecordsVO saveorUpdateVO) {
        DeviceexitrecordsEntity entity = BeanMapper.map(saveorUpdateVO, DeviceexitrecordsEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<DeviceverificationrecordsdetailEntity> deviceverificationrecordsdetailEntities = new ArrayList<>();
        List<DeviceexitrecordsdetailEntity> deviceexitrecordsdetailEntities = entity.getDeviceexitrecordsdetailEntities();
        List<Long> detailIds = deviceexitrecordsdetailEntities.stream().map(DeviceexitrecordsdetailEntity::getEnterDetailId).collect(Collectors.toList());
        List<DeviceverificationrecordsdetailEntity> detailEntities = deviceverificationrecordsdetailService.list(new QueryWrapper<DeviceverificationrecordsdetailEntity>().in("id",detailIds));
        Map<Long, BigDecimal> detailMap = new HashMap<>(); // 进场单子表进场数量汇总map
        Map<Long, DeviceverificationrecordsdetailEntity> detailEntityMap = new HashMap<>(); // 进场单子表进场数量汇总map
        for (DeviceverificationrecordsdetailEntity deviceverificationrecordsdetailEntity : detailEntities) {
            detailMap.put(deviceverificationrecordsdetailEntity.getId(), deviceverificationrecordsdetailEntity.getEnterCount());
            detailEntityMap.put(deviceverificationrecordsdetailEntity.getId(), deviceverificationrecordsdetailEntity);
        }
        List<DeviceexitrecordsdetailEntity> deviceexitrecordsdetailEntityList = detailService.list(new QueryWrapper<DeviceexitrecordsdetailEntity>().in("enter_detail_id", detailIds).ne(entity.getId() != null, "mid", entity.getId()));
        Map<Long, BigDecimal> numMap = new HashMap<>(); // 退场数量汇总map
        if (CollectionUtils.isNotEmpty(deviceexitrecordsdetailEntityList)) {
            numMap = deviceexitrecordsdetailEntityList.stream().collect(Collectors.groupingBy(DeviceexitrecordsdetailEntity::getEnterDetailId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getExitCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        for (DeviceexitrecordsdetailEntity detailEntity : deviceexitrecordsdetailEntities) {
            BigDecimal num = BigDecimal.ZERO;
            if (numMap.containsKey(detailEntity.getEnterDetailId())) {
                num = numMap.get(detailEntity.getEnterDetailId());
            }
            num = ComputeUtil.safeAdd(detailEntity.getExitCount(), num);
            if (num.compareTo(detailMap.get(detailEntity.getEnterDetailId())) == 1 ) {
                throw new BusinessException("物资编号:" + detailEntity.getEquipmentCode() + ",物资名称:" + detailEntity.getName() + "超过剩余可进场数量,不能保存!");
            }
            // 回写进场单可退场数量
            if (detailEntityMap.containsKey(detailEntity.getEnterDetailId()) && entity.getId() == null) {
                detailEntityMap.get(detailEntity.getEnterDetailId()).setNotExitingCount(ComputeUtil.safeSub(detailEntityMap.get(detailEntity.getEnterDetailId()).getNotExitingCount(), detailEntity.getExitCount()));
                deviceverificationrecordsdetailEntities.add(detailEntityMap.get(detailEntity.getEnterDetailId()));
            }
        }
        if (CollectionUtils.isNotEmpty(deviceverificationrecordsdetailEntities)) {
            deviceverificationrecordsdetailService.saveOrUpdateBatch(deviceverificationrecordsdetailEntities);
        }
        service.saveOrUpdate(entity, false);
        DeviceexitrecordsVO vo = BeanMapper.map(entity, DeviceexitrecordsVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeviceexitrecordsVO> queryDetail(Long id) {
        DeviceexitrecordsEntity entity = service.selectById(id);
        DeviceexitrecordsVO vo = BeanMapper.map(entity, DeviceexitrecordsVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeviceexitrecordsVO> vos) {
        service.removeByIds(vos.stream().map(DeviceexitrecordsVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeviceexitrecordsVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<DeviceexitrecordsEntity> page = service.queryPage(param, false);
        IPage<DeviceexitrecordsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeviceexitrecordsVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }

        List<DeviceexitrecordsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<DeviceexitrecordsVO> deviceexitrecordsVOList = BeanMapper.mapList(list, DeviceexitrecordsVO.class);
        for (int i = 0; i < deviceexitrecordsVOList.size(); i++) {
            DeviceexitrecordsVO deviceexitrecordsVO = deviceexitrecordsVOList.get(i);
            if (deviceexitrecordsVO.getCreateTime() != null) {
                deviceexitrecordsVO.setCreateTimeShow(DateUtils.dateSimple2(deviceexitrecordsVO.getCreateTime()));
            }
            String billStateStr = deviceexitrecordsVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                deviceexitrecordsVO.setBillStateStr(billStateStr);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", deviceexitrecordsVOList);
        ExcelExport.getInstance().export("Deviceexitrecords-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDeviceexitrecordsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeviceexitrecordsVO>> refDeviceexitrecordsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            String contractId = _con.getString("contractId");
            if (contractId!=null) {
                param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
            }
        }

        IPage<DeviceexitrecordsEntity> page = service.queryPage(param, false);
        IPage<DeviceexitrecordsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeviceexitrecordsVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
