package com.ejianc.business.material.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.material.bean.MaterialsreturndetailEntity;
import com.ejianc.business.material.utils.PageUtil;
import com.ejianc.foundation.material.vo.EquipmentEntryExitVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.vo.FlowmeterVO;

/**
 * 出入库流水表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("flowmeter")
public class FlowmeterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFlowmeterService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FlowmeterVO> saveOrUpdate(@RequestBody FlowmeterVO saveOrUpdateVO) {
    	FlowmeterEntity entity = BeanMapper.map(saveOrUpdateVO, FlowmeterEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	FlowmeterVO vo = BeanMapper.map(entity, FlowmeterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FlowmeterVO> queryDetail(Long id) {
    	FlowmeterEntity entity = service.selectById(id);
    	FlowmeterVO vo = BeanMapper.map(entity, FlowmeterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FlowmeterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FlowmeterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FlowmeterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FlowmeterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialCategoryCode");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("specialModel");
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<FlowmeterEntity> page = service.queryPage(param,false);
        IPage<FlowmeterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FlowmeterVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialCategoryCode");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("specialModel");
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<FlowmeterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Flowmeter-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refFlowmeterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FlowmeterVO>> refFlowmeterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FlowmeterEntity> page = service.queryPage(param,false);
        IPage<FlowmeterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FlowmeterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryInStore 物资入库台账查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryInStore", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryInStore(@RequestBody QueryParam param){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("project_name");
        fuzzyFields.add("material_category_name");
        fuzzyFields.add("material_name");
        fuzzyFields.add("supplier_name");
        fuzzyFields.add("measurement_unit");
        fuzzyFields.add("special_model");
        List<FlowmeterVO> list = new ArrayList<>();
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        param.getParams().put("operation_type", new Parameter(QueryParam.EQ, "入库"));
        param.getParams().put("project_id", new Parameter(QueryParam.NE, null));
        param.getParams().put("material_code", new Parameter(QueryParam.NE, null));
        List<FlowmeterEntity> flowmeterEntities = service.queryList(param);
        List<String> termsList = new ArrayList<>();
        // 累计供货数量
        Map<String, BigDecimal> numMap = flowmeterEntities.stream().collect(Collectors.groupingBy((s -> s.getProjectId()+"-"+s.getMaterialCode()+"-"+s.getSupplierId()),
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        // 累计供货金额(无税)
        Map<String, BigDecimal> exMap = flowmeterEntities.stream().collect(Collectors.groupingBy((s -> s.getProjectId()+"-"+s.getMaterialCode()+"-"+s.getSupplierId()),
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        // 累计供货金额(含税)
        Map<String, BigDecimal> inMap = flowmeterEntities.stream().collect(Collectors.groupingBy((s -> s.getProjectId()+"-"+s.getMaterialCode()+"-"+s.getSupplierId()),
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        for (FlowmeterVO vo : BeanMapper.mapList(flowmeterEntities, FlowmeterVO.class)) {
            if (!termsList.contains(vo.getProjectId() + "-" + vo.getMaterialCode() + "-" + vo.getSupplierId())) {
                vo.setQuantity(numMap.get(vo.getProjectId() + "-" + vo.getMaterialCode() + "-" + vo.getSupplierId()));
                vo.setAmountExcluetax(exMap.get(vo.getProjectId() + "-" + vo.getMaterialCode() + "-" + vo.getSupplierId()));
                vo.setAmountIncluetax(inMap.get(vo.getProjectId() + "-" + vo.getMaterialCode() + "-" + vo.getSupplierId()));
                vo.setTerms(vo.getProjectId() + "-" + vo.getMaterialCode() + "-" + vo.getSupplierId());
                termsList.add(vo.getProjectId() + "-" + vo.getMaterialCode() + "-" + vo.getSupplierId());
                list.add(vo);
            }
        }
        List<FlowmeterVO> flowmeterVOS = BeanMapper.mapList(flowmeterEntities, FlowmeterVO.class);

        for (FlowmeterVO vo : list) {
            List<Long> ids = new ArrayList<>();
            for (FlowmeterVO flowmeterVO : flowmeterVOS) {
                if (vo.getTerms().equals(flowmeterVO.getProjectId() + "-" + flowmeterVO.getMaterialCode() + "-" + flowmeterVO.getSupplierId())) {
                    ids.add(flowmeterVO.getId());
                }
            }
            vo.setIds(ids);
        }

        JSONObject page = new JSONObject();
        page.put("current", "" + param.getPageIndex());
        page.put("size", "" + param.getPageSize());
        page.put("records", new ArrayList<>());
        page.put("total", "" + 0);
        page.put("pages", "" + 0);

        if (CollectionUtils.isNotEmpty(list)){
            // 分页
            int total = list.size();//总条数
            JSONArray jsonArray = JSONArray.parseArray(JSONArray.toJSONString(list));
            JSONArray records = PageUtil.listToPage(jsonArray, param.getPageIndex(), param.getPageSize());
            int pages = PageUtil.getPages(total,  param.getPageSize());//有几页
            page.put("records", records);
            page.put("total", "" + total);
            page.put("pages", "" + pages);
        }

        return CommonResponse.success("查询参照数据成功！", page);


//        pageData.setRecords(list);
//        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description queryInStore 物资出库台账查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryOutStore", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FlowmeterVO>> queryOutStore(@RequestBody QueryParam param){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("material_category_name");
        fuzzyFields.add("material_name");
        fuzzyFields.add("supplier_name");
        fuzzyFields.add("measurement_unit");
        fuzzyFields.add("special_model");
        fuzzyFields.add("project_name");
        List<FlowmeterVO> list = new ArrayList<>();
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        param.getParams().put("operation_type", new Parameter(QueryParam.EQ, "出库"));
        param.getParams().put("project_id", new Parameter(QueryParam.NE, null));
        param.getParams().put("material_code", new Parameter(QueryParam.NE, null));
        List<FlowmeterEntity> flowmeterEntities = service.queryList(param);
        List<String> termsList = new ArrayList<>();
        // 累计供货数量
        Map<String, BigDecimal> numMap = flowmeterEntities.stream().collect(Collectors.groupingBy((s -> s.getProjectId()+"-"+s.getMaterialCode()),
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        // 累计供货金额(无税)
        Map<String, BigDecimal> exMap = flowmeterEntities.stream().collect(Collectors.groupingBy((s -> s.getProjectId()+"-"+s.getMaterialCode()),
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        // 累计供货金额(含税)
        Map<String, BigDecimal> inMap = flowmeterEntities.stream().collect(Collectors.groupingBy((s -> s.getProjectId()+"-"+s.getMaterialCode()),
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));

        for (FlowmeterVO vo : BeanMapper.mapList(flowmeterEntities, FlowmeterVO.class)) {
            if (!termsList.contains(vo.getProjectId() + "-" + vo.getMaterialCode())) {
                vo.setQuantity(numMap.get(vo.getProjectId() + "-" + vo.getMaterialCode()));
                vo.setAmountExcluetax(exMap.get(vo.getProjectId() + "-" + vo.getMaterialCode()));
                vo.setAmountIncluetax(inMap.get(vo.getProjectId() + "-" + vo.getMaterialCode()));
                vo.setTerms(vo.getProjectId() + "-" + vo.getMaterialCode());
                termsList.add(vo.getProjectId() + "-" + vo.getMaterialCode());
                list.add(vo);
            }else {

            }
        }
        for (FlowmeterVO vo : list) {
            List<Long> ids = new ArrayList<>();
            for (FlowmeterVO flowmeterVO : BeanMapper.mapList(flowmeterEntities, FlowmeterVO.class)) {
                if (vo.getTerms().equals(flowmeterVO.getProjectId() + "-" + flowmeterVO.getMaterialCode())) {
                    ids.add(flowmeterVO.getId());
                }
            }
            vo.setIds(ids);
        }
        IPage<FlowmeterVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelInExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelInExport(@RequestBody QueryParam param, HttpServletResponse response) {
        //todo上下文组织是项目的时候，导出为空白，如果上下文是集团导出有信息
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> jsonObjectCommonResponse = queryInStore(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", jsonObjectCommonResponse);
        ExcelExport.getInstance().export("FlowmeterIn-export.xlsx", beans, response);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelInDetailExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelInDetailExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FlowmeterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FlowmeterInDetail-export.xlsx", beans, response);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelOutExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelOutExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<FlowmeterVO> list = queryOutStore(param).getData().getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FlowmeterOut-export.xlsx", beans, response);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelOutDetailExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelOutDetailExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FlowmeterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FlowmeterOutDetail-export.xlsx", beans, response);
    }
}
