package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.MaterialapproachEntity;
import com.ejianc.business.material.bean.MaterialsreturnEntity;
import com.ejianc.business.material.service.IMaterialApproachSreturnService;
import com.ejianc.business.material.service.IMaterialapproachService;
import com.ejianc.business.material.service.IMaterialsreturnService;
import com.ejianc.foundation.material.vo.MaterialApproachSreturnVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 租赁周转料具管理台账
 * @author biying
 */
@Controller
@RequestMapping("materialApproachSreturn")
public class MaterialApproachSreturnController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private IMaterialApproachSreturnService service;

    @Autowired
    private IMaterialapproachService materialapproachService;

    @Autowired
    private IMaterialsreturnService materialsreturnService;

    /**
     * 查询列表数据
     *
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialApproachSreturnVO>> queryList(@RequestBody QueryParam param) {
        String returnTimeStart = null;
        String returnTimeEnd = null;
        Long supplierId = null;
        String searchText = null;
        List<Long> ids = new ArrayList<>();
        List<MaterialApproachSreturnVO> list = new ArrayList<>();
        if (param.getParams().get("returnTime") != null) {
            String[] date = param.getParams().get("returnTime").getValue().toString().split(",");
            returnTimeStart = date[0];
            returnTimeEnd = date[1];
            param.getParams().remove("returnTime");
        }
        if (param.getParams().get("supplierName") != null) {
            supplierId = Long.valueOf(param.getParams().get("supplierName").getValue().toString());
            param.getParams().remove("supplierName");
        }
        if (param.getSearchText() != null) {
            searchText = param.getSearchText();
            param.setSearchText(null);
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<MaterialapproachEntity> materialapproachList = materialapproachService.queryList(param);
        if (CollectionUtils.isNotEmpty(materialapproachList)) {
            for (MaterialapproachEntity entity : materialapproachList) {
                ids.add(entity.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            list = service.queryMaterial(returnTimeStart,returnTimeEnd,supplierId,ids,searchText);
            for (MaterialApproachSreturnVO vo : list) {
                vo.setId(IdWorker.getId());
            }
        }
        IPage<MaterialApproachSreturnVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<MaterialApproachSreturnVO> list = queryList(param).getData().getRecords();
        for (MaterialApproachSreturnVO vo : list) {
            vo.setNowCount(ComputeUtil.safeSub(ComputeUtil.safeSub(ComputeUtil.safeSub(vo.getEnterCount(),vo.getLostCount()),vo.getMaintainCount()),vo.getReturnCount()));
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialApproachSreturn-export.xlsx", beans, response);
    }



    /**
     * 查询列表数据
     *
     * @return
     */
    @RequestMapping(value = "/queryApproach", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialApproachSreturnVO>> queryApproach(@RequestBody QueryParam param){
        Long projectId = null;
        String materialCode = null;
        String supplierName = param.getSearchText();
        List<Long> ids = new ArrayList<>();
        List<MaterialApproachSreturnVO> list = new ArrayList<>();
        if (param.getParams().get("projectId") != null) {
            projectId = Long.valueOf(param.getParams().get("projectId").getValue().toString());
            param.getParams().remove("projectId");
        }
        if (param.getParams().get("materialCode") != null) {
            materialCode = param.getParams().get("materialCode").getValue().toString();
            param.getParams().remove("materialCode");
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<MaterialapproachEntity> materialapproachEntityList = materialapproachService.queryList(param);
        if (CollectionUtils.isNotEmpty(materialapproachEntityList)) {
            for (MaterialapproachEntity entity : materialapproachEntityList) {
                ids.add(entity.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            list = service.queryApproach(projectId, materialCode, supplierName, ids);
        }
        IPage<MaterialApproachSreturnVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/approachExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void approachExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<MaterialApproachSreturnVO> list = queryApproach(param).getData().getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Approach-export.xlsx", beans, response);
    }



    /**
     * 查询列表数据
     *
     * @return
     */
    @RequestMapping(value = "/querySreturn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialApproachSreturnVO>> querySreturn(@RequestBody QueryParam param){
        Long projectId = null;
        String materialCode = null;
        String supplierName = param.getSearchText();
        List<Long> ids = new ArrayList<>();
        List<MaterialApproachSreturnVO> list = new ArrayList<>();
        if (param.getParams().get("projectId") != null) {
            projectId = Long.valueOf(param.getParams().get("projectId").getValue().toString());
            param.getParams().remove("projectId");
        }
        if (param.getParams().get("materialCode") != null) {
            materialCode = param.getParams().get("materialCode").getValue().toString();
            param.getParams().remove("materialCode");
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<MaterialsreturnEntity> materialsreturnEntityList = materialsreturnService.queryList(param);
        if (CollectionUtils.isNotEmpty(materialsreturnEntityList)) {
            for (MaterialsreturnEntity entity : materialsreturnEntityList) {
                ids.add(entity.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            list = service.querySreturn(projectId, materialCode, supplierName, ids);
        }
        IPage<MaterialApproachSreturnVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/sreturnExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void sreturnExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<MaterialApproachSreturnVO> list = querySreturn(param).getData().getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Sreturn-export.xlsx", beans, response);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
