package com.ejianc.business.material.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.MaterialWarehousingEntity;
import com.ejianc.business.material.bean.ProcurementplandetailEntity;
import com.ejianc.business.material.service.IMaterialWarehousingService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.material.bean.MaterialWarehousingdetailEntity;
import com.ejianc.business.material.service.IMaterialWarehousingdetailService;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;

/**
 * 物资验收入库单子表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialWarehousingdetail")
public class MaterialWarehousingdetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMaterialWarehousingdetailService service;
    @Autowired
    private IMaterialWarehousingService materialWarehousingService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialWarehousingdetailVO> saveOrUpdate(@RequestBody MaterialWarehousingdetailVO saveorUpdateVO) {
    	MaterialWarehousingdetailEntity entity = BeanMapper.map(saveorUpdateVO, MaterialWarehousingdetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
               // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	MaterialWarehousingdetailVO vo = BeanMapper.map(entity, MaterialWarehousingdetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialWarehousingdetailVO> queryDetail(Long id) {
    	MaterialWarehousingdetailEntity entity = service.selectById(id);
    	MaterialWarehousingdetailVO vo = BeanMapper.map(entity, MaterialWarehousingdetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialWarehousingdetailVO> vos) {
        service.removeByIds(vos.stream().map(MaterialWarehousingdetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialWarehousingdetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<MaterialWarehousingdetailEntity> page = service.queryPage(param,false);
        IPage<MaterialWarehousingdetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialWarehousingdetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 根据主表主键查询子表信息
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListByMid", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<MaterialWarehousingdetailEntity>> queryListByMid(@RequestBody List<Long> ids) {

        LambdaQueryWrapper<MaterialWarehousingEntity> lambdaMid = Wrappers.<MaterialWarehousingEntity>lambdaQuery();
        lambdaMid.in(MaterialWarehousingEntity::getId, ids);
        List<MaterialWarehousingEntity> materialWarehousingEntities = materialWarehousingService.list(lambdaMid);
        Map<Long, MaterialWarehousingEntity> mMap = materialWarehousingEntities.stream().collect(Collectors.toMap(MaterialWarehousingEntity::getId, Function.identity()));


        LambdaQueryWrapper<MaterialWarehousingdetailEntity> lambda = Wrappers.<MaterialWarehousingdetailEntity>lambdaQuery();
        lambda.in(MaterialWarehousingdetailEntity::getMid, ids);
        List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = service.list(lambda);
        for (MaterialWarehousingdetailEntity materialWarehousingdetailEntity : materialWarehousingdetailEntities){
            if (mMap.containsKey(materialWarehousingdetailEntity.getMid())){
                MaterialWarehousingEntity materialWarehousingEntity = mMap.get(materialWarehousingdetailEntity.getMid());
                materialWarehousingdetailEntity.setBillCode(materialWarehousingEntity.getBillCode());
                materialWarehousingdetailEntity.setPuinTime(materialWarehousingEntity.getPuinTime());
            }

        }
        return CommonResponse.success("查询列表数据成功！",materialWarehousingdetailEntities);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialWarehousingdetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialWarehousingdetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialWarehousingdetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialWarehousingdetailVO>> refMaterialWarehousingdetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialWarehousingdetailEntity> page = service.queryPage(param,false);
        IPage<MaterialWarehousingdetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialWarehousingdetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
