package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.bean.MaterialsreturnEntity;
import com.ejianc.business.material.service.IMaterialapproachService;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.business.material.service.IMaterialsreturnService;
import com.ejianc.business.material.service.IMaterialsreturndetailService;
import com.ejianc.business.material.utils.BigDecimalUtils;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.MaterialreturnReportVO;
import com.ejianc.business.material.vo.MaterialsreturnVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资/周转材退场记录单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialsreturn")
public class MaterialsreturnController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "WZ_SRETURN";//此处需要根据实际修改

    @Autowired
    private IMaterialsreturnService service;
    @Autowired
    private IMaterialsreturndetailService detailService;
    @Autowired
    private IMaterialapproachdetailService materialapproachdetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    @Transactional
    public CommonResponse<MaterialsreturnVO> saveOrUpdate(@RequestBody MaterialsreturnVO saveorUpdateVO) {
    	MaterialsreturnEntity entity = BeanMapper.map(saveorUpdateVO, MaterialsreturnEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<MaterialsreturndetailEntity> materialsreturndetailEntities = entity.getMaterialsreturndetailEntities();
        for (MaterialsreturndetailEntity item:
                materialsreturndetailEntities) {
            item.setProjectId(entity.getProjectId());
            item.setProjectName(entity.getProjectName());
            //通过物资中转进场记录主键id,物资编码查询物资中转进场记录子表，回填物资中转退场记录子表中对应的
            //退场数量,维修数量,丢失数量用作下一次做退场记录时校验退场数量,维修数量,丢失数量和进场数量的大小关系
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("material_code",item.getMaterialCode());
            queryWrapper.eq("mid",entity.getEnterId().toString());
            MaterialapproachdetailEntity one = materialapproachdetailService.getOne(queryWrapper);

            one.setExitAccount(BigDecimalUtils.ofNullable(one.getExitAccount()).add(BigDecimalUtils.ofNullable(item.getReturnCount())));
            one.setLoseAccount(BigDecimalUtils.ofNullable(one.getLoseAccount()).add(BigDecimalUtils.ofNullable(item.getLostCount())));
            one.setRepairAccount(BigDecimalUtils.ofNullable(one.getRepairAccount()).add(BigDecimalUtils.ofNullable(item.getMaintainCount())));
            materialapproachdetailService.updateById(one);
        }
        List<Long> approachDetailIds = materialsreturndetailEntities.stream().map(MaterialsreturndetailEntity::getApproachDetailId).collect(Collectors.toList());
        List<MaterialapproachdetailEntity> approachDetailEntities = materialapproachdetailService.list(new QueryWrapper<MaterialapproachdetailEntity>().in("id",approachDetailIds));
        Map<Long, BigDecimal> approachDetailMap = new HashMap<>(); // 进场单子表进场验证数量汇总map
        for (MaterialapproachdetailEntity detailEntity : approachDetailEntities) {
            approachDetailMap.put(detailEntity.getId(), detailEntity.getVerificationCount());
        }
        List<MaterialsreturndetailEntity> materialsreturndetailEntityList = detailService.list(new QueryWrapper<MaterialsreturndetailEntity>().in("approach_detail_id",approachDetailIds).ne(entity.getId() != null,"mid",entity.getId())); // 往期退场子表
        Map<Long, BigDecimal> numMap = new HashMap<>(); // 退场数量汇总map
        Map<Long, BigDecimal> lostMap = new HashMap<>(); // 丢失数量汇总map
        Map<Long, BigDecimal> maintainMap = new HashMap<>(); // 维修数量汇总map
        if (CollectionUtils.isNotEmpty(materialsreturndetailEntityList)) {
            numMap = materialsreturndetailEntityList.stream().collect(Collectors.groupingBy(MaterialsreturndetailEntity::getApproachDetailId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getReturnCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            lostMap = materialsreturndetailEntityList.stream().collect(Collectors.groupingBy(MaterialsreturndetailEntity::getApproachDetailId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getLostCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            maintainMap = materialsreturndetailEntityList.stream().collect(Collectors.groupingBy(MaterialsreturndetailEntity::getApproachDetailId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getMaintainCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        for (MaterialsreturndetailEntity materialsreturndetailEntity : materialsreturndetailEntities) {
            BigDecimal num = BigDecimal.ZERO;
            if (numMap.containsKey(materialsreturndetailEntity.getApproachDetailId())) {
                num = numMap.get(materialsreturndetailEntity.getApproachDetailId());
            }
            BigDecimal lostNum = BigDecimal.ZERO;
            if (lostMap.containsKey(materialsreturndetailEntity.getApproachDetailId())) {
                lostNum = lostMap.get(materialsreturndetailEntity.getApproachDetailId());
            }
            BigDecimal maintainNum = BigDecimal.ZERO;
            if (maintainMap.containsKey(materialsreturndetailEntity.getApproachDetailId())) {
                maintainNum = maintainMap.get(materialsreturndetailEntity.getApproachDetailId());
            }
            // 共占用量=本期三个数量+往期三个数量  与进场验证数量作比较
            num = ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(materialsreturndetailEntity.getReturnCount(), num),lostNum),maintainNum),materialsreturndetailEntity.getLostCount()),materialsreturndetailEntity.getMaintainCount());
            if (num.compareTo(approachDetailMap.get(materialsreturndetailEntity.getApproachDetailId())) == 1 ) {
                throw new BusinessException("物资编号:" + materialsreturndetailEntity.getMaterialCode() + ",物资名称:" + materialsreturndetailEntity.getName() + "超过剩余可进场数量,不能保存!");
            }
        }
        service.saveOrUpdate(entity, false);
    	MaterialsreturnVO vo = BeanMapper.map(entity, MaterialsreturnVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialsreturnVO> queryDetail(Long id) {
    	MaterialsreturnEntity entity = service.selectById(id);
    	MaterialsreturnVO vo = BeanMapper.map(entity, MaterialsreturnVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialsreturnVO> vos) {
        service.removeByIds(vos.stream().map(MaterialsreturnVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialsreturnVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<MaterialsreturnEntity> page = service.queryPage(param,false);
        IPage<MaterialsreturnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialsreturnVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("agentdep_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("enter_code");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<MaterialsreturnEntity> list = service.queryList(param);

        //时间转换
        List<MaterialsreturnVO> materialsreturnVOList = BeanMapper.mapList(list, MaterialsreturnVO.class);
        for (int i = 0; i < materialsreturnVOList.size(); i++) {
            MaterialsreturnVO materialsreturnVO = materialsreturnVOList.get(i);
            materialsreturnVO.setNum(String.valueOf(i + 1));
            if (materialsreturnVO.getCreateTime() != null) {
                materialsreturnVO.setCreateTimeShow(DateUtils.dateSimple2(materialsreturnVO.getCreateTime()));
            }
            if (materialsreturnVO.getBillTime()!=null){
                materialsreturnVO.setBillTimeShow(DateUtils.dateSimple2(materialsreturnVO.getBillTime()));
            }
            if (materialsreturnVO.getReturnTime()!=null){
                materialsreturnVO.setReturnTimeShow(DateUtils.dateSimple2(materialsreturnVO.getReturnTime()));
            }

            String billStateStr = materialsreturnVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                materialsreturnVO.setBillStateStr(billStateStr);
            }
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", materialsreturnVOList);
        ExcelExport.getInstance().export("Materialsreturn-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialsreturnData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialsreturnVO>> refMaterialsreturnData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("agentdep_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("enter_code");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialsreturnEntity> page = service.queryPage(param,false);
        IPage<MaterialsreturnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialsreturnVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/queryReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialreturnReportVO>> queryReport(Long projectId, String materialCode) {
        List<MaterialreturnReportVO> resList = new ArrayList<>();
        QueryWrapper<MaterialsreturndetailEntity> detailQueryWrapper = new QueryWrapper<>();
        detailQueryWrapper.eq("dr", 0);
        detailQueryWrapper.eq("project_id", projectId);
        detailQueryWrapper.eq("material_code", materialCode);
        List<MaterialsreturndetailEntity> detailEntityList = detailService.list(detailQueryWrapper);

        for (MaterialsreturndetailEntity item:
                detailEntityList) {
            String projectName = item.getProjectName();//项目名称
            String name = item.getName();//料具名称
            BigDecimal returnCount = item.getReturnCount();//退场数量
            MaterialreturnReportVO reportVO = new MaterialreturnReportVO();
            reportVO.setId(IdWorker.getId());
            reportVO.setProjectId(projectId);
            reportVO.setProjectName(projectName);
            reportVO.setMaterialName(name);
            reportVO.setMaterialCode(materialCode);
            reportVO.setReturnCount(returnCount);
            reportVO.setSpec(item.getSpec());

            Long mid = item.getMid();
            QueryWrapper<MaterialsreturnEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("id", mid);
            List<MaterialsreturnEntity> mList = service.list(queryWrapper);
            if(mList != null && mList.size() > 0){
                MaterialsreturnEntity entity = mList.get(0);
                String billCode = entity.getBillCode();
                reportVO.setBillCode(billCode);
                reportVO.setMaterialsreturnId(mid);
            }

            resList.add(reportVO);
        }

        return CommonResponse.success("查询成功", resList);
    }
}
