package com.ejianc.business.material.controller.api;

import com.ejianc.business.material.service.ICheckService;
import com.ejianc.business.material.service.IMaterialWarehousingService;
import com.ejianc.foundation.material.vo.CheckDetailVO;
import com.ejianc.foundation.material.vo.GatherSendVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 物资结存
 *
 * @author generator
 */
@Controller
@RequestMapping("api/check")
public class CheckApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckService checkService;
    @Autowired
    private IMaterialWarehousingService materialWarehousingService;

    /**
     * 根据项目id和月度查询物资结存本月消耗
     * @param projectId 项目id
     * @param checkMonth     月份
     * @return
     */


    @RequestMapping(value = "/queryCheckByMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, CheckDetailVO>> queryCheckByMonth(Long projectId, String checkMonth){
        logger.info("check-projectId----"+projectId);
        logger.info("check-checkMonth---"+checkMonth);
        Map<String, CheckDetailVO> stringCheckDetailVOMap = checkService.queryCheckByMonth(projectId, checkMonth);
        return CommonResponse.success("查询数据成功", stringCheckDetailVOMap);
    }

    /**
     *校验
     * @param projectId 项目id
     * @param checkMonth     月份
     * @return
     */
//    @RequestMapping(value = "/getCheckFlag", method = RequestMethod.GET)
//    @ResponseBody
//    private CommonResponse<String> getCheckFlag(Long projectId, String checkMonth) {
//        logger.info("getCheckFlag进来了:"+projectId+"@"+"checkMonth"+checkMonth);
//        checkService.getCheckFlag(projectId, checkMonth);
//        return CommonResponse.success("查询成功");
//    }
    /**
     * @Description 月度成本分析物资结存单据更新归集状态字段
     *
     * @param projectId 项目id
     * @param checkMonth 要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @RequestMapping(value = "/getCheckFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getCheckFlag(Long projectId, String checkMonth){
        logger.info("getCheckFlag进来了:"+projectId+"@"+"checkMonth"+checkMonth);
        String checkFlag = checkService.getCheckFlag(projectId, checkMonth);
        return CommonResponse.success("更新归集状态成功");
    }
    /**
     * @Description 月度成本分析物资结存单据更新归集状态字段
     *
     * @param projectId 项目id
     * @param state    归集状态
     * @param checkMonth 要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @RequestMapping(value = "/updateSettlementState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateSettlementState(Long projectId, Integer state, String checkMonth){
        checkService.updateSettlementState(projectId, state, checkMonth);
        return CommonResponse.success("更新归集状态成功");
    }

    /**
     * @Description 根据物资验收入库id更新引用状态
     *
     * @param ids 物资验收入库id
     *            useStatus 占用状态 1-未占用,2-全部占用
     **/
    @RequestMapping(value = "/updateWareHousingUseStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateWareHousingUseStatus(@RequestBody GatherSendVO gatherSendVO){
        materialWarehousingService.updateWareHousingUseStatus(gatherSendVO);
        return CommonResponse.success("更新引用状态成功");
    }
}
