package com.ejianc.business.material.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.MaterialapproachEntity;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.service.IMaterialapproachService;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.foundation.material.vo.MaterialapproachVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资结存
 *
 * @author generator
 */
@Controller
@RequestMapping("api/materialapproach")
public class MaterialapproachApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialapproachService materialapproachService;
    @Autowired
    private IMaterialapproachdetailService materialapproachdetailService;

    /**
     * 推送
     */
    @PostMapping(value = "/push")
    public CommonResponse<Long> push(@RequestBody MaterialapproachVO materialapproachVO) {
        logger.error("materialapproach push is " + JSONObject.toJSONString(materialapproachVO));
        MaterialapproachVO vo = materialapproachService.saveOrUpdate(materialapproachVO);
        MaterialapproachEntity materialapproachEntity = BeanMapper.map(vo, MaterialapproachEntity.class);
        BigDecimal num = new BigDecimal(0.00);
        if (materialapproachEntity.getMaterialapproachdetailEntities() != null) {
            for (MaterialapproachdetailEntity entity : materialapproachEntity.getMaterialapproachdetailEntities()) {
                //汇总未入库数量
                num = num.add(entity.getVerificationCount());
                //将子表验证数量更新到未入库数量
                entity.setNotStorageNum(entity.getVerificationCount());
                materialapproachdetailService.updateById(entity);
            }
            materialapproachEntity.setNotStorageNum(num);
            materialapproachEntity.setApproveTime(new Date());
            materialapproachService.updateById(materialapproachEntity);
        }
        return CommonResponse.success("推送成功！", vo.getId());
    }

    /**
     * @Description 查询详情
     **/
    @RequestMapping(value = "/queryByCheckId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialapproachVO> queryByCheckId(@RequestParam(value = "checkId") Long checkId) {
        logger.error("queryByCheckId push is " + JSONObject.toJSONString(checkId));
        LambdaQueryWrapper<MaterialapproachEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MaterialapproachEntity::getSourceId, checkId);
        MaterialapproachEntity entity = materialapproachService.getOne(queryWrapper, false);
        return CommonResponse.success("查询详情！", entity == null ? null : BeanMapper.map(entity, MaterialapproachVO.class));
    }

    /**
     * @Description 查询详情
     **/
    @RequestMapping(value = "/delPush", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delPush(@RequestParam(value = "checkId") Long checkId) {
        logger.error("delPush push is " + JSONObject.toJSONString(checkId));
        LambdaQueryWrapper<MaterialapproachEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MaterialapproachEntity::getSourceId, checkId);
        boolean remove = materialapproachService.remove(queryWrapper);
        return CommonResponse.success("删除完成！");
    }
    /**
     * 获取验收量--总计划使用
     **/
    @RequestMapping(value = "/getNumByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<Long, BigDecimal>> getNumByProjectId(@RequestParam(value = "projectId") Long projectId) {
        LambdaQueryWrapper<MaterialapproachEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MaterialapproachEntity::getProjectId, projectId);
        queryWrapper.eq(MaterialapproachEntity::getContractType, 0);
        queryWrapper.in(MaterialapproachEntity::getBillState, 1,3);
        List<MaterialapproachEntity> materialapproachEntities = materialapproachService.list(queryWrapper);
        Map<Long, BigDecimal> numMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(materialapproachEntities)){
            List<Long> ids = materialapproachEntities.stream().map(MaterialapproachEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<MaterialapproachdetailEntity> queryWrapperDetail = Wrappers.lambdaQuery();
            queryWrapperDetail.in(MaterialapproachdetailEntity::getMid, ids);
            List<MaterialapproachdetailEntity> materialapproachdetailEntityList = materialapproachdetailService.list(queryWrapperDetail);
            if (CollectionUtils.isNotEmpty(materialapproachdetailEntityList)){
                numMap = materialapproachdetailEntityList.stream().filter(s -> s.getVerificationCount() != null).collect(Collectors.groupingBy(MaterialapproachdetailEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getVerificationCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
        }
        return CommonResponse.success(numMap);
    }
}
