package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.DeviceexitrecordsdetailEntity;
import com.ejianc.business.material.service.IDeviceexitrecordsdetailService;
import com.ejianc.business.material.vo.DeviceexitrecordsdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备退场子表导入导出
 */
@Controller
@RequestMapping("deviceexitrecordsdetailExport")
public class ExcelDeviceexitrecordsdetailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeviceexitrecordsdetailService service;
    /**
     * 导出模板下载
     */
    @RequestMapping(value = "/downloadDeviceexitrecordsdetail")
    @ResponseBody
    public void downloadDeviceexitrecordsdetail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Deviceexitrecordsdetail-import.xlsx", "物资退场记录明细");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportDeviceexitrecordsdetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportDeviceexitrecordsdetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DeviceexitrecordsdetailVO> successList = new ArrayList<>();
        List<DeviceexitrecordsdetailVO> errorList = new ArrayList<>();
        Map<String, DeviceexitrecordsdetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String name = datas.get(0);
                    String spec = datas.get(1);
                    String unit = datas.get(2);
                    String exitCount = datas.get(3);//
                    String remarks = datas.get(4);
                    //循环进来TPID
                    DeviceexitrecordsdetailVO DeviceexitrecordsdetailVO = new DeviceexitrecordsdetailVO();
                    DeviceexitrecordsdetailVO.setId(IdWorker.getId());//id
                    DeviceexitrecordsdetailVO.setRemarks(remarks);

                    //三目判断值是否空
                    DeviceexitrecordsdetailVO.setName(StringUtils.isNotBlank(name) ? name : null);
                    DeviceexitrecordsdetailVO.setSpec(StringUtils.isNotBlank(spec) ? spec : null);
                    DeviceexitrecordsdetailVO.setUnit(StringUtils.isNotBlank(unit) ? unit : null);
                    DeviceexitrecordsdetailVO.setRemarks(StringUtils.isNotBlank(remarks) ? remarks : null);
                    //必填项校验
//                    if (name == null || TextUtils.isEmpty(name)) {
//                        MaterialapproachdetailVO.setErrorMsg("物资名称不能为空！");
//                        errorsMsgBuilder.append("物资名称不能为空！");
//                    }

                    //格式校验
                    if (!TextUtils.isEmpty(exitCount) && !NumberUtil.isNumber(exitCount)) {
                        DeviceexitrecordsdetailVO.setErrorMsg("退场数量格式不正确！");
                        errorsMsgBuilder.append("退场数量格式不正确！");
                    } else {
                        DeviceexitrecordsdetailVO.setExitCount(StringUtils.isNotBlank(exitCount) ? new BigDecimal(exitCount) : null); //退场数量
                    }
                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(DeviceexitrecordsdetailVO);
                    }else {
                        successList.add(DeviceexitrecordsdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        DeviceexitrecordsdetailVO resVo = new DeviceexitrecordsdetailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDeviceexitrecordsdetailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDeviceexitrecordsdetailFromDatabase(@RequestBody DeviceexitrecordsdetailVO DeviceexitrecordsdetailVO, HttpServletResponse response) {
        QueryWrapper<DeviceexitrecordsdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", DeviceexitrecordsdetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<DeviceexitrecordsdetailEntity> list = service.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Deviceexitrecordsdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDeviceexitrecordsdetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDeviceexitrecordsdetailFromPage(@RequestBody List<DeviceexitrecordsdetailVO> list, HttpServletResponse response) {
        List<DeviceexitrecordsdetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                DeviceexitrecordsdetailVO DeviceexitrecordsdetailVO = list.get(i);
                concatList.add(DeviceexitrecordsdetailVO);
            }
        }

        //children拍平
//        List<MaterialapproachdetailVO> allList = handleList(list, concatList);
        List<DeviceexitrecordsdetailVO> allList = handleList(list,concatList );

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Deviceexitrecordsdetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<DeviceexitrecordsdetailVO> handleList(List<DeviceexitrecordsdetailVO> list, List<DeviceexitrecordsdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            DeviceexitrecordsdetailVO DeviceexitrecordsdetailVO = list.get(i);
            List<DeviceexitrecordsdetailVO> children = DeviceexitrecordsdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
