package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.EquipmentdetailEntity;
import com.ejianc.business.material.service.IEquipmentdetailService;
import com.ejianc.business.material.vo.EquipmentdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 分公司闲置设备物资情况一览表子表导入导出
 */
@Controller
@RequestMapping("equipmentdetailExport")
public class ExcelEquipmentdetailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEquipmentdetailService service;
    /**
     * 导出模板下载
     */
    @RequestMapping(value = "/downloadEquipmentdetail")
    @ResponseBody
    public void downloadEquipmentdetail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Equipmentdetail-import.xlsx", "分公司闲置设备物资情况一览表清单模板");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportEquipmentdetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportEquipmentdetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<EquipmentdetailVO> successList = new ArrayList<>();
        List<EquipmentdetailVO> errorList = new ArrayList<>();
        Map<String, EquipmentdetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String sort = datas.get(0);
                    String name = datas.get(1);
                    String spec = datas.get(2);
                    String manufacturerBrand = datas.get(3);
                    String idleCount = datas.get(4);
                    String depreciation = datas.get(5);
                    String purchasePrice = datas.get(6);
                    String residual = datas.get(7);
                    String estimate = datas.get(8);
                    String idleTime = datas.get(9);
                    String remarks = datas.get(10);
                    //循环进来TPID
                    EquipmentdetailVO EquipmentdetailVO = new EquipmentdetailVO();
                    EquipmentdetailVO.setId(IdWorker.getId());//id
                    //三目判断值是否空
                    EquipmentdetailVO.setSort(StringUtils.isNotBlank(sort) ? sort : null);
                    EquipmentdetailVO.setName(StringUtils.isNotBlank(name) ? name : null);
                    EquipmentdetailVO.setSpec(StringUtils.isNotBlank(spec) ? spec : null);
                    EquipmentdetailVO.setManufacturerBrand(StringUtils.isNotBlank(manufacturerBrand) ? manufacturerBrand : null);
                    EquipmentdetailVO.setIdleTime(StringUtils.isNotBlank(idleTime) ? idleTime : null);
                    EquipmentdetailVO.setRemarks(StringUtils.isNotBlank(remarks) ? remarks : null); // 备注
                    //必填项校验
                    if (name == null || TextUtils.isEmpty(name)) {
                        EquipmentdetailVO.setErrorMsg("物资名称不能为空！");
                        errorsMsgBuilder.append("物资名称不能为空！");
                    }

                    //格式校验
                    if (!TextUtils.isEmpty(idleCount) && !NumberUtil.isNumber(idleCount)) {
                        EquipmentdetailVO.setErrorMsg("限制数量格式不正确！");
                        errorsMsgBuilder.append("限制数量格式不正确！");
                    } else {
                        EquipmentdetailVO.setIdleCount(StringUtils.isNotBlank(idleCount) ? new BigDecimal(idleCount) : null);
                    }
                    if (!TextUtils.isEmpty(depreciation) && !NumberUtil.isNumber(depreciation)) {
                        EquipmentdetailVO.setErrorMsg("折旧率（*%）格式不正确！");
                        errorsMsgBuilder.append("折旧率（*%）格式不正确！");
                    } else {
                        EquipmentdetailVO.setDepreciation(StringUtils.isNotBlank(depreciation) ? new BigDecimal(depreciation) : null);
                    }
                    if (!TextUtils.isEmpty(purchasePrice) && !NumberUtil.isNumber(purchasePrice)) {
                        EquipmentdetailVO.setErrorMsg("采购单价格式不正确！");
                        errorsMsgBuilder.append("采购单价格式不正确！");
                    } else {
                        EquipmentdetailVO.setPurchasePrice(StringUtils.isNotBlank(purchasePrice) ? new BigDecimal(purchasePrice) : null);
                    }
                    if (!TextUtils.isEmpty(residual) && !NumberUtil.isNumber(residual)) {
                        EquipmentdetailVO.setErrorMsg("预估残值格式不正确！");
                        errorsMsgBuilder.append("预估残值格式不正确！");
                    } else {
                        EquipmentdetailVO.setResidual(StringUtils.isNotBlank(residual) ? new BigDecimal(residual) : null);
                    }
                    if (!TextUtils.isEmpty(estimate) && !NumberUtil.isNumber(estimate)) {
                        EquipmentdetailVO.setErrorMsg("预估总价格式不正确！");
                        errorsMsgBuilder.append("预估总价格式不正确！");
                    } else {
                        EquipmentdetailVO.setEstimate(StringUtils.isNotBlank(estimate) ? new BigDecimal(estimate) : null);
                    }
                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(EquipmentdetailVO);
                    }else {
                        successList.add(EquipmentdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        EquipmentdetailVO resVo = new EquipmentdetailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportEquipmentdetailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportEquipmentdetailFromDatabase(@RequestBody EquipmentdetailVO EquipmentdetailVO, HttpServletResponse response) {
        QueryWrapper<EquipmentdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", EquipmentdetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<EquipmentdetailEntity> list = service.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Equipmentdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportEquipmentdetailExportFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportEquipmentdetailFromPage(@RequestBody List<EquipmentdetailVO> list, HttpServletResponse response) {
        List<EquipmentdetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                EquipmentdetailVO EquipmentdetailVO = list.get(i);
                switch (EquipmentdetailVO.getSort()) {
                    case "K1667821075161":
                        EquipmentdetailVO.setSort("工程物资");
                        break;
                    case "K1667821144441":
                        EquipmentdetailVO.setSort("测量设备");
                        break;
                    case "K1667821147488":
                        EquipmentdetailVO.setSort("行政物资");
                        break;
                }
                concatList.add(EquipmentdetailVO);
            }
        }

        //children拍平
        List<EquipmentdetailVO> allList = handleList(list, concatList);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Equipmentdetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<EquipmentdetailVO> handleList(List<EquipmentdetailVO> list, List<EquipmentdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            EquipmentdetailVO EquipmentdetailVO = list.get(i);
            List<EquipmentdetailVO> children = EquipmentdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
