package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.SurplusmaterialapprovetailEntity;
import com.ejianc.business.material.service.ISurplusmaterialapprovetailService;
import com.ejianc.business.material.vo.SurplusmaterialapprovetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 剩余/废旧物资评估确认及处置审批表子表导入导出
 */
@Controller
@RequestMapping("surplusmaterialapprovetailExport")
public class ExcelSurplusmaterialapprovetailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISurplusmaterialapprovetailService service;
    /**
     * 导出模板下载
     */
    @RequestMapping(value = "/downloadSurplusmaterialapprovetail")
    @ResponseBody
    public void downloadSurplusmaterialapprovetail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Surplusmaterialapprovetail-import.xlsx", "计划成本-指标分析明细清单模板");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportSurplusmaterialapprovetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSurplusmaterialapprovetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SurplusmaterialapprovetailVO> successList = new ArrayList<>();
        List<SurplusmaterialapprovetailVO> errorList = new ArrayList<>();
        Map<String, SurplusmaterialapprovetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();
                    String materialCode = datas.get(0);
                    String materialName = datas.get(1);
                    String materialSpecifications = datas.get(2);
                    String materialUnit = datas.get(3);
                    String materialNumber = datas.get(4);
                    String temporaryMoney = datas.get(5);
                    String remarks = datas.get(6);
                    //循环进来TPID
                    SurplusmaterialapprovetailVO SurplusmaterialapprovetailVO = new SurplusmaterialapprovetailVO();
                    SurplusmaterialapprovetailVO.setId(IdWorker.getId());//id
                    //三目判断值是否空
                    SurplusmaterialapprovetailVO.setMaterialCode(StringUtils.isNotBlank(materialCode) ? materialCode : null);//物资编码
                    SurplusmaterialapprovetailVO.setMaterialName(StringUtils.isNotBlank(materialName) ? materialName : null);//物资名称
                    SurplusmaterialapprovetailVO.setMaterialSpecifications(StringUtils.isNotBlank(materialSpecifications) ? materialSpecifications : null);
                    SurplusmaterialapprovetailVO.setMaterialUnit(StringUtils.isNotBlank(materialUnit) ? materialUnit : null); //单位
                    SurplusmaterialapprovetailVO.setRemarks(StringUtils.isNotBlank(remarks) ? remarks : null); // 备注
                    //必填项校验
                    if (materialName == null || TextUtils.isEmpty(materialName)) {
                        SurplusmaterialapprovetailVO.setErrorMsg("物资名称不能为空！");
                        errorsMsgBuilder.append("物资名称不能为空！");
                    }
                    if (materialCode == null || TextUtils.isEmpty(materialCode)) {
                        SurplusmaterialapprovetailVO.setErrorMsg("物资编码不能为空！");
                        errorsMsgBuilder.append("物资编码不能为空！");
                    }
                    //格式校验
                    if (!TextUtils.isEmpty(materialNumber) && !NumberUtil.isNumber(materialNumber)) {
                        SurplusmaterialapprovetailVO.setErrorMsg("数量格式不正确！");
                        errorsMsgBuilder.append("数量格式不正确！");
                    } else {
                        SurplusmaterialapprovetailVO.setMaterialNumber(StringUtils.isNotBlank(materialNumber) ? new BigDecimal(materialNumber) : null); //投标指标
                    }
                    if (!TextUtils.isEmpty(temporaryMoney) && !NumberUtil.isNumber(temporaryMoney)) {
                        SurplusmaterialapprovetailVO.setErrorMsg("暂估金额格式不正确！");
                        errorsMsgBuilder.append("暂估金额格式不正确！");
                    } else {
                        SurplusmaterialapprovetailVO.setTemporaryMoney(StringUtils.isNotBlank(temporaryMoney) ? new BigDecimal(temporaryMoney) : null); //（计划成本）限额设计指标
                    }
                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(SurplusmaterialapprovetailVO);
                    }else {
                        successList.add(SurplusmaterialapprovetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        SurplusmaterialapprovetailVO resVo = new SurplusmaterialapprovetailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSurplusmaterialapprovetailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSurplusmaterialapprovetailFromDatabase(@RequestBody SurplusmaterialapprovetailVO SurplusmaterialapprovetailVO, HttpServletResponse response) {
        QueryWrapper<SurplusmaterialapprovetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", SurplusmaterialapprovetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<SurplusmaterialapprovetailEntity> list = service.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Surplusmaterialapprovetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSurplusmaterialapprovetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSurplusmaterialapprovetailFromPage(@RequestBody List<SurplusmaterialapprovetailVO> list, HttpServletResponse response) {
        List<SurplusmaterialapprovetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SurplusmaterialapprovetailVO SurplusmaterialapprovetailVO = list.get(i);
                concatList.add(SurplusmaterialapprovetailVO);
            }
        }

        //children拍平
        List<SurplusmaterialapprovetailVO> allList = handleList(list, concatList);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Surplusmaterialapprovetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<SurplusmaterialapprovetailVO> handleList(List<SurplusmaterialapprovetailVO> list, List<SurplusmaterialapprovetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            SurplusmaterialapprovetailVO SurplusmaterialapprovetailVO = list.get(i);
            List<SurplusmaterialapprovetailVO> children = SurplusmaterialapprovetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
