package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.SurplusmaterialapprovetailEntity;
import com.ejianc.business.material.bean.WastematerialresulttailEntity;
import com.ejianc.business.material.service.ISurplusmaterialapprovetailService;
import com.ejianc.business.material.service.IWastematerialresulttailService;
import com.ejianc.business.material.vo.SurplusmaterialapprovetailVO;
import com.ejianc.business.material.vo.WastematerialresultReportVO;
import com.ejianc.business.material.vo.WastematerialresulttailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 废旧物资处置结果确认表导入导出
 */
@Controller
@RequestMapping("wastematerialresulttailExport")
public class ExcelWastematerialresulttailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWastematerialresulttailService service;
    /**
     * 导出模板下载
     */
    @RequestMapping(value = "/downloadWastematerialresulttail")
    @ResponseBody
    public void downloadWastematerialresulttail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Wastematerialresulttail-import.xlsx", "废旧物资处置结果确认表模板");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportWastematerialresulttail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportWastematerialresulttail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<WastematerialresulttailVO> successList = new ArrayList<>();
        List<WastematerialresulttailVO> errorList = new ArrayList<>();
        Map<String, WastematerialresulttailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();
                    String materialCode = datas.get(0);
                    String materialName = datas.get(1);
                    String materialUnit = datas.get(2);
                    String materialNumber = datas.get(3);
                    String unitPrice = datas.get(4);
                    String dealMoney = datas.get(5);
                    //循环进来TPID
                    WastematerialresulttailVO WastematerialresulttailVO = new WastematerialresulttailVO();
                    WastematerialresulttailVO.setId(IdWorker.getId());//id
                    //三目判断值是否空
                    WastematerialresulttailVO.setMaterialCode(StringUtils.isNotBlank(materialCode) ? materialCode : null);//物资编码
                    WastematerialresulttailVO.setMaterialName(StringUtils.isNotBlank(materialName) ? materialName : null);
                    WastematerialresulttailVO.setMaterialUnit(StringUtils.isNotBlank(materialUnit) ? materialUnit : null); //单位
                    //必填项校验
                    if (materialName == null || TextUtils.isEmpty(materialName)) {
                        WastematerialresulttailVO.setErrorMsg("物资名称不能为空！");
                        errorsMsgBuilder.append("物资名称不能为空！");
                    }
                    if (materialCode == null || TextUtils.isEmpty(materialCode)) {
                        WastematerialresulttailVO.setErrorMsg("物资编码不能为空！");
                        errorsMsgBuilder.append("物资编码不能为空！");
                    }
                    //格式校验
                    if (!TextUtils.isEmpty(materialNumber) && !NumberUtil.isNumber(materialNumber)) {
                        WastematerialresulttailVO.setErrorMsg("数量格式不正确！");
                        errorsMsgBuilder.append("数量格式不正确！");
                    } else {
                        WastematerialresulttailVO.setMaterialNumber(StringUtils.isNotBlank(materialNumber) ? new BigDecimal(materialNumber) : null); //
                    }
                    if (!TextUtils.isEmpty(unitPrice) && !NumberUtil.isNumber(unitPrice)) {
                        WastematerialresulttailVO.setErrorMsg("单价格式不正确！");
                        errorsMsgBuilder.append("单价格式不正确！");
                    } else {
                        WastematerialresulttailVO.setUnitPrice(StringUtils.isNotBlank(unitPrice) ? new BigDecimal(unitPrice) : null); //
                    }
                    if (!TextUtils.isEmpty(dealMoney) && !NumberUtil.isNumber(dealMoney)) {
                        WastematerialresulttailVO.setErrorMsg("处理金额格式不正确！");
                        errorsMsgBuilder.append("处理金额格式不正确！");
                    } else {
                        WastematerialresulttailVO.setDealMoney(StringUtils.isNotBlank(dealMoney) ? new BigDecimal(dealMoney) : null); //
                    }
                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(WastematerialresulttailVO);
                    }else {
                        successList.add(WastematerialresulttailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        WastematerialresulttailVO resVo = new WastematerialresulttailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportWastematerialresulttailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportWastematerialresulttailFromDatabase(@RequestBody WastematerialresulttailVO WastematerialresulttailVO, HttpServletResponse response) {
        QueryWrapper<WastematerialresulttailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", WastematerialresulttailVO.getId());
        queryWrapper.eq("dr", 0);
        List<WastematerialresulttailEntity> list = service.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Wastematerialresulttail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportWastematerialresulttailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportWastematerialresulttailFromPage(@RequestBody List<WastematerialresulttailVO> list, HttpServletResponse response) {
        List<WastematerialresulttailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                WastematerialresulttailVO WastematerialresulttailVO = list.get(i);
                concatList.add(WastematerialresulttailVO);
            }
        }

        //children拍平
        List<WastematerialresulttailVO> allList = handleList(list, concatList);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Wastematerialresulttail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportWastematerialresultReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportWastematerialresultReport(@RequestBody List<WastematerialresultReportVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WastematerialresultReport-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<WastematerialresulttailVO> handleList(List<WastematerialresulttailVO> list, List<WastematerialresulttailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            WastematerialresulttailVO WastematerialresulttailVO = list.get(i);
            List<WastematerialresulttailVO> children = WastematerialresulttailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
