package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.MaterialWarehousingdetailEntity;
import com.ejianc.business.material.service.IMaterialWarehousingdetailService;
import com.ejianc.business.material.vo.MaterialWarehousingVO;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;
import com.ejianc.business.material.vo.MaterialsreturndetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 物资验收入库单导入导出
 */
@Controller
@RequestMapping("materialWarehousingdetailExport")
public class ExeclMaterialWarehousingController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IMaterialWarehousingdetailService iMaterialWarehousingdetailService;


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaterialWarehousingdetail")
    @ResponseBody
    public void downloadMaterialWarehousingdetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "materialWarehousingdetail-import.xlsx", "物资验收入库单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportMaterialWarehousingdetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialWarehousingdetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialWarehousingdetailVO> successList = new ArrayList<>();
        List<MaterialWarehousingdetailVO> errorList = new ArrayList<>();
        Map<String, MaterialWarehousingdetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();
                    String materialCategoryCode = datas.get(0);
                    String materialCategoryName = datas.get(1);
                    String materialCode = datas.get(2);
                    String materialName = datas.get(3);
                    String specialModel = datas.get(4);
                    String unit = datas.get(5);
                    String quantity = datas.get(6);
                    String unitPriceIncluetax = datas.get(7);
                    String taxRate = datas.get(8);
                    String unitPriceExcluetax = datas.get(9);
                    String amountIncluetax = datas.get(10);
                    String amountExcluetax = datas.get(11);
                    String quantityNum =datas.get(12);

                    //循环进来TPID
                    MaterialWarehousingdetailVO materialWarehousingdetailVO = new MaterialWarehousingdetailVO();
                    materialWarehousingdetailVO.setId(IdWorker.getId());//id

                    //三目判断值是否空
                    materialWarehousingdetailVO.setMaterialCategoryCode(StringUtils.isNotBlank(materialCategoryCode) ? materialCategoryCode : null);
                    materialWarehousingdetailVO.setMaterialCategoryName(StringUtils.isNotBlank(materialCategoryName) ? materialCategoryName : null);
                    materialWarehousingdetailVO.setMaterialCode(StringUtils.isNotBlank(materialCode) ? materialCode : null);
                    materialWarehousingdetailVO.setMaterialName(StringUtils.isNotBlank(materialName) ? materialName : null);
                    materialWarehousingdetailVO.setSpecialModel(StringUtils.isNotBlank(specialModel) ? specialModel : null);
                    materialWarehousingdetailVO.setUnit(StringUtils.isNotBlank(unit) ? unit : null);
                   // costpeopledetailVO.setTid(String.valueOf(IdWorker.getId()));//tid
                    //三目判断值是否空
//                    costpeopledetailVO.setCode(StringUtils.isNotBlank(code) ? code : null); // 编码
//                    costpeopledetailVO.setSection(StringUtils.isNotBlank(section) ? section : null); // 区段
//                    costpeopledetailVO.setProjectName(StringUtils.isNotBlank(projectName) ? projectName : null); // 分部分项名称/子目名称
//                   costpeopledetailVO.setUnit(StringUtils.isNotBlank(unit) ? unit : null); // 单位
                    //materialWarehousingdetailVO.setRemarks(StringUtils.isNotBlank(remarks) ? remarks : null); // 备注
                    //必填项校验
//                    if (code == null || TextUtils.isEmpty(code)) {
//                        costpeopledetailVO.setErrorMsg("编码不能为空！");
//                        errorsMsgBuilder.append("编码不能为空！");
//                    }
//                    if (section == null || TextUtils.isEmpty(section)) {
//                        costpeopledetailVO.setErrorMsg("区段不能为空！");
//                        errorsMsgBuilder.append("区段不能为空！");
//                    }

//                    if(code != null){
//                        costpeopledetailVO.setCode(code + "_" + code);//子目编码、区段、确定唯一性
//                        if ("01".equals(code) && projectName != null && projectName.contains("装饰")) {
//                            costpeopledetailVO.setCode("a1" + "_" + costpeopledetailVO.getSection());
//                        }
//                        //判断是否是装饰工程的子节点编码
//                        if (code.length() >= 4) {
//                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
//                            String code1 = code.substring(0, 4);
//                            if ("0111".equals(code1) || "0112".equals(code1) || "0113".equals(code1) || "0114".equals(code1) || "0115".equals(code1)) {
//                                //若是的话，将内码改为a1xx
//                                costpeopledetailVO.setCode("a1" + code.substring(2, code.length()) + "_" + section);
//                            }
//                        }
//                        //1、校验编码是否符合规则--2、4、6、9、9以上
//                        if (code == null || !(code.length() == 2 || code.length() == 4 || code.length() == 6 || code.length() >= 9)) {
//                            costpeopledetailVO.setErrorMsg("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
//                            errorsMsgBuilder.append("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
//                        }
//                        costpeopledetailVO.setCode(code);
//
//                        //重复性校验
//                        CostpeopledetailVO mapVO = map.get(costpeopledetailVO.getCode());
//                        if(mapVO == null){
//                            map.put(costpeopledetailVO.getCode(), costpeopledetailVO);
//                        }else {
//                            costpeopledetailVO.setErrorMsg("子目编码已存在！");
//                            errorsMsgBuilder.append("子目编码已存在！");
//                        }
//                        costpeopledetailVO.setCode(code);
//                    }
                    //格式校验
                    if (!TextUtils.isEmpty(quantity) && !NumberUtil.isNumber(quantity)) {
                        materialWarehousingdetailVO.setErrorMsg("数量格式不正确！");
                        errorsMsgBuilder.append("数量格式不正确！");
                    } else {
                        materialWarehousingdetailVO.setQuantity(StringUtils.isNotBlank(quantity) ? new BigDecimal(quantity) : null);
                    }

                    if (!TextUtils.isEmpty(unitPriceIncluetax) && !NumberUtil.isNumber(unitPriceIncluetax)) {
                        materialWarehousingdetailVO.setErrorMsg("单价（含税）（元）格式不正确！");
                        errorsMsgBuilder.append("单价（含税）（元）格式不正确！");
                    } else {
                        materialWarehousingdetailVO.setUnitPriceIncluetax(StringUtils.isNotBlank(unitPriceIncluetax) ? new BigDecimal(unitPriceIncluetax) : null);
                    }
                    if (!TextUtils.isEmpty(taxRate) && !NumberUtil.isNumber(taxRate)) {
                        materialWarehousingdetailVO.setErrorMsg("税率格式不正确！");
                        errorsMsgBuilder.append("税率格式不正确！");
                    } else {
                        materialWarehousingdetailVO.setTaxRate(StringUtils.isNotBlank(taxRate) ? new BigDecimal(taxRate) : null);
                    }
//                    if (!TextUtils.isEmpty(unitPriceExcluetax) && !NumberUtil.isNumber(unitPriceExcluetax)) {
//                        materialWarehousingdetailVO.setErrorMsg("单价（无税）格式不正确！");
//                        errorsMsgBuilder.append("单价（无税）格式不正确！");
//                    } else {
//                        materialWarehousingdetailVO.setUnitPriceExcluetax(StringUtils.isNotBlank(unitPriceExcluetax) ? new BigDecimal(unitPriceExcluetax) : null);
//                    }
                    //税率
                    BigDecimal taxRateCul = materialWarehousingdetailVO.getTaxRate() == null ? new BigDecimal(0) : materialWarehousingdetailVO.getTaxRate().subtract(new BigDecimal(100));
                    //单价含税
                    BigDecimal unitPriceIncluetaxCul = materialWarehousingdetailVO.getUnitPriceIncluetax() == null ? new BigDecimal(0) : materialWarehousingdetailVO.getUnitPriceIncluetax();
                    //单价（无税） = 单价含税*（1+税率）;
                    BigDecimal unitPriceExcluetaxCul = unitPriceIncluetaxCul.multiply(new BigDecimal(1).add(taxRateCul));
                    materialWarehousingdetailVO.setUnitPriceExcluetax(unitPriceExcluetaxCul);

                    if (!TextUtils.isEmpty(amountIncluetax) && !NumberUtil.isNumber(amountIncluetax)) {
                        materialWarehousingdetailVO.setErrorMsg("金额（含税）格式不正确！");
                        errorsMsgBuilder.append("金额（含税）格式不正确！");
                    } else {
                        materialWarehousingdetailVO.setAmountIncluetax(StringUtils.isNotBlank(amountIncluetax) ? new BigDecimal(amountIncluetax) : null);
                    }


//                    if (!TextUtils.isEmpty(amountExcluetax) && !NumberUtil.isNumber(amountExcluetax)) {
//                        materialWarehousingdetailVO.setErrorMsg("金额（无税）格式不正确！");
//                        errorsMsgBuilder.append("金额（无税）格式不正确！");
//                    } else {
//                        materialWarehousingdetailVO.setAmountExcluetax(StringUtils.isNotBlank(amountExcluetax) ? new BigDecimal(amountExcluetax) : null);
//                    }
                    //数量
                    BigDecimal quantityCul = materialWarehousingdetailVO.getQuantity() == null ? new BigDecimal(0) : materialWarehousingdetailVO.getQuantity();
                    //金额（无税）
                    materialWarehousingdetailVO.setAmountExcluetax(unitPriceExcluetaxCul.multiply(quantityCul));

                    if (!TextUtils.isEmpty(quantityNum) && !NumberUtil.isNumber(quantityNum)) {
                        materialWarehousingdetailVO.setErrorMsg("格式不正确！");
                        errorsMsgBuilder.append("质量证明号格式不正确！");
                    } else {
                        materialWarehousingdetailVO.setQuantityNum(StringUtils.isNotBlank(quantityNum) ? new String(quantityNum) : null);
                    }


                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(materialWarehousingdetailVO);
                    }else {
                        successList.add(materialWarehousingdetailVO);
                    }
                }
            }
        }
//        //按子目编码排序
//        Collections.sort(successList, new Comparator<CostpeopledetailVO>() {
//            @Override
//            public int compare(CostpeopledetailVO o1, CostpeopledetailVO o2) {
//                return (o1.getCode()+o1.getSection()).compareTo(o2.getCode()+o2.getSection());
//            }
//        });
//
//        //设置tid和tpid
//        List<CostpeopledetailVO> resList = setTidAndTpid(successList, map);
//
//        //构建树
//        resList = createTreeData(resList);

        //统计父级的合计数值
//        getChildrenUnitTotalAmount(resList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        MaterialWarehousingdetailVO resVo = new MaterialWarehousingdetailVO();
        json.put("total", successList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

//    private List<MaterialWarehousingdetailVO> setTidAndTpid(List<MaterialWarehousingdetailVO> vos, Map<String, MaterialWarehousingdetailVO> map) {
//        if(vos == null){
//            return null;
//        }
//
//        for (int i = 0; i < vos.size(); i++) {
//            CostpeopledetailVO costpeopledetailVO = vos.get(i);
//            //设置父级id
//            String innercode = costpeopledetailVO.getCode();
//            String[] innercodeSubArr = innercode.split("_");
//            String innercodeSub = "";
//            String sectionSuf = "";
//            if (innercodeSubArr.length > 1) {
//                innercodeSub = innercodeSubArr[0];
//                sectionSuf = "_" + innercodeSubArr[1];
//            }
//
//            Long pid = null;
//            if (innercodeSub.length() == 2) {
//                //最上级
//            } else if (innercodeSub.length() == 4) {
//                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
//                //有父节点
//                pid = this.setPid(pcode, map);
//            } else if (innercodeSub.length() == 6) {
//                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
//                //有父节点
//                pid = this.setPid(pcode, map);
//            } else if (innercodeSub.length() > 6) {
//                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
//                //有父节点
//                pid = this.setPid(pcode, map);
//            }
//
//            if (pid != null) {
//                costpeopledetailVO.setTpid(pid.toString());
//            } else {
//                costpeopledetailVO.setTpid("");
//            }
//        }
//
//        return vos;
//    }

/*    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, CostpeopledetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }*/


/*
    */
/**
     * 构建树
     *
     * @param list
     * @return
     *//*

    public static List<CostpeopledetailVO> createTreeData(List<CostpeopledetailVO> list) {
        List<CostpeopledetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, CostpeopledetailVO> listMap = new HashMap<>();
        for (CostpeopledetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            CostpeopledetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            CostpeopledetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<CostpeopledetailVO> child = (List<CostpeopledetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<CostpeopledetailVO> children = new ArrayList<CostpeopledetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
*/



    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialWarehousingdetailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialWarehousingFromDatabase(@RequestBody MaterialWarehousingdetailVO materialWarehousingdetailVO, HttpServletResponse response) {
        QueryWrapper<MaterialWarehousingdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", materialWarehousingdetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<MaterialWarehousingdetailEntity> list = iMaterialWarehousingdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialWarehousingdetail-export.xlsx", beans, response);
    }



    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialWarehousingdetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialWarehousingFromPage(@RequestBody List<MaterialWarehousingdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialWarehousingdetail-export.xlsx", beans, response);
    }
}
