package com.ejianc.business.material.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.MaterialWarehousingVO;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.material.bean.MaterialWarehousingEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 物资验收入库单
 *
 * @author generator
 *
 */
@Mapper
public interface MaterialWarehousingMapper extends BaseCrudMapper<MaterialWarehousingEntity> {
    Long queryStoreCanUseNumPageDataCount(@Param("searchText") String searchText,
                                          @Param("outDate") String outDate,
                                          @Param("storeId") Long storeId,
                                          @Param("materialTypeName")  String materialTypeName, @Param("materialName") String materialName, @Param("materialSpec") String materialSpec,  @Param("materialUnit") String materialUnit
    );

    MaterialWarehousingVO censusStorematerial(@Param("storeId") Long storeId);

    List<MaterialWarehousingdetailVO> queryStoreCanUseNumPageData(@Param("searchText") String searchText,
                                                        @Param("outDate") String outDate,
                                                        @Param("storeId") Long storeId,
                                                        @Param("startLine") Integer startLine,
                                                        @Param("pageSize") Integer pageSize,
                                                        @Param("materialTypeName")  String materialTypeName, @Param("materialName") String materialName, @Param("materialSpec") String materialSpec, @Param("materialUnit") String materialUnit);

    Long countStorematerialList(@Param("storeId") Long storeId, @Param("searchText") String searchText);

    List<MaterialWarehousingdetailVO> storematerialList(@Param("storeId") Long storeId, @Param("searchText") String searchText,
                                                        @Param("startLine") Integer startLine, @Param("pageSize") Integer pageSize);

    BigDecimal countAmount(@Param(Constants.WRAPPER) QueryWrapper<MaterialWarehousingEntity> queryWrapper);

    Long queryUsableSubMaterialCount(@Param("searchText") String searchText,
                                     @Param("outDate") String outDate,
                                     @Param("storeId") Long storeId,
                                     @Param("materialIds") List<Long> materialIds,@Param("map") HashMap<String, String> map);

    List<MaterialWarehousingVO> queryUsableSubMaterialPageList(@Param("searchText") String searchText,
                                                           @Param("outDate") String outDate,
                                                           @Param("storeId") Long storeId,
                                                           @Param("startLine") Integer startLine,
                                                           @Param("pageSize") Integer pageSize,
                                                           @Param("materialIds") List<Long> materialIds,@Param("map") HashMap<String, String> map);

    List<MaterialWarehousingVO> querySubMaterialStoreInfo(@Param("storeId") Long storeId, @Param("outDate") Date outDate,
                                                      @Param("materialId") Long materialId, @Param("inventory") double inventory);

    Map<String, BigDecimal> queryStoreLeftMoneyAndMaterialTypeNumByProjectId(@Param("projectId") Long projectId);

    /**
     * @param projectId
     * @param materialIds
     * @description: 根据项目查询已经生效的入库数量
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-27
     */
    List<MaterialPriceVO> queryMaterialInstoreCount(@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

    List<MaterialWarehousingVO> instoreNumCount(Map<String, Object> queryParam);

    List<InstoreAccountSumVO> amountSum(@Param("projectIds") List<Long> projectIds);
}
