package com.ejianc.business.material.mapper;

import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.StoreBalanceDetailEntity;
import com.ejianc.business.material.vo.StoreBalanceDetailVO;
import com.ejianc.business.material.vo.StoreBalanceVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.material.bean.StoreBalanceEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 物资结存
 *
 * @author generator
 *
 */
@Mapper
public interface StoreBalanceMapper extends BaseCrudMapper<StoreBalanceEntity> {
    List<StoreBalanceDetailVO> queryStoreBalanceDetail(@Param("projectId") Long projectId, @Param("month") String month);

    List<com.ejianc.foundation.material.vo.StoreBalanceDetailVO> queryStoreBalanceDetailMonth(@Param("projectId") Long projectId, @Param("month") String month, @Param("materialCategoryCode") String materialCategoryCode);

    List<StoreBalanceDetailEntity> queryDetail(@Param("projectId")Long projectId,@Param("materialCategoryCode")String materialCategoryCode,@Param("materialCode")String materialCode);
    //根据项目和时间查询 出入库明细和结存数量
    List<FlowmeterEntity> queryFlowmeetr(@Param("projectId")Long projectId,@Param("month")String month,@Param("storeId")String storeId);

    /**
     * 根据项目和月度查询物资本月消耗
     * @param projectId  项目id
     * @param month      月度
     * @return
     */
    List<com.ejianc.foundation.material.vo.StoreBalanceDetailVO> queryMaterialConsumeMonth(@Param("projectId") Long projectId, @Param("month") String month);


    /**
     * @Description queryList 查询上个单据中 本月月结存数量大于0的数据
     * @param projectId
     * @Return List
     */
    List<com.ejianc.business.material.vo.StoreBalanceDetailVO> queryLastMonthList(@Param("id") Long id);

    //查询本项目 仓库下所有流水
    List<FlowmeterEntity> queryFlowmeetrAll(@Param("projectId")Long projectId,@Param("month")String month,@Param("storeId")Long storeId);


    StoreBalanceDetailVO queryId(@Param("projectId")Long projectId,@Param("storeId")Long storeId);

    StoreBalanceVO queryMoth(@Param("projectId")Long projectId, @Param("storeId")Long storeId);
}
