package com.ejianc.business.material.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.vo.DeliveryrecordVO;
import com.ejianc.business.material.vo.MaterialWarehousingVO;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;
import com.ejianc.foundation.material.vo.GatherSendVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.material.bean.MaterialWarehousingEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * 物资验收入库单
 *
 * @author generator
 *
 */
public interface IMaterialWarehousingService extends IBaseService<MaterialWarehousingEntity> {

    IPage<MaterialWarehousingdetailVO> queryStoreCanUseNumPageData(String searchText, String searchObject, String outDate,
                                                             Long storeId, Integer pageNum, Integer pageSize);

    IPage<MaterialWarehousingdetailVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize);

    BigDecimal countAmount(QueryParam param);

    MaterialWarehousingVO censusStorematerial(Long storeIid);

    /**
     * 查询指定仓库可用物资列表，相同物资数量、金额合并
     *
     * @param searchText
     * @param outDate
     * @param storeId
     * @param pageNumber
     * @param pageSize
     * @param materialIds
     * @param map
     * @return
     */
    IPage<MaterialWarehousingVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map);

    /**
     * 查询指定物资在指定仓库中的各个入库单中的库存情况，盘点使用
     *
     * @param storeId
     * @param checkDate
     * @param materialId
     * @param inventory
     * @return
     */
    List<MaterialWarehousingVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory);


//    /**
//     * @param vo
//     * @description: 参数校验
//     * @return: com.ejianc.business.finance.vo.ParamsCheckVO
//     * @author songlx
//     * @date: 2021-05-27
//     */
//    ParamsCheckVO checkParams(MaterialPriceVO vo);

    boolean aggPush(MaterialWarehousingEntity materialWarehousingEntity);

    MaterialWarehousingVO saveOrUpdate(MaterialWarehousingVO saveorUpdateVO);

    void updateWareHousingUseStatus(GatherSendVO gatherSendVO);
}
