package com.ejianc.business.material.service;

import com.ejianc.business.material.vo.BigScreenVO;
import com.ejianc.business.material.vo.MonthOrgDetailVO;
import com.ejianc.business.material.vo.MonthProjectDetailVO;
import com.ejianc.business.material.vo.MonthProjectVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.material.bean.MonthProjectEntity;

import java.util.List;

/**
 * 物资消耗月度分析表-项目
 * 
 * @author generator
 * 
 */
public interface IMonthProjectService extends IBaseService<MonthProjectEntity> {

    List<MonthProjectDetailVO> queryDataById(Long projectId,String month);
    List<Long> getListByCode(String code);

    List<MonthOrgDetailVO> queryDetailByOrgId(Long orgId, String month);

    List<BigScreenVO> getInNumByOrgId();

    List<BigScreenVO> getPlanRateByOrgId(Integer type, String month);

    List<BigScreenVO> getDiffRateOrgId(String month);

    List<BigScreenVO> getDiffRateProjectId(Long id);

    List<BigScreenVO> getQuarterData(String year);

    List<BigScreenVO> getSupplierTopTen(String month);
}
