package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.apache.commons.collections.CollectionUtils;
import com.ejianc.business.material.bean.DeviceexitrecordsEntity;
import com.ejianc.business.material.bean.DeviceverificationrecordsEntity;
import com.ejianc.business.material.bean.DeviceverificationrecordsdetailEntity;
import com.ejianc.business.material.service.IDeviceexitrecordsService;
import com.ejianc.business.material.service.IDeviceverificationrecordsService;
import com.ejianc.business.material.service.IDeviceverificationrecordsdetailService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

@Service("deviceverificationrecords")
public class DeviceverificationrecordsBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IDeviceverificationrecordsService deviceverificationrecordsService;
	@Autowired
	private IDeviceverificationrecordsdetailService deviceverificationrecordsdetailService;
	@Autowired
	private IDeviceexitrecordsService iDeviceexitrecordsService;
	@Autowired
	private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("提交前回调");
		logger.info("设备进场提交前回调开始--------------");
		DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(billId);
		BigDecimal bigDecimal = new BigDecimal(BigInteger.ZERO);
		if(deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities().size() > 0){
			logger.info("设备进场子表进来-----------------");
			for(DeviceverificationrecordsdetailEntity entity : deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities()){
				bigDecimal = bigDecimal .add(entity.getVerificationCount());
				entity.setNotExitingCount(entity.getVerificationCount());
			}
			deviceverificationrecordsEntity.setNotExitingCount(bigDecimal);
			deviceverificationrecordsService.saveOrUpdate(deviceverificationrecordsEntity,false);
		}
		logger.info("设备进场提交前回调结束 --------------");
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("提交完回调");

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("有审批流的撤回前回调");
		//校验是否被退场单引用enter_number
		DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(billId);
		LambdaQueryWrapper<DeviceexitrecordsEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(DeviceexitrecordsEntity::getEnterNumber, deviceverificationrecordsEntity.getBillCode());
		List<DeviceexitrecordsEntity> deviceexitrecordsEntityList = iDeviceexitrecordsService.list(queryWrapper);
		if(CollectionUtils.isNotEmpty(deviceexitrecordsEntityList)){
			return CommonResponse.error("撤回失败,该单据已经被设备退场记录引用！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("有审批流的撤回后回调");
		logger.info("设备进场撤回开始--------------");
	   	CommonResponse<String> resp = billTypeApi.checkQuote("HZBT202208000022", billId);
		if(!resp.isSuccess()){
			return CommonResponse.error("撤回失败！"+resp.getMsg());
		}else{
			DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(billId);
			if(deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities().size() > 0){
				logger.info("设备进场子表进来-----------------");
				for(DeviceverificationrecordsdetailEntity entity : deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities()){
					entity.setNotExitingCount(null);
				}
				deviceverificationrecordsEntity.setNotExitingCount(null);
				deviceverificationrecordsService.saveOrUpdate(deviceverificationrecordsEntity,false);
				logger.info("设备进场撤回结束 --------------");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		logger.info("审批节点审批中时节点审批前回调");
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("审批节点审批中时节点审批前回调");

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("终审审核完回调");
		//回写主表
		DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(billId);
		deviceverificationrecordsEntity.setApproveTime(new Date());
		deviceverificationrecordsService.updateById(deviceverificationrecordsEntity);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("弃审前事件回调");
		logger.info("设备进场撤回开始--------------");
		CommonResponse<String> resp = billTypeApi.checkQuote("HZBT202208000022", billId);
		if(!resp.isSuccess()){
			return CommonResponse.error("撤回失败！"+resp.getMsg());
		}else{
			DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(billId);
			if(deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities().size() > 0){
				logger.info("设备进场子表进来-----------------");
				for(DeviceverificationrecordsdetailEntity entity : deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities()){
					entity.setNotExitingCount(null);
				}
				deviceverificationrecordsEntity.setNotExitingCount(null);
				deviceverificationrecordsService.saveOrUpdate(deviceverificationrecordsEntity,false);
				logger.info("设备进场撤回结束 --------------");
			}
		}
		DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(billId);
		LambdaQueryWrapper<DeviceexitrecordsEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(DeviceexitrecordsEntity::getEnterNumber, deviceverificationrecordsEntity.getBillCode());
		List<DeviceexitrecordsEntity> deviceexitrecordsEntityList = iDeviceexitrecordsService.list(queryWrapper);
		if(CollectionUtils.isNotEmpty(deviceexitrecordsEntityList)){
			return CommonResponse.error("撤回失败,该单据已经被设备退场记录引用！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("弃审后事件回调");
		DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(billId);
		deviceverificationrecordsEntity.setApproveTime(null);
		deviceverificationrecordsService.updateById(deviceverificationrecordsEntity);
		return CommonResponse.success();
	}

}
