package com.ejianc.business.material.service.impl;


import com.ejianc.business.material.mapper.EquipmentEntryExitMapper;
import com.ejianc.business.material.service.IEquipmentEntryExitService;
import com.ejianc.business.material.service.IReturnService;
import com.ejianc.foundation.material.vo.EquipmentEntryExitVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;


@Service("equipmentEntryExitService")
public class EquipmentEntryExitServiceImpl extends BaseServiceImpl<EquipmentEntryExitMapper, EquipmentEntryExitVO> implements IEquipmentEntryExitService {


    @Resource
    private EquipmentEntryExitMapper equipmentEntryExitMapper;

    /**
     *
     * @return
     */
    @Override
    public List<EquipmentEntryExitVO> queryEquipment(List<Long> ids) {
        return  equipmentEntryExitMapper.queryEquipment(ids);
    }

    @Override
    public List<EquipmentEntryExitVO> queryEntry(Long projectId, String equipmentCode, String spec, String supplierName, List<Long> ids) {
        return equipmentEntryExitMapper.queryEntry(projectId, equipmentCode, spec, supplierName,ids);
    }

    @Override
    public List<EquipmentEntryExitVO> queryExit(Long projectId, String equipmentCode, String spec, String subcontractor, List<Long> ids) {
        return equipmentEntryExitMapper.queryExit(projectId, equipmentCode, spec, subcontractor, ids);
    }


}
