package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.vo.EquipmentVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.EquipmentMapper;
import com.ejianc.business.material.bean.EquipmentEntity;
import com.ejianc.business.material.service.IEquipmentService;

import java.util.List;
import java.util.Map;

/**
 * 分公司闲置设备物资情况一览表
 * 
 * @author generator
 * 
 */
@Service("equipmentService")
public class EquipmentServiceImpl extends BaseServiceImpl<EquipmentMapper, EquipmentEntity> implements IEquipmentService{
    @Autowired
    private EquipmentMapper mapper;
    @Override
    public IPage<EquipmentVO> queryReportPage(Map<String, Object> map) {
        Integer count = mapper.queryReportTotal(map);
        Long pageSize = Long.valueOf(map.get("pageSize").toString());
        Long pageIndex = Long.valueOf(map.get("pageIndex").toString());
        List<EquipmentVO> equipmentVOS = mapper.queryReportPage(map);
        for (EquipmentVO equipmentVO : equipmentVOS) {
            equipmentVO.setId(IdWorker.getId());
        }
        IPage<EquipmentVO> pageData = new Page<>(pageIndex, pageSize, count);
        pageData.setRecords(equipmentVOS);
        return pageData;
    }
}
