package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.SurplusmaterialrecordEntity;
import com.ejianc.business.material.vo.SurplusmaterialrecordVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.FlowmeterMapper;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 出入库流水表
 * 
 * @author generator
 * 
 */
@Service("flowmeterService")
public class FlowmeterServiceImpl extends BaseServiceImpl<FlowmeterMapper, FlowmeterEntity> implements IFlowmeterService{
    @Transactional
    @Override
    public void updateFlow(Long billId, Date approveTime, Integer billStatus) {
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid,billId);
        List<FlowmeterEntity> flowmeterEntityList = super.list(lambdaFlower);
        if (CollectionUtils.isNotEmpty(flowmeterEntityList)) {
            for (FlowmeterEntity flowmeterEntity : flowmeterEntityList){
                flowmeterEntity.setApproveTime(approveTime);
                flowmeterEntity.setBillStatus(billStatus);
            }
            super.updateBatchById(flowmeterEntityList);
        }
    }
}
