package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.MaterialapproachEntity;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.bean.ProcurementplanEntity;
import com.ejianc.business.material.bean.ProcurementplandetailEntity;
import com.ejianc.business.material.mapper.MaterialapproachMapper;
import com.ejianc.business.material.service.IMaterialapproachService;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.business.material.service.IProcurementplanService;
import com.ejianc.business.material.service.IProcurementplandetailService;
import com.ejianc.foundation.material.vo.MaterialapproachVO;
import com.ejianc.foundation.material.vo.MaterialapproachdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资（周转）进场验证记录
 *
 * @author generator
 */
@Service("materialapproachService")
public class MaterialapproachServiceImpl extends BaseServiceImpl<MaterialapproachMapper, MaterialapproachEntity> implements IMaterialapproachService {

    @Autowired
    private IProcurementplanService planService;

    @Autowired
    private IProcurementplandetailService planDetailService;

    @Autowired
    private IMaterialapproachdetailService detailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "WZ_JC_YZJL";//此处需要根据实际修改


    @Override
    public String validatePlan(MaterialapproachVO vo) {
        // 获取计划数量
        Map<String, BigDecimal> planNumMap = this.getPlanNumMap(vo.getProjectId());
        // 获取已进场数量
        Map<String, BigDecimal> inNumMap = this.getInNumMap(vo.getProjectId(), vo.getId());
        StringBuffer buffer = new StringBuffer();
        List<MaterialapproachdetailVO> detailList = vo.getMaterialapproachdetailEntities();
        for (MaterialapproachdetailVO detail : detailList) {
            BigDecimal planNum = BigDecimal.ZERO;
            BigDecimal inNum = BigDecimal.ZERO;
            if (planNumMap.containsKey(detail.getMaterialCode())) {
                planNum = planNumMap.get(detail.getMaterialCode());
            }
            if (inNumMap.containsKey(detail.getMaterialCode())) {
                inNum = inNumMap.get(detail.getMaterialCode());
            }
            // 累计进场 + 本次进场 > 计划汇总
            inNum = ComputeUtil.safeAdd(detail.getEnterCount(), inNum);
            if (ComputeUtil.isGreaterThan(inNum, planNum)) {
                buffer.append("【" + detail.getName() + "】");
                buffer.append("物资计划总量" + ComputeUtil.scale(planNum, 3) + "，");
                buffer.append("累计进场" + ComputeUtil.scale(inNum, 3) + "，");
                buffer.append("超计划" + ComputeUtil.scale(ComputeUtil.safeSub(inNum, planNum), 3) + "；");
            }
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @Override
    public MaterialapproachVO saveOrUpdate(MaterialapproachVO saveorUpdateVO) {
        MaterialapproachEntity entity = BeanMapper.map(saveorUpdateVO, MaterialapproachEntity.class);
        if (null == saveorUpdateVO.getCheckType()) {
            entity.setCheckType(1);
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setNotStorageNum(new BigDecimal(0.00));
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //    新增时初始化子表退场数量，维修数量，丢失数量字段值
            for (MaterialapproachdetailEntity detailEntity : entity.getMaterialapproachdetailEntities()) {
                detailEntity.setExitAccount(BigDecimal.ZERO);
                detailEntity.setLoseAccount(BigDecimal.ZERO);
                detailEntity.setRepairAccount(BigDecimal.ZERO);
            }
        }
        List<MaterialapproachdetailEntity> materialapproachdetailEntities = entity.getMaterialapproachdetailEntities();
        for (MaterialapproachdetailEntity item :
                materialapproachdetailEntities) {
            item.setBillCode(entity.getBillCode());
            item.setProjectId(entity.getProjectId());
            item.setProjectName(entity.getProjectName());
        }
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, MaterialapproachVO.class);
    }

    /**
     * 获取计划数量
     *
     * @param projectId
     * @return
     */
    private Map<String, BigDecimal> getPlanNumMap(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<ProcurementplanEntity> list = planService.queryList(param);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<>();
        }
        List<Long> ids = list.stream().map(ProcurementplanEntity::getId).collect(Collectors.toList());
//        QueryParam detailParam = new QueryParam();

//        detailParam.getParams().put("mid", new Parameter(QueryParam.IN, ids));
        LambdaQueryWrapper<ProcurementplandetailEntity> lambda = Wrappers.<ProcurementplandetailEntity>lambdaQuery();
        lambda.in(ProcurementplandetailEntity::getMid, ids);
        List<ProcurementplandetailEntity> detailList = planDetailService.list(lambda);

        // 分组后汇总
        Map<String, BigDecimal> numMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(detailList)) {
            numMap = detailList.stream().filter(s -> StringUtils.isNotBlank(s.getItemCode())).collect(Collectors.groupingBy(ProcurementplandetailEntity::getItemCode,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPurchaseQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        return numMap;
    }

    /**
     * 获取进场数量
     *
     * @param projectId
     * @return
     */
    private Map<String, BigDecimal> getInNumMap(Long projectId, Long id) {
        QueryParam param = new QueryParam();
//        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        if (id != null) {
            param.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<MaterialapproachEntity> list = super.queryList(param);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<>();
        }
        List<Long> ids = list.stream().map(MaterialapproachEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<ProcurementplandetailEntity> lambda = Wrappers.<ProcurementplandetailEntity>lambdaQuery();
        lambda.in(ProcurementplandetailEntity::getMid, ids);
        List<ProcurementplandetailEntity> detailList = planDetailService.list(lambda);

        // 分组后汇总
        Map<String, BigDecimal> numMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(detailList)) {
            numMap = detailList.stream().collect(Collectors.groupingBy(ProcurementplandetailEntity::getItemCode,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPurchaseQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        return numMap;
    }

}
