package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.MonthOrgDetailEntity;
import com.ejianc.business.material.bean.MonthProjectEntity;
import com.ejianc.business.material.service.IMonthOrgDetailService;
import com.ejianc.business.material.service.IMonthProjectService;
import com.ejianc.business.material.vo.MonthOrgVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.MonthOrgMapper;
import com.ejianc.business.material.bean.MonthOrgEntity;
import com.ejianc.business.material.service.IMonthOrgService;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资消耗月度分析表-组织
 * 
 * @author generator
 * 
 */
@Service("monthOrgService")
public class MonthOrgServiceImpl extends BaseServiceImpl<MonthOrgMapper, MonthOrgEntity> implements IMonthOrgService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMonthProjectService monthProjectService;
    @Autowired
    private IMonthOrgDetailService monthOrgDetailService;

    private static final String BILL_CODE = "MONTH-ORG";//此处需要根据实际修改
    @Override
    public MonthOrgVO saveOrUpdate(MonthOrgVO saveOrUpdateVO) {
        //一个月只能做一条数据
        QueryWrapper curQuery = new QueryWrapper();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        String month = sdf1.format(saveOrUpdateVO.getMonth());
        curQuery.eq("DATE_FORMAT(month, '%Y-%m' )",month);
        curQuery.eq("org_id",saveOrUpdateVO.getProjectId());
        if(saveOrUpdateVO.getId() != null){
            curQuery.ne("id",saveOrUpdateVO.getId());
        }
        int curCount = super.count(curQuery);
        if (curCount > 0) throw new BusinessException("一个组织每个月只能做一个单据。");

//        一个项目当前最多只能有一个非生效态单据。
        LambdaQueryWrapper<MonthOrgEntity> lambda = Wrappers.<MonthOrgEntity>lambdaQuery();
        lambda.eq(MonthOrgEntity::getProjectId, saveOrUpdateVO.getProjectId());
        lambda.notIn(MonthOrgEntity::getBillState, 1,3);
        lambda.ne(saveOrUpdateVO.getId() != null, MonthOrgEntity::getId, saveOrUpdateVO.getId());
        int curCount2 = super.count(lambda);
        if (curCount2 > 0) throw new BusinessException(" 一个组织当前最多只能有一个非生效态单据。");

        MonthOrgEntity entity = BeanMapper.map(saveOrUpdateVO, MonthOrgEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //同步引用状态
        if (saveOrUpdateVO.getId() != null){
            MonthOrgEntity methodReviewEntity = super.selectById(saveOrUpdateVO.getId());
            List<MonthOrgDetailEntity> methodReviewDetailList = methodReviewEntity.getMonthOrgDetailList();
            if (CollectionUtils.isNotEmpty(methodReviewDetailList)){
                List<Long> monthProjectIds = methodReviewDetailList.stream().map(MonthOrgDetailEntity::getMonthProjectId).collect(Collectors.toList());
                LambdaQueryWrapper<MonthProjectEntity> lambdaPro = new LambdaQueryWrapper();
                lambdaPro.in(MonthProjectEntity::getId, monthProjectIds);
                List<MonthProjectEntity> methodApplyEntities = monthProjectService.list(lambdaPro);
                if (CollectionUtils.isNotEmpty(methodApplyEntities)){
                    for (MonthProjectEntity monthProjectEntity : methodApplyEntities){
                        monthProjectEntity.setUseStatus(0);
                    }
                    monthProjectService.updateBatchById(methodApplyEntities);
                }
            }
        }
        super.saveOrUpdate(entity, false);

        if (saveOrUpdateVO.getId() != null){
            List<MonthOrgDetailEntity> methodReviewDetailList = entity.getMonthOrgDetailList();
            if (CollectionUtils.isNotEmpty(methodReviewDetailList)){
                List<Long> monthProjectIds = methodReviewDetailList.stream().map(MonthOrgDetailEntity::getMonthProjectId).collect(Collectors.toList());
                LambdaQueryWrapper<MonthProjectEntity> lambdaPro = new LambdaQueryWrapper();
                lambdaPro.in(MonthProjectEntity::getId, monthProjectIds);
                List<MonthProjectEntity> methodApplyEntities = monthProjectService.list(lambdaPro);
                if (CollectionUtils.isNotEmpty(methodApplyEntities)){
                    for (MonthProjectEntity monthProjectEntity : methodApplyEntities){
                        monthProjectEntity.setUseStatus(1);
                    }
                    monthProjectService.updateBatchById(methodApplyEntities);
                }
            }
        }

        MonthOrgVO vo = BeanMapper.map(entity, MonthOrgVO.class);
        return vo;
    }

    @Transactional
    @Override
    public void delete(List<MonthOrgVO> vos) {
        List<Long> ids = vos.stream().map(MonthOrgVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<MonthOrgDetailEntity> methodReviewDetailLambdaWrapper = new LambdaQueryWrapper();
        methodReviewDetailLambdaWrapper.in(MonthOrgDetailEntity::getMid, ids);
        List<MonthOrgDetailEntity> methodReviewDetailEntities = monthOrgDetailService.list(methodReviewDetailLambdaWrapper);
        List<Long> methodIds = methodReviewDetailEntities.stream().map(MonthOrgDetailEntity::getMonthProjectId).collect(Collectors.toList());
        LambdaQueryWrapper<MonthProjectEntity> lambda = new LambdaQueryWrapper();
        lambda.in(MonthProjectEntity::getId, methodIds);
        List<MonthProjectEntity> methodApplyEntities = monthProjectService.list(lambda);
        for (MonthProjectEntity methodApplyEntity : methodApplyEntities){
            methodApplyEntity.setUseStatus(0);
        }
        monthProjectService.updateBatchById(methodApplyEntities);
        super.removeByIds(vos.stream().map(MonthOrgVO::getId).collect(Collectors.toList()),true);
    }
}
