package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.vo.DeliveryrecordVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.RealtimebalanceMapper;
import com.ejianc.business.material.service.IRealtimebalanceService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 实时物资结存表
 * 
 * @author generator
 * 
 */
@Service("realtimebalanceService")
public class RealtimebalanceServiceImpl extends BaseServiceImpl<RealtimebalanceMapper, RealtimebalanceEntity> implements IRealtimebalanceService {
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;


    /**
     * 处理实时物资结存数据
     *
     * @param storeId
     */
    @Transactional
    @Override
    public void updateRealtimeBalance(Long storeId) {
        //先删后增
        LambdaQueryWrapper<RealtimebalanceEntity> lambdaReal = Wrappers.<RealtimebalanceEntity>lambdaQuery();
        lambdaReal.eq(RealtimebalanceEntity::getStoreId, storeId);
        super.remove(lambdaReal);

        //汇总数据
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlow = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlow.eq(FlowmeterEntity::getStoreId, storeId);
        List<FlowmeterEntity> flowmeterEntityList = flowmeterService.list(lambdaFlow);

        if (CollectionUtils.isNotEmpty(flowmeterEntityList)) {
            ArrayList<RealtimebalanceEntity> realtimebalanceEntities = new ArrayList<>();

            List<FlowmeterEntity> flowmeterEntityListNew = flowmeterEntityList.stream()
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getMaterialId()))), ArrayList::new));
            Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> mnyTaxInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> mnyTaxOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> mnyInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> mnyOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            BigDecimal inNum = BigDecimal.ZERO;
            BigDecimal outNum = BigDecimal.ZERO;
            BigDecimal mnyTaxIn = BigDecimal.ZERO;
            BigDecimal mnyTaxOut = BigDecimal.ZERO;
            BigDecimal mnyIn = BigDecimal.ZERO;
            BigDecimal mnyOut = BigDecimal.ZERO;
            for (FlowmeterEntity flowmeterEntity : flowmeterEntityListNew) {
                inNum = BigDecimal.ZERO;
                outNum = BigDecimal.ZERO;
                mnyTaxIn = BigDecimal.ZERO;
                mnyTaxOut = BigDecimal.ZERO;
                mnyIn = BigDecimal.ZERO;
                mnyOut = BigDecimal.ZERO;
                RealtimebalanceEntity realtimebalanceEntity = new RealtimebalanceEntity();
                realtimebalanceEntity.setProjectId(flowmeterEntity.getProjectId());
                realtimebalanceEntity.setProjectName(flowmeterEntity.getProjectName());
                realtimebalanceEntity.setMaterialCode(flowmeterEntity.getMaterialCode());
                realtimebalanceEntity.setMaterialName(flowmeterEntity.getMaterialName());
                realtimebalanceEntity.setMaterialId(flowmeterEntity.getMaterialId());
                realtimebalanceEntity.setMaterialCategoryId(flowmeterEntity.getMaterialCategoryId());
                realtimebalanceEntity.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
                realtimebalanceEntity.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
                realtimebalanceEntity.setStoreId(flowmeterEntity.getStoreId());
                realtimebalanceEntity.setStoreName(flowmeterEntity.getStoreName());
                if (numInMap.containsKey(flowmeterEntity.getMaterialId())) {
                    inNum = numInMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : numInMap.get(flowmeterEntity.getMaterialId());
                    mnyTaxIn = mnyTaxInMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : mnyTaxInMap.get(flowmeterEntity.getMaterialId());
                    mnyIn = mnyInMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : mnyInMap.get(flowmeterEntity.getMaterialId());
                }
                if (numOutMap.containsKey(flowmeterEntity.getMaterialId())) {
                    outNum = numOutMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : numOutMap.get(flowmeterEntity.getMaterialId());
                    mnyTaxOut = mnyTaxOutMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : mnyTaxOutMap.get(flowmeterEntity.getMaterialId());
                    mnyOut = mnyOutMap.get(flowmeterEntity.getMaterialId()) == null ? BigDecimal.ZERO : mnyOutMap.get(flowmeterEntity.getMaterialId());
                }
                realtimebalanceEntity.setQuantity(inNum.subtract(outNum));
                if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity.setAmountIncluetax(mnyTaxIn.subtract(mnyTaxOut));
                    realtimebalanceEntity.setAmountExcluetax(mnyIn.subtract(mnyOut));
                    realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, BigDecimal.ROUND_HALF_UP));
                    realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, BigDecimal.ROUND_HALF_UP));
                } else {
                    realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.00));
                    realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.00));
                    realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
                    realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
                }


                realtimebalanceEntity.setOrgId(flowmeterEntity.getOrgId());
                realtimebalanceEntity.setOrgName(flowmeterEntity.getOrgName());
                realtimebalanceEntity.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());
                realtimebalanceEntity.setSpecialModel(flowmeterEntity.getSpecialModel());
                realtimebalanceEntity.setProjectDepartmentId(flowmeterEntity.getProjectDepartmentId());
                realtimebalanceEntities.add(realtimebalanceEntity);
            }
            realtimebalanceService.saveBatch(realtimebalanceEntities);

        }

    }

    /**
     * 库存管理使用
     *
     * @param storeId type,0-结存,1-可用结存
     */
    @Transactional
    @Override
    public List<RealtimebalanceEntity> getRealtimeBalance(Long storeId, Integer type, List<RealtimebalanceEntity> realtimebalanceEntityList) {

        if (CollectionUtils.isNotEmpty(realtimebalanceEntityList)) {
            List<Long> materialIds = realtimebalanceEntityList.stream().map(RealtimebalanceEntity::getMaterialId).collect(Collectors.toList());
            //汇总数据
            LambdaQueryWrapper<FlowmeterEntity> lambdaFlow = Wrappers.<FlowmeterEntity>lambdaQuery();
            lambdaFlow.eq(FlowmeterEntity::getStoreId, storeId);
            lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
            if (type == 0) {
                lambdaFlow.eq(FlowmeterEntity::getBillStatus, 1);
            }
            List<FlowmeterEntity> flowmeterEntityList = flowmeterService.list(lambdaFlow);
            if (CollectionUtils.isNotEmpty(flowmeterEntityList)) {
                ArrayList<RealtimebalanceEntity> realtimebalanceEntities = new ArrayList<>();

                List<FlowmeterEntity> flowmeterEntityListNew = flowmeterEntityList.stream()
                        .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getMaterialId()))), ArrayList::new));
                Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> mnyTaxInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> mnyTaxOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> mnyInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> mnyOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                BigDecimal inNum = BigDecimal.ZERO;
                BigDecimal outNum = BigDecimal.ZERO;
                BigDecimal mnyTaxIn = BigDecimal.ZERO;
                BigDecimal mnyTaxOut = BigDecimal.ZERO;
                BigDecimal mnyIn = BigDecimal.ZERO;
                BigDecimal mnyOut = BigDecimal.ZERO;
                for (FlowmeterEntity flowmeterEntity : flowmeterEntityListNew) {
                    inNum = BigDecimal.ZERO;
                    outNum = BigDecimal.ZERO;
                    mnyTaxIn = BigDecimal.ZERO;
                    mnyTaxOut = BigDecimal.ZERO;
                    mnyIn = BigDecimal.ZERO;
                    mnyOut = BigDecimal.ZERO;
                    RealtimebalanceEntity realtimebalanceEntity = new RealtimebalanceEntity();
                    realtimebalanceEntity.setProjectId(flowmeterEntity.getProjectId());
                    realtimebalanceEntity.setProjectName(flowmeterEntity.getProjectName());
                    realtimebalanceEntity.setMaterialCode(flowmeterEntity.getMaterialCode());
                    realtimebalanceEntity.setMaterialName(flowmeterEntity.getMaterialName());
                    realtimebalanceEntity.setMaterialId(flowmeterEntity.getMaterialId());
                    realtimebalanceEntity.setMaterialCategoryId(flowmeterEntity.getMaterialCategoryId());
                    realtimebalanceEntity.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
                    realtimebalanceEntity.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
                    realtimebalanceEntity.setStoreId(flowmeterEntity.getStoreId());
                    realtimebalanceEntity.setStoreName(flowmeterEntity.getStoreName());
                    if (numInMap.containsKey(flowmeterEntity.getMaterialId())) {
                        inNum = numInMap.get(flowmeterEntity.getMaterialId());
                        mnyTaxIn = mnyTaxInMap.get(flowmeterEntity.getMaterialId());
                        mnyIn = mnyInMap.get(flowmeterEntity.getMaterialId());
                    }
                    if (numOutMap.containsKey(flowmeterEntity.getMaterialId())) {
                        outNum = numOutMap.get(flowmeterEntity.getMaterialId());
                        mnyTaxOut = mnyTaxOutMap.get(flowmeterEntity.getMaterialId());
                        mnyOut = mnyOutMap.get(flowmeterEntity.getMaterialId());
                    }
                    realtimebalanceEntity.setQuantity(inNum.subtract(outNum));
                    if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                        realtimebalanceEntity.setAmountIncluetax(mnyTaxIn.subtract(mnyTaxOut));
                        realtimebalanceEntity.setAmountExcluetax(mnyIn.subtract(mnyOut));
                        realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, BigDecimal.ROUND_HALF_UP));
                        realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, BigDecimal.ROUND_HALF_UP));
                    } else {
                        realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.00));
                        realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.00));
                        realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
                        realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
                    }


                    realtimebalanceEntity.setOrgId(flowmeterEntity.getOrgId());
                    realtimebalanceEntity.setOrgName(flowmeterEntity.getOrgName());
                    realtimebalanceEntity.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());
                    realtimebalanceEntity.setSpecialModel(flowmeterEntity.getSpecialModel());
                    realtimebalanceEntity.setProjectDepartmentId(flowmeterEntity.getProjectDepartmentId());
                    realtimebalanceEntities.add(realtimebalanceEntity);
                }
                Map<Long, RealtimebalanceEntity> realMap = realtimebalanceEntities.stream().collect(Collectors.toMap(RealtimebalanceEntity::getMaterialId, Function.identity()));
                for (RealtimebalanceEntity realtimebalanceEntity : realtimebalanceEntityList) {
                    if (realMap.containsKey(realtimebalanceEntity.getMaterialId())) {
                        RealtimebalanceEntity realtimebalanceData = realMap.get(realtimebalanceEntity.getMaterialId());
                        realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceData.getUnitPriceExcluetax());
                        realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceData.getUnitPriceIncluetax());
                        realtimebalanceEntity.setAmountExcluetax(realtimebalanceData.getAmountExcluetax());
                        realtimebalanceEntity.setAmountIncluetax(realtimebalanceData.getAmountIncluetax());
                        realtimebalanceEntity.setQuantity(realtimebalanceData.getQuantity());
                    }
                }

            }
        }
        List<RealtimebalanceEntity> collect = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(realtimebalanceEntityList)){
            collect = realtimebalanceEntityList.stream().filter(s -> s.getQuantity().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());
        }

        return collect;

    }
}
