package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.DeliveryrecordEntity;
import com.ejianc.business.material.bean.DeviceexitrecordsEntity;
import com.ejianc.business.material.bean.StoreBalanceEntity;
import com.ejianc.business.material.service.IDeviceexitrecordsService;
import com.ejianc.business.material.service.IStoreBalanceService;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("storeBalance") 
public class StoreBalanceBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private CostanalysisApi costanalysisApi;
	@Autowired
	private IStoreBalanceService service;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		QueryWrapper<StoreBalanceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id",billId);
		StoreBalanceEntity entity = service.getOne(queryWrapper);
		if(costanalysisApi.isGenerate(entity.getProjectId(),entity.getMonth()).getData()){
			return CommonResponse.error("该单据所属项目与月份已生成月度分析报告，不可提交！");
		}else{
			return CommonResponse.success();
		}
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		StoreBalanceEntity storeBalanceEntity = service.selectById(billId);
		if(queryTop(storeBalanceEntity.getProjectId(),storeBalanceEntity.getStoreId(),storeBalanceEntity.getMonth())){
			throw new BusinessException("已有下期物资结存，本期不允许撤回！");
		}

		QueryWrapper<StoreBalanceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id",billId);
		StoreBalanceEntity entity = service.getOne(queryWrapper);
		if(costanalysisApi.isGenerate(entity.getProjectId(),entity.getMonth()).getData()){
			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
		}else{
			return CommonResponse.success();
		}




	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		StoreBalanceEntity storeBalanceEntity = service.selectById(billId);
		if(queryTop(storeBalanceEntity.getProjectId(),storeBalanceEntity.getStoreId(),storeBalanceEntity.getMonth())){
			throw new BusinessException("已有下期物资结存，本期不允许撤回！");
		}

		//TODO
		QueryWrapper<StoreBalanceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id",billId);
		StoreBalanceEntity entity = service.getOne(queryWrapper);
		if(costanalysisApi.isGenerate(entity.getProjectId(),entity.getMonth()).getData()){
			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
		}else{
			return CommonResponse.success();
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public Boolean queryTop(Long projectId, Long storeId, Date month) {
		LambdaQueryWrapper<StoreBalanceEntity> lambdaFlower = Wrappers.<StoreBalanceEntity>lambdaQuery();
		lambdaFlower.eq(StoreBalanceEntity::getProjectId,projectId);
		lambdaFlower.eq(StoreBalanceEntity::getStoreId,storeId);
		lambdaFlower.gt(StoreBalanceEntity::getMonth,month);
		List<StoreBalanceEntity> storeBalanceEntities = service.list(lambdaFlower);
		if(storeBalanceEntities.size()>0){
			return true;
		}else{
			return false;
		}
	}
}
