package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.ISurplusmaterialapproveService;
import com.ejianc.business.material.service.ISurplusmaterialapprovetailService;
import com.ejianc.business.material.vo.TenderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.TenderMapper;
import com.ejianc.business.material.service.ITenderService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 废旧物资处置招标结果记录
 * 
 * @author generator
 * 
 */
@Service("tenderService")
public class TenderServiceImpl extends BaseServiceImpl<TenderMapper, TenderEntity> implements ITenderService{

    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "MATERIAL_TENDER";//此处需要根据实际修改

    @Autowired
    private ISurplusmaterialapproveService surplusmaterialapproveService;
    @Autowired
    private ISurplusmaterialapprovetailService surplusmaterialapprovetailService;

    @Transactional
    @Override
    public TenderVO saveOrUpdate(TenderVO saveOrUpdateVO) {
        TenderEntity entity = BeanMapper.map(saveOrUpdateVO, TenderEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //同步占用状态
        LambdaQueryWrapper<TenderEntity> lambda = Wrappers.<TenderEntity>lambdaQuery();
        lambda.eq(TenderEntity::getApproveId, saveOrUpdateVO.getApproveId());
        lambda.ne(saveOrUpdateVO.getId() != null, TenderEntity::getId, saveOrUpdateVO.getId());
        List<TenderEntity> tenderEntities = super.list(lambda);
        List<Long> detailIds = new ArrayList<>();
        detailIds.add(saveOrUpdateVO.getApproveDetailId());
        if (CollectionUtils.isNotEmpty(tenderEntities)) {
            detailIds = tenderEntities.stream().map(TenderEntity::getApproveDetailId).collect(Collectors.toList());
        }
        SurplusmaterialapproveEntity surplusmaterialapproveEntity = surplusmaterialapproveService.selectById(saveOrUpdateVO.getApproveId());
        List<SurplusmaterialapprovetailEntity> surplusmaterialapprovetailEntities = surplusmaterialapproveEntity.getSurplusmaterialapprovetailEntities();
        for (SurplusmaterialapprovetailEntity surplusmaterialapprovetailEntity : surplusmaterialapprovetailEntities) {
            if (detailIds.contains(surplusmaterialapprovetailEntity.getId())){
                surplusmaterialapprovetailEntity.setUseDetailStatus(2);
            }else{
                surplusmaterialapprovetailEntity.setUseDetailStatus(1);
            }
        }
        boolean anyMatch = surplusmaterialapprovetailEntities.stream().anyMatch(s -> s.getUseDetailStatus() == 1);
        if (anyMatch){
            surplusmaterialapproveEntity.setUseStatus(1);
        }else {
            surplusmaterialapproveEntity.setUseStatus(2);

        }
        surplusmaterialapproveService.updateById(surplusmaterialapproveEntity);
        surplusmaterialapprovetailService.updateBatchById(surplusmaterialapprovetailEntities);
        super.saveOrUpdate(entity,false);
        TenderVO vo = BeanMapper.map(entity, TenderVO.class);

        return vo;
    }

    @Override
    public void delete(List<TenderVO> vos) {
        //更新状态
        List<Long> ids = vos.stream().map(TenderVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<TenderEntity> midLambda = Wrappers.<TenderEntity>lambdaQuery();
        midLambda.in(TenderEntity::getId, ids);
        List<TenderEntity> tenderEntities = super.list(midLambda);

        List<Long> detailIds = tenderEntities.stream().map(TenderEntity::getApproveDetailId).collect(Collectors.toList());
        LambdaQueryWrapper<SurplusmaterialapprovetailEntity> lambda = Wrappers.<SurplusmaterialapprovetailEntity>lambdaQuery();
        lambda.in(SurplusmaterialapprovetailEntity::getId, detailIds);
        List<SurplusmaterialapprovetailEntity> surplusmaterialapprovetailEntityList = surplusmaterialapprovetailService.list(lambda);
        for (SurplusmaterialapprovetailEntity surplusmaterialapprovetailEntity : surplusmaterialapprovetailEntityList){
            surplusmaterialapprovetailEntity.setUseDetailStatus(1);
        }
        surplusmaterialapprovetailService.updateBatchById(surplusmaterialapprovetailEntityList);

        List<Long> approveIds = tenderEntities.stream().map(TenderEntity::getApproveId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper<SurplusmaterialapproveEntity> approveLambda = Wrappers.<SurplusmaterialapproveEntity>lambdaQuery();
        approveLambda.in(SurplusmaterialapproveEntity::getId, approveIds);
        List<SurplusmaterialapproveEntity> surplusmaterialapproveEntityList = surplusmaterialapproveService.list(approveLambda);
        for (SurplusmaterialapproveEntity surplusmaterialapprovetailEntity : surplusmaterialapproveEntityList){
            surplusmaterialapprovetailEntity.setUseStatus(1);
        }
        surplusmaterialapproveService.updateBatchById(surplusmaterialapproveEntityList);

        super.removeByIds(vos.stream().map(TenderVO::getId).collect(Collectors.toList()),true);

    }
}
