package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.service.ITransferorderService;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("transferorder") 
public class TransferorderBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private ITransferorderService transferorderService;
	@Autowired
	private IRealtimebalanceService realtimebalanceService;
	@Autowired
	private IFlowmeterService flowmeterService;
	@Autowired
	private IStoreService storeService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("调拨提交--------------");
		TransferorderEntity transferorderEntity = transferorderService.selectById(billId);
		List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
		List<RealtimebalanceEntity> realList = new ArrayList<>();//修改调入实时物资结存
		List<RealtimebalanceEntity> realList1 = new ArrayList<>();//修改调出实时物资结存
		List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
		if(transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null){
			for(TransferorderdetailEntity entity : transferorderdetailEntities){
				//实时物资结存 调入
				QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("project_id",transferorderEntity.getDialinitemsId());
				queryWrapper.eq("material_code",entity.getMaterialCode());
				queryWrapper.eq("material_category_code",entity.getMaterialCategoryCode());
				queryWrapper.eq("store_id",transferorderEntity.getIncomingWarehouse());
				RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper);
				if(realtimebalanceEntity != null){
						QueryWrapper<FlowmeterEntity> queryWrapper1 = new QueryWrapper<>();
						queryWrapper1.eq("project_id",transferorderEntity.getDialinitemsId());
						queryWrapper1.eq("detail_id",entity.getId());
						FlowmeterEntity flowmeterEntity = flowmeterService.getOne(queryWrapper1);
						if (flowmeterEntity != null){
							list.add(flowmeterEntity);
						}
						realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
						realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getTransferAmount()));
						realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
						if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
							realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
							realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
						}else{
							realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
							realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
						}
						realList.add(realtimebalanceEntity);//调入实时物资库存回退

						//调出
						QueryWrapper<FlowmeterEntity> queryWrapper2 = new QueryWrapper<>();
						queryWrapper2.eq("project_id",transferorderEntity.getDialitemsId());
						queryWrapper2.eq("detail_id",entity.getId());
						FlowmeterEntity flowmeterEntity1 = flowmeterService.getOne(queryWrapper2);
						if (flowmeterEntity1 != null){
							list.add(flowmeterEntity1);
						}
						QueryWrapper<RealtimebalanceEntity> queryWrapper3 = new QueryWrapper<>();
						queryWrapper3.eq("project_id",transferorderEntity.getDialitemsId());
						queryWrapper3.eq("material_code",entity.getMaterialCode());
						queryWrapper3.eq("material_category_code",entity.getMaterialCategoryCode());
						queryWrapper3.eq("store_id",transferorderEntity.getIssuingWarehouse());
						RealtimebalanceEntity realtimebalanceEntity1 = realtimebalanceService.getOne(queryWrapper3);
						if(realtimebalanceEntity1 != null){
							realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(entity.getQuantity()));
							realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(entity.getTransferAmount()));
							realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(entity.getAmountExcluetax()));
							if(realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0){
								realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
								realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
							}else{
								realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.00));
								realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.00));
							}
							realList1.add(realtimebalanceEntity1);//调出实时物资库存回退
						}

				}
			}

			logger.info("list3----"+JSONObject.toJSONString(list));
			if(CollectionUtils.isNotEmpty(list) && list.size() > 0){
				List<Long> collect = list.stream().map(FlowmeterEntity::getId).collect(Collectors.toList());
				logger.info("list1----"+JSONObject.toJSONString(collect));
				logger.info("list2---"+JSONObject.toJSONString(list));
				if (CollectionUtils.isNotEmpty(collect)){
					flowmeterService.removeByIds(collect,true);//删除出入库流水记录表
				}
			}
			if(realList.size() > 0){
				realtimebalanceService.updateBatchById(realList,realList.size());
			}
			if(realList1.size() > 0){
				realtimebalanceService.updateBatchById(realList1,realList1.size());
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("调拨提交--------------");
		TransferorderEntity transferorderEntity = transferorderService.selectById(billId);
		List<FlowmeterEntity> list1 = new ArrayList<>();//入库流水记录表
		List<FlowmeterEntity> list = new ArrayList<>();//出库流水记录表
		List<RealtimebalanceEntity> realList = new ArrayList<>();//修改调出实时物资结存
		List<RealtimebalanceEntity> realList1 = new ArrayList<>();//新增调入实时物资结存
		List<RealtimebalanceEntity> realList2 = new ArrayList<>();//修改调入实时物资结存
		List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
		if(transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null){
			for(TransferorderdetailEntity entity : transferorderdetailEntities){
				//实时物资结存 拨出
				QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("project_id",transferorderEntity.getDialitemsId());
				queryWrapper.eq("material_code",entity.getMaterialCode());
				queryWrapper.eq("material_category_code",entity.getMaterialCategoryCode());
				queryWrapper.eq("store_id",transferorderEntity.getIssuingWarehouse());
				RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper);
				if(realtimebalanceEntity != null){
						FlowmeterEntity flowmeterEntity = this.createrFlowmeter(transferorderEntity,entity,0);//调拨出库
						list.add(flowmeterEntity);//出入库流水表
						realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
						if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
							realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getTransferAmount()));
							realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
							realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
							realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
						}else{
							realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.00));
							realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.00));
							realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
							realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
						}
						realList.add(realtimebalanceEntity);//修改调出实时物资结存
						//拨入
						FlowmeterEntity flowmeterEntity1 = this.createrFlowmeter(transferorderEntity,entity,1);//调拨入库
						list1.add(flowmeterEntity1);//出入库流水表
						QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
						queryWrapper1.eq("project_id",transferorderEntity.getDialinitemsId());
						queryWrapper1.eq("material_code",entity.getMaterialCode());
						queryWrapper1.eq("material_category_code",entity.getMaterialCategoryCode());
						queryWrapper1.eq("store_id",transferorderEntity.getIncomingWarehouse());
						RealtimebalanceEntity realtimebalanceEntity1 = realtimebalanceService.getOne(queryWrapper1);
						if(realtimebalanceEntity1 != null){
							realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(entity.getQuantity()));
							realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(entity.getEnterAmount()));
							realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(entity.getEnterAmountExcluetax()));
							if(realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0){
								realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
								realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
							}else{
								realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.00));
								realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.00));
							}
							realList2.add(realtimebalanceEntity1);//修改调入实时物资结存
						}else{
							RealtimebalanceEntity realtimebalanceEntity2 = new RealtimebalanceEntity();
							realtimebalanceEntity2.setProjectId(transferorderEntity.getDialinitemsId());
							realtimebalanceEntity2.setProjectName(transferorderEntity.getDialInitems());
							realtimebalanceEntity2.setMaterialCode(entity.getMaterialCode());
							realtimebalanceEntity2.setMaterialName(entity.getMaterialName());
							realtimebalanceEntity2.setMaterialCategoryId(entity.getMaterialCategoryId());
							realtimebalanceEntity2.setMaterialCategoryCode(entity.getMaterialCategoryCode());
							realtimebalanceEntity2.setMaterialCategoryName(entity.getMaterialCategoryName());
							realtimebalanceEntity2.setStoreId(transferorderEntity.getIncomingWarehouse());
							realtimebalanceEntity2.setStoreName(transferorderEntity.getIncomingWarehouseName());
							realtimebalanceEntity2.setQuantity(entity.getQuantity());
							realtimebalanceEntity2.setUnitPriceIncluetax(entity.getEnterPrice());
							realtimebalanceEntity2.setUnitPriceExcluetax(entity.getEnterUnitPrice());
							realtimebalanceEntity2.setAmountIncluetax(entity.getEnterAmount());
							realtimebalanceEntity2.setAmountExcluetax(entity.getEnterAmountExcluetax());
							realtimebalanceEntity2.setOrgId(transferorderEntity.getOrgId());
							realtimebalanceEntity2.setOrgName(transferorderEntity.getOrgName());
							realtimebalanceEntity2.setMeasurementUnit(entity.getMeasurementUnit());
							realtimebalanceEntity2.setSpecialModel(entity.getSpecialModel());
							realtimebalanceEntity2.setProjectDepartmentId(transferorderEntity.getProjectDepartmentId());
							realList1.add(realtimebalanceEntity2);//新增调入实时物资结存
						}
				}
			}

			if(list1.size() > 0){
				flowmeterService.saveBatch(list1,list1.size());//修改出入库流水记录incomingWarehouse
				for(FlowmeterEntity flowmeterEntity : list1){
					flowmeterService.updateFlow(flowmeterEntity.getMid(),new Date(),1);
				}
				realtimebalanceService.updateRealtimeBalance(transferorderEntity.getIncomingWarehouse());
			}
			if(list.size() > 0){
				//改出库状态
				for(FlowmeterEntity flowmeterEntity : list){
					flowmeterService.updateFlow(flowmeterEntity.getMid(),new Date(),1);
				}
			}
			/*if(realList.size() > 0){
				realtimebalanceService.updateBatchById(realList,realList.size());//修改调出实时物资结存
			}
			if(realList1.size() > 0){
				realtimebalanceService.saveBatch(realList1,realList1.size());//新增调入实时物资结存
			}
			if(realList2.size() > 0){
				realtimebalanceService.updateBatchById(realList2,realList2.size());//修改调入实时物资结存
			}*/
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		TransferorderEntity transferorderEntity = transferorderService.selectById(billId);

		if(transferorderEntity.getSourceType() != null && transferorderEntity.getSourceType() == 2){
			CommonResponse.error("资产盘活生成的调拨单不允许撤回!");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("调拨提交--------------");
		TransferorderEntity transferorderEntity = transferorderService.selectById(billId);
		List<FlowmeterEntity> list1 = new ArrayList<>();//入库流水记录表
		List<FlowmeterEntity> list = new ArrayList<>();//出库流水记录表
		List<RealtimebalanceEntity> realList = new ArrayList<>();//修改调入实时物资结存
		List<RealtimebalanceEntity> realList1 = new ArrayList<>();//修改调出实时物资结存
		List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
		if(transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null){
			for(TransferorderdetailEntity entity : transferorderdetailEntities){
				//实时物资结存 调入
				QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("project_id",transferorderEntity.getDialinitemsId());
				queryWrapper.eq("material_code",entity.getMaterialCode());
				queryWrapper.eq("material_category_code",entity.getMaterialCategoryCode());
				queryWrapper.eq("store_id",transferorderEntity.getIncomingWarehouse());
				RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper);
				if(realtimebalanceEntity != null){
						//调入
						QueryWrapper<FlowmeterEntity> queryWrapper1 = new QueryWrapper<>();
						queryWrapper1.eq("project_id",transferorderEntity.getDialinitemsId());
						queryWrapper1.eq("detail_id",entity.getId());
						FlowmeterEntity flowmeterEntity = flowmeterService.getOne(queryWrapper1);
						list1.add(flowmeterEntity);
						realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
						realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getTransferAmount()));
						realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
						if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
							realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
							realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
						}else{
							realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
							realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
						}
						realList.add(realtimebalanceEntity);//调入实时物资库存回退

						//调出
						QueryWrapper<FlowmeterEntity> queryWrapper2 = new QueryWrapper<>();
						queryWrapper2.eq("project_id",transferorderEntity.getDialitemsId());
						queryWrapper2.eq("detail_id",entity.getId());
						FlowmeterEntity flowmeterEntity1 = flowmeterService.getOne(queryWrapper2);
						list.add(flowmeterEntity1);

						QueryWrapper<RealtimebalanceEntity> queryWrapper3 = new QueryWrapper<>();
						queryWrapper3.eq("project_id",transferorderEntity.getDialitemsId());
						queryWrapper3.eq("material_code",entity.getMaterialCode());
						queryWrapper3.eq("material_category_code",entity.getMaterialCategoryCode());
						queryWrapper3.eq("store_id",transferorderEntity.getIssuingWarehouse());
						RealtimebalanceEntity realtimebalanceEntity1 = realtimebalanceService.getOne(queryWrapper3);
						if(realtimebalanceEntity1 != null){
							realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(entity.getQuantity()));
							realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(entity.getTransferAmount()));
							realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(entity.getAmountExcluetax()));
							if(realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0){
								realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
								realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
							}else{
								realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.00));
								realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.00));
							}
							realList1.add(realtimebalanceEntity1);//调出实时物资库存回退
						}
					}

			}

			if(list1.size() > 0){
				flowmeterService.removeByIds(list1.stream().map(FlowmeterEntity::getId).collect(Collectors.toList()),true);//删除入库流水记录表
				realtimebalanceService.updateRealtimeBalance(transferorderEntity.getIncomingWarehouse());
			}
			if(list.size() > 0){
				//改出库状态
				for(FlowmeterEntity flowmeterEntity : list){
					flowmeterService.updateFlow(flowmeterEntity.getMid(),new Date(),0);
				}
			}
			/*if(realList.size() > 0){
				realtimebalanceService.updateBatchById(realList,realList.size());
			}
			if(realList1.size() > 0){
				realtimebalanceService.updateBatchById(realList1,realList1.size());
			}*/
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 *
	 * @param transferorderEntity
	 * @param entity
	 * @param status status 0-调出 1-调入
	 * @return
	 */
	public  FlowmeterEntity createrFlowmeter(TransferorderEntity transferorderEntity,TransferorderdetailEntity entity,Integer status){
		FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
		flowmeterEntity.setMid(transferorderEntity.getId());
		flowmeterEntity.setDetailId(entity.getId());
		flowmeterEntity.setBillCode(transferorderEntity.getBillCode());
		flowmeterEntity.setBillTime(transferorderEntity.getCreateTime());
		flowmeterEntity.setMaterialId(entity.getMaterialId());
		if(status == 0){
			flowmeterEntity.setProjectId(transferorderEntity.getDialitemsId());
			flowmeterEntity.setProjectName(transferorderEntity.getDialItems());
			flowmeterEntity.setStoreId(transferorderEntity.getIssuingWarehouse());
			flowmeterEntity.setStoreName(transferorderEntity.getIssuingWarehouseName());
			flowmeterEntity.setOperationType("出库");
			flowmeterEntity.setAccessType("调出");
			flowmeterEntity.setTransferorderType("调拨出库");
			flowmeterEntity.setQuantity(entity.getQuantity());
			flowmeterEntity.setUnitPriceIncluetax(entity.getTransferPrice());
			flowmeterEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
			flowmeterEntity.setAmountIncluetax(entity.getTransferAmount());
			flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
			flowmeterEntity.setProjectDepartmentId(transferorderEntity.getProjectDepartmentId());
			flowmeterEntity.setBillStatus(0); //调出
			flowmeterEntity.setStoreType(storeService.queryStoreType(transferorderEntity.getIssuingWarehouse()));
		}else if(status == 1){
			flowmeterEntity.setProjectId(transferorderEntity.getDialinitemsId());
			flowmeterEntity.setProjectName(transferorderEntity.getDialInitems());
			flowmeterEntity.setStoreId(transferorderEntity.getIncomingWarehouse());
			flowmeterEntity.setStoreName(transferorderEntity.getIncomingWarehouseName());
			flowmeterEntity.setOperationType("入库");
			flowmeterEntity.setAccessType("调入");
			flowmeterEntity.setTransferorderType("调拨入库");
			flowmeterEntity.setQuantity(entity.getQuantity());
			flowmeterEntity.setUnitPriceIncluetax(entity.getEnterPrice());
			flowmeterEntity.setUnitPriceExcluetax(entity.getEnterUnitPrice());
			flowmeterEntity.setAmountIncluetax(entity.getEnterAmount());
			flowmeterEntity.setAmountExcluetax(entity.getEnterAmountExcluetax());
			flowmeterEntity.setProjectDepartmentId(transferorderEntity.getProjectDepartmentIdEnter());
			flowmeterEntity.setBillStatus(1);
			flowmeterEntity.setStoreType(storeService.queryStoreType(transferorderEntity.getIncomingWarehouse()));
		}
		flowmeterEntity.setMaterialCode(entity.getMaterialCode());
		flowmeterEntity.setMaterialName(entity.getMaterialName());
		flowmeterEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
		flowmeterEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
		flowmeterEntity.setMaterialCategoryName(entity.getMaterialCategoryName());

		flowmeterEntity.setTime(transferorderEntity.getDates());
		flowmeterEntity.setMeasurementUnit(entity.getMeasurementUnit());
		flowmeterEntity.setSpecialModel(entity.getSpecialModel());
		flowmeterEntity.setOrgId(transferorderEntity.getOrgId());
		flowmeterEntity.setOrgName(transferorderEntity.getOrgName());
		flowmeterEntity.setBillType(2);

		return  flowmeterEntity;
	}

}
