package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.vo.TransferorderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.TransferorderMapper;
import com.ejianc.business.material.service.ITransferorderService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资调拨单
 *
 * @author generator
 *
 */
@Service("transferorderService")
public class TransferorderServiceImpl extends BaseServiceImpl<TransferorderMapper, TransferorderEntity> implements ITransferorderService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "WZ_DBD";//此处需要根据实际修改

    @Autowired
    private IRealtimebalanceService realtimebalanceService;

    @Autowired
    private IFlowmeterService flowmeterService;

    @Autowired
    private TransferorderBpmServiceImpl transferorderBpmService;

    @Override
    public TransferorderVO saveOrUpdate(TransferorderVO transferorderVO) {
        TransferorderEntity entity = BeanMapper.map(transferorderVO, TransferorderEntity.class);
        entity.setSourceType(1);
        if(entity.getDialinitemsId().equals(entity.getDialitemsId()) ){
            throw new BusinessException("同一项目下不能进行调拨！");
        }
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        for (TransferorderdetailEntity transferorderdetailEntity : entity.getTransferorderdetailEntities()) {
            transferorderdetailEntity.setEnterStoreId(entity.getIncomingWarehouse());
            transferorderdetailEntity.setEnterStoreName(entity.getIncomingWarehouseName());
            transferorderdetailEntity.setHairStoreId(entity.getIssuingWarehouse());
            transferorderdetailEntity.setHairStoreName(entity.getIssuingWarehouseName());
            transferorderdetailEntity.setPickingTime(entity.getDates());
        }
        this.saveOrUpdate(entity, false);
        //如果是调拨出得，保存推送流水，重算结存

        List<Long> materialIds = entity.getTransferorderdetailEntities().stream().map(TransferorderdetailEntity::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlow = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlow.eq(FlowmeterEntity::getStoreId, entity.getIssuingWarehouse());
        lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
        if (transferorderVO.getId() != null) {
            lambdaFlow.ne(FlowmeterEntity::getMid, transferorderVO.getId());
        }
        List<FlowmeterEntity> flowmeterEntityList = flowmeterService.list(lambdaFlow);
        Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal inNum = BigDecimal.ZERO;
        BigDecimal outNum = BigDecimal.ZERO;
        for (TransferorderdetailEntity materialWarehousingdetailEntity1 : entity.getTransferorderdetailEntities()){
            inNum = BigDecimal.ZERO;
            outNum = BigDecimal.ZERO;
            if (numInMap.containsKey(materialWarehousingdetailEntity1.getMaterialId())){
                inNum = numInMap.get(materialWarehousingdetailEntity1.getMaterialId());
            }
            if (numOutMap.containsKey(materialWarehousingdetailEntity1.getMaterialId())){
                outNum = numOutMap.get(materialWarehousingdetailEntity1.getMaterialId());
            }
            BigDecimal subtract = inNum.subtract(outNum);
            BigDecimal qaty = new BigDecimal("-1");
            if (materialWarehousingdetailEntity1.getQuantity().compareTo(subtract) == 1){
                throw new BusinessException("物资编号:" + materialWarehousingdetailEntity1.getMaterialCode() + ",物资名称:" + materialWarehousingdetailEntity1.getMaterialName() + "库存不足，不能调拨!");
            }
        }

        //先删后增
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid,entity.getId());
        flowmeterService.remove(lambdaFlower);

        TransferorderEntity transferorderEntity = entity;
        List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
        List<RealtimebalanceEntity> realList = new ArrayList<>();//修改调出实时物资结存
        List<RealtimebalanceEntity> realList1 = new ArrayList<>();//新增调入实时物资结存
        List<RealtimebalanceEntity> realList2 = new ArrayList<>();//修改调入实时物资结存
        List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
        if(transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null){
            for(TransferorderdetailEntity transferorderdetailEntity : transferorderdetailEntities){
                //实时物资结存 拨出
                QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("project_id",transferorderEntity.getDialitemsId());
                queryWrapper.eq("material_code",transferorderdetailEntity.getMaterialCode());
                queryWrapper.eq("material_category_code",transferorderdetailEntity.getMaterialCategoryCode());
                queryWrapper.eq("store_id",transferorderEntity.getIssuingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper);
                if(realtimebalanceEntity != null){
                    FlowmeterEntity flowmeterEntity = transferorderBpmService.createrFlowmeter(transferorderEntity,transferorderdetailEntity,0);//调拨出库
                    list.add(flowmeterEntity);//出入库流水表
                        /*realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(transferorderdetailEntity.getQuantity()));
                        if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
                            realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(transferorderdetailEntity.getTransferAmount()));
                            realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(transferorderdetailEntity.getAmountExcluetax()));
                            realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                            realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                        }else{
                            realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.00));
                            realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.00));
                            realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
                            realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
                        }
                        realList.add(realtimebalanceEntity);//修改调出实时物资结存*/
                        //拨入

                     /*   FlowmeterEntity flowmeterEntity1 = transferorderBpmService.createrFlowmeter(transferorderEntity,transferorderdetailEntity,1);//调拨入库
                        list.add(flowmeterEntity1);//出入库流水表
                        QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
                        queryWrapper1.eq("project_id",transferorderEntity.getDialinitemsId());
                        queryWrapper1.eq("material_code",transferorderdetailEntity.getMaterialCode());
                        queryWrapper1.eq("material_category_code",transferorderdetailEntity.getMaterialCategoryCode());
                        queryWrapper1.eq("store_id",transferorderEntity.getIncomingWarehouse());
                        RealtimebalanceEntity realtimebalanceEntity1 = realtimebalanceService.getOne(queryWrapper1);
                        if(realtimebalanceEntity1 != null){
                            realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(transferorderdetailEntity.getQuantity()));
                            realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(transferorderdetailEntity.getEnterAmount()));
                            realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(transferorderdetailEntity.getEnterAmountExcluetax()));
                            if(realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0){
                                realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                                realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                            }else{
                                realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.00));
                                realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.00));
                            }
                            realList2.add(realtimebalanceEntity1);//修改调入实时物资结存
                        }else{
                            RealtimebalanceEntity realtimebalanceEntity2 = new RealtimebalanceEntity();
                            realtimebalanceEntity2.setProjectId(transferorderEntity.getDialinitemsId());
                            realtimebalanceEntity2.setProjectName(transferorderEntity.getDialInitems());
                            realtimebalanceEntity2.setMaterialCode(transferorderdetailEntity.getMaterialCode());
                            realtimebalanceEntity2.setMaterialName(transferorderdetailEntity.getMaterialName());
                            realtimebalanceEntity2.setMaterialCategoryId(transferorderdetailEntity.getMaterialCategoryId());
                            realtimebalanceEntity2.setMaterialCategoryCode(transferorderdetailEntity.getMaterialCategoryCode());
                            realtimebalanceEntity2.setMaterialCategoryName(transferorderdetailEntity.getMaterialCategoryName());
                            realtimebalanceEntity2.setStoreId(transferorderEntity.getIncomingWarehouse());
                            realtimebalanceEntity2.setStoreName(transferorderEntity.getIncomingWarehouseName());
                            realtimebalanceEntity2.setQuantity(transferorderdetailEntity.getQuantity());
                            realtimebalanceEntity2.setUnitPriceIncluetax(transferorderdetailEntity.getEnterPrice());
                            realtimebalanceEntity2.setUnitPriceExcluetax(transferorderdetailEntity.getEnterUnitPrice());
                            realtimebalanceEntity2.setAmountIncluetax(transferorderdetailEntity.getEnterAmount());
                            realtimebalanceEntity2.setAmountExcluetax(transferorderdetailEntity.getEnterAmountExcluetax());
                            realtimebalanceEntity2.setOrgId(transferorderEntity.getOrgId());
                            realtimebalanceEntity2.setOrgName(transferorderEntity.getOrgName());
                            realtimebalanceEntity2.setMeasurementUnit(transferorderdetailEntity.getMeasurementUnit());
                            realtimebalanceEntity2.setSpecialModel(transferorderdetailEntity.getSpecialModel());
                            realtimebalanceEntity2.setProjectDepartmentId(transferorderEntity.getProjectDepartmentId());
                            realList1.add(realtimebalanceEntity2);//新增调入实时物资结存
                        }*/

                    }

            }

            if(list.size() > 0){
              logger.info(JSONObject.toJSONString(list));
              boolean  flag = flowmeterService.saveBatch(list,list.size());//修改出入库流水记录  hairStoreId
                if(flag){
                    logger.info("成功");
                }else{
                    logger.info("失败");
                }
                realtimebalanceService.updateRealtimeBalance(entity.getIssuingWarehouse());
            }
           /* if(realList.size() > 0){
                realtimebalanceService.updateBatchById(realList,realList.size());//修改调出实时物资结存
            }
            if(realList1.size() > 0){
                realtimebalanceService.saveBatch(realList1,realList1.size());//新增调入实时物资结存
            }
            if(realList2.size() > 0){
                realtimebalanceService.updateBatchById(realList2,realList2.size());//修改调入实时物资结存
            }*/
        }
        //aggPush(entity);
        TransferorderVO vo = BeanMapper.map(entity, TransferorderVO.class);
        return vo;
    }

    @Override
    public boolean aggPush(TransferorderEntity transferorderEntity) {
        logger.info("调拨提交--------------");
        List<FlowmeterEntity> list1 = new ArrayList<>();//入库流水记录表
        List<FlowmeterEntity> list = new ArrayList<>();//出库流水记录表
        List<RealtimebalanceEntity> realList = new ArrayList<>();//修改调出实时物资结存
        List<RealtimebalanceEntity> realList1 = new ArrayList<>();//新增调入实时物资结存
        List<RealtimebalanceEntity> realList2 = new ArrayList<>();//修改调入实时物资结存
        List<TransferorderdetailEntity> transferorderdetailEntities = transferorderEntity.getTransferorderdetailEntities();
        if(transferorderdetailEntities.size() > 0 && transferorderdetailEntities != null){
            for(TransferorderdetailEntity entity : transferorderdetailEntities){
                //实时物资结存 拨出
                QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("project_id",transferorderEntity.getDialitemsId());
                queryWrapper.eq("material_code",entity.getMaterialCode());
                queryWrapper.eq("material_category_code",entity.getMaterialCategoryCode());
                queryWrapper.eq("store_id",transferorderEntity.getIssuingWarehouse());
                RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper);
                if(realtimebalanceEntity != null){
                    if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) == 0 || realtimebalanceEntity.getQuantity().compareTo(entity.getQuantity()) < 0 ){
                        throw new BusinessException("物资编码:" + entity.getMaterialCode() + ",物资名称:" + entity.getMaterialName() + "库存不足,无法调拨!");
                    }else{
                        FlowmeterEntity flowmeterEntity = transferorderBpmService.createrFlowmeter(transferorderEntity,entity,0);//调拨出库
                        list.add(flowmeterEntity);//出入库流水表
                        realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
                        if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
                            realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getTransferAmount()));
                            realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
                            realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                            realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                        }else{
                            realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.00));
                            realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.00));
                            realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
                            realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
                        }
                        realList.add(realtimebalanceEntity);//修改调出实时物资结存
                        //拨入
                        FlowmeterEntity flowmeterEntity1 = transferorderBpmService.createrFlowmeter(transferorderEntity,entity,1);//调拨入库
                        list1.add(flowmeterEntity1);//出入库流水表
                        QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
                        queryWrapper1.eq("project_id",transferorderEntity.getDialinitemsId());
                        queryWrapper1.eq("material_code",entity.getMaterialCode());
                        queryWrapper1.eq("material_category_code",entity.getMaterialCategoryCode());
                        queryWrapper1.eq("store_id",transferorderEntity.getIncomingWarehouse());
                        RealtimebalanceEntity realtimebalanceEntity1 = realtimebalanceService.getOne(queryWrapper1);
                        if(realtimebalanceEntity1 != null){
                            realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().add(entity.getQuantity()));
                            realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().add(entity.getEnterAmount()));
                            realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().add(entity.getEnterAmountExcluetax()));
                            if(realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0){
                                realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                                realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                            }else{
                                realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.00));
                                realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.00));
                            }
                            realList2.add(realtimebalanceEntity1);//修改调入实时物资结存
                        }else{
                            RealtimebalanceEntity realtimebalanceEntity2 = new RealtimebalanceEntity();
                            realtimebalanceEntity2.setProjectId(transferorderEntity.getDialinitemsId());
                            realtimebalanceEntity2.setProjectName(transferorderEntity.getDialInitems());
                            realtimebalanceEntity2.setMaterialCode(entity.getMaterialCode());
                            realtimebalanceEntity2.setMaterialName(entity.getMaterialName());
                            realtimebalanceEntity2.setMaterialCategoryId(entity.getMaterialCategoryId());
                            realtimebalanceEntity2.setMaterialCategoryCode(entity.getMaterialCategoryCode());
                            realtimebalanceEntity2.setMaterialCategoryName(entity.getMaterialCategoryName());
                            realtimebalanceEntity2.setStoreId(transferorderEntity.getIncomingWarehouse());
                            realtimebalanceEntity2.setStoreName(transferorderEntity.getIncomingWarehouseName());
                            realtimebalanceEntity2.setQuantity(entity.getQuantity());
                            realtimebalanceEntity2.setUnitPriceIncluetax(entity.getEnterPrice());
                            realtimebalanceEntity2.setUnitPriceExcluetax(entity.getEnterUnitPrice());
                            realtimebalanceEntity2.setAmountIncluetax(entity.getEnterAmount());
                            realtimebalanceEntity2.setAmountExcluetax(entity.getEnterAmountExcluetax());
                            realtimebalanceEntity2.setOrgId(transferorderEntity.getOrgId());
                            realtimebalanceEntity2.setOrgName(transferorderEntity.getOrgName());
                            realtimebalanceEntity2.setMeasurementUnit(entity.getMeasurementUnit());
                            realtimebalanceEntity2.setSpecialModel(entity.getSpecialModel());
                            realtimebalanceEntity2.setProjectDepartmentId(transferorderEntity.getProjectDepartmentId());
                            realList1.add(realtimebalanceEntity2);//新增调入实时物资结存
                        }
                    }
                }else{
                    throw new BusinessException("该物资编码:" + entity.getMaterialCode() + ",物资名称:" + entity.getMaterialName() + "没有库存,无法调拨!");
                }
            }

            if(list1.size() > 0){
                flowmeterService.saveBatch(list1,list1.size());//修改出入库流水记录incomingWarehouse
                realtimebalanceService.updateRealtimeBalance(transferorderEntity.getIncomingWarehouse());
            }
            if(list.size() > 0){
                //改出库状态
                for(FlowmeterEntity flowmeterEntity : list){
                    flowmeterService.updateFlow(flowmeterEntity.getMid(),new Date(),1);
                }
            }
			/*if(realList.size() > 0){
				realtimebalanceService.updateBatchById(realList,realList.size());//修改调出实时物资结存
			}
			if(realList1.size() > 0){
				realtimebalanceService.saveBatch(realList1,realList1.size());//新增调入实时物资结存
			}
			if(realList2.size() > 0){
				realtimebalanceService.updateBatchById(realList2,realList2.size());//修改调入实时物资结存
			}*/
        }
        return true;
    }

    @Override
    public List<TransferorderVO> queryTransList(Page<TransferorderVO> page, QueryWrapper<TransferorderEntity> wrapper, Integer type, List<Long> commonOrgIds, List<Long> departmentIds) {
        return baseMapper.queryTransList(page, wrapper,type,commonOrgIds,departmentIds);
    }
}
