package com.ejianc.business.material.utils;


import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;

import java.util.*;

/**
 * @author yqls
 * @date 2024-02-18 15:20:55
 */
public class ResultAsTree<T> {
    public ResultAsTree() {
    }

    public static <T> List<Map<String, Object>> createTree(List<T> list) {
        List<Map> map = BeanMapper.mapList(list, Map.class);
        map.forEach(vo -> {
            vo.put("isLeaf", false);
            vo.put("children", new ArrayList<>());
        });
        List<Map<String, Object>> result = ResultAsTree.createTreeData(map);
        setChildrenNull(result);
        return result;
    }

    public static List<Map<String, Object>> createTreeData(List<Map> list) {
        List<Map<String, Object>> resp = new ArrayList();
        List<String> rootItems = new ArrayList();
        Map<String, Map<String, Object>> listMap = new HashMap();
        Iterator var4 = list.iterator();

        Map item;
        while(var4.hasNext()) {
            item = (Map)var4.next();
            listMap.put(item.get("id").toString(), item);
        }

        for(int i = 0; i < list.size(); ++i) {
            item = (Map)list.get(i);
            String parentId = item.get("parentId") != null ? item.get("parentId").toString() : "";
            Map<String, Object> parent = (Map)listMap.get(parentId);
            if (parent != null) {
                List<Map<String, Object>> child = (List)parent.get("children");
                if (child != null) {
                    child.add(item);
                } else {
                    List<Map<String, Object>> children = new ArrayList();
                    children.add(item);
                    parent.put("children", children);
                }
            } else {
                rootItems.add(item.get("id").toString());
            }
        }
        var4 = rootItems.iterator();
        while(var4.hasNext()) {
            String rootId = (String)var4.next();
            resp.add(listMap.get(rootId));
        }
        return resp;
    }

    private static void setChildrenNull(List<Map<String, Object>> list){
        for(Map<String, Object> map : list){
            if(!map.containsKey("children")){
                map.put("isLeaf", true);
                continue;
            }
            ArrayList children = (ArrayList) map.get("children");
            if(CollectionUtils.isNotEmpty(children)){
                setChildrenNull(children);
            } else {
                map.put("isLeaf", true);
                map.put("children", null);
            }
        }
    }
}
