package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;


/**
 * 物资/周转材退场记录单子表
 *
 * @author generator
 *
 */
public class MaterialsreturndetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long mid; // 主表id
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String remarks; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private String name; // 物资名称
    private String spec; // 规格型号
    private String unit; // 单位
    private java.math.BigDecimal returnCount; // 退场数量
    private java.math.BigDecimal lostCount; // 丢失数量
    private java.math.BigDecimal maintainCount; // 维修数量
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private java.lang.String materialCode; // 物资编码
    private java.lang.Long materialClassId; // 物资分类id
    private String materialClassCode; // 物资分类编码
    private String materialClassName; // 物资分类名称
    private Long approachDetailId; // 进场单子表id

    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    private String errorMsg; // 导入错误信息

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    /**
     * 主表id
     */
    public Long getMid() {
        return mid;
    }

    /**
     * 主表id
     */
    public void setMid(Long mid) {
        this.mid = mid;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 物资名称
     */
    public String getName() {
        return name;
    }

    /**
     * 物资名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 退场数量
     */
    public java.math.BigDecimal getReturnCount() {
        return returnCount;
    }

    /**
     * 退场数量
     */
    public void setReturnCount(java.math.BigDecimal returnCount) {
        this.returnCount = returnCount;
    }
    /**
     * 丢失数量
     */
    public java.math.BigDecimal getLostCount() {
        return lostCount;
    }

    /**
     * 丢失数量
     */
    public void setLostCount(java.math.BigDecimal lostCount) {
        this.lostCount = lostCount;
    }
    /**
     * 维修数量
     */
    public java.math.BigDecimal getMaintainCount() {
        return maintainCount;
    }

    /**
     * 维修数量
     */
    public void setMaintainCount(java.math.BigDecimal maintainCount) {
        this.maintainCount = maintainCount;
    }
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getMaterialClassId() {
        return materialClassId;
    }

    public void setMaterialClassId(Long materialClassId) {
        this.materialClassId = materialClassId;
    }

    public String getMaterialClassCode() {
        return materialClassCode;
    }

    public void setMaterialClassCode(String materialClassCode) {
        this.materialClassCode = materialClassCode;
    }

    public String getMaterialClassName() {
        return materialClassName;
    }

    public void setMaterialClassName(String materialClassName) {
        this.materialClassName = materialClassName;
    }

    public Long getApproachDetailId() {
        return approachDetailId;
    }

    public void setApproachDetailId(Long approachDetailId) {
        this.approachDetailId = approachDetailId;
    }
}
