package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

public class StoreVO extends BaseVO {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

    /**
     * 仓库名称
     */
    private String name;

    /**
     * 仓库类型（1、组织仓库，2、项目仓库）
     */
    private String projectType;

    /**
     * 仓库类型（1、组织仓库，2、项目仓库）
     */
    private String projectTypeName;

    /**
     * 仓库状态（1、启用，0、停用）
     */
    private String state;
	private String stateName;//仓库状态（1、启用，0、停用）


	/**
     * 所属项目
     */
    private Long projectId;

    /**
     * 所属项目名称
     */
    private String projectName;

    /**
     * 所属项目编码
     */
    private String projectCode;

    /**
     * 所属组织
     */
    private Long orgId;

	/**
	 * 项目部id
	 */
	private java.lang.Long projectDepartmentId;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 库存物资种类
     */
    private String storeMaterialName;

    /**
     * 库存金额（元）
     */
    private BigDecimal storeAmount;
	/**
	 * 是否影响成本 0-是 1-否
	 */
	private Integer isInfluenceCost;
	/**
	 * 仓库类型 0-成品库 1-废旧物资库 2-资产库
	 */
	private Integer storeType;
	private String storeTypeName;//仓库类型 0-成品库 1-废旧物资库 2-资产库

	public String getStateName() {
		return stateName;
	}

	public void setStateName(String stateName) {
		this.stateName = stateName;
	}

	public String getStoreTypeName() {
		return storeTypeName;
	}

	public void setStoreTypeName(String storeTypeName) {
		this.storeTypeName = storeTypeName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	@ReferSerialTransfer(referCode = "ejc-zjkj-project")
	public Long getProjectId() {
		return projectId;
	}

	@ReferDeserialTransfer
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	@ReferSerialTransfer(referCode = "idm-org")
	public Long getOrgId() {
		return orgId;
	}

	@ReferDeserialTransfer
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public void setProjectTypeName(String projectTypeName) {
		this.projectTypeName = projectTypeName;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

	public String getProjectType() {
		return projectType;
	}

	public void setProjectType(String projectType) {
		this.projectType = projectType;
	}

	public String getStoreMaterialName() {
		return storeMaterialName;
	}

	public void setStoreMaterialName(String storeMaterialName) {
		this.storeMaterialName = storeMaterialName;
	}

	public BigDecimal getStoreAmount() {
		return storeAmount;
	}

	public void setStoreAmount(BigDecimal storeAmount) {
		this.storeAmount = storeAmount;
	}

	public String getProjectTypeName() {
		if("1".equals(projectType)){
			return "项目仓库";
		}else if("2".equals(projectType)){
			return "公司仓库";
		}else{
			return projectType;
		}

	}

	public Integer getIsInfluenceCost() {
		return isInfluenceCost;
	}

	public void setIsInfluenceCost(Integer isInfluenceCost) {
		this.isInfluenceCost = isInfluenceCost;
	}

	public Integer getStoreType() {
		return storeType;
	}

	public void setStoreType(Integer storeType) {
		this.storeType = storeType;
	}
}
