package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 物资出库记录子表
 *
 * @author generator
 *
 */
public class SupDeliveryrecorddetailVO {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.util.Date approveTime; // 审批通过日期
    private String sorts; // 序号
    private String materialCode; // 物资编码
    private String materialName; // 物资名称
    private String specialModel; // 规格型号
    private String measurementUnit; // 计量单位
    private BigDecimal deliveryQuantity; // 出库数量
    private BigDecimal unitPriceIncluetax; // 单价（含税）（元）
    private BigDecimal taxRate; // 税率
    private BigDecimal unitPriceExcluetax; // 单价（无税）
    private BigDecimal amountIncluetax; // 金额（含税）
    private BigDecimal amountExcluetax; // 金额（无税）
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private String remarks; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private String signatureCust; // 保管员签字
    private String projectMaterial; // 项目物资部
    private String projectEngineer; // 项目物资部
    private String ministry; // 商务部
    private java.util.Date approvalDate; // 审批日期
    private Long mid; // 主表id
    private String errorMsg; // 导入错误信息

    private BigDecimal reserve; // 存放库存字段

    private String storeName;//仓库名称
    private Long materialCategoryId; // 物资分类id
    private String materialCategoryCode; // 物资分类编码
    private String materialCategoryName; // 物资分类名称
    private BigDecimal notReturnedQuantity; // 未退库数量
    private Long deliveryDetailId; // 出库单子表id
    private Long materialId; // 物资id
    private BigDecimal planNum; //
    private BigDecimal planSurplusNum; //
    private List<SupDeliveryrecorddetailVO> children = new ArrayList<>();
    public List<SupDeliveryrecorddetailVO> getChildren() {
        return children;
    }
    private BigDecimal deliveryNum; //退库时出库单数量

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getPlanSurplusNum() {
        return planSurplusNum;
    }

    public void setPlanSurplusNum(BigDecimal planSurplusNum) {
        this.planSurplusNum = planSurplusNum;
    }

    public BigDecimal getDeliveryNum() {
        return deliveryNum;
    }

    public void setDeliveryNum(BigDecimal deliveryNum) {
        this.deliveryNum = deliveryNum;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public void setChildren(List<SupDeliveryrecorddetailVO> children) {
        this.children = children;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批通过日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批通过日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 序号
     */
    public String getSorts() {
        return sorts;
    }

    /**
     * 序号
     */
    public void setSorts(String sorts) {
        this.sorts = sorts;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public String getSpecialModel() {
        return specialModel;
    }

    /**
     * 规格型号
     */
    public void setSpecialModel(String specialModel) {
        this.specialModel = specialModel;
    }
    /**
     * 计量单位
     */
    public String getMeasurementUnit() {
        return measurementUnit;
    }

    /**
     * 计量单位
     */
    public void setMeasurementUnit(String measurementUnit) {
        this.measurementUnit = measurementUnit;
    }
    /**
     * 出库数量
     */
    public BigDecimal getDeliveryQuantity() {
        return deliveryQuantity;
    }

    /**
     * 出库数量
     */
    public void setDeliveryQuantity(BigDecimal deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }
    /**
     * 单价（含税）（元）
     */
    public BigDecimal getUnitPriceIncluetax() {
        return unitPriceIncluetax;
    }

    /**
     * 单价（含税）（元）
     */
    public void setUnitPriceIncluetax(BigDecimal unitPriceIncluetax) {
        this.unitPriceIncluetax = unitPriceIncluetax;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 单价（无税）
     */
    public BigDecimal getUnitPriceExcluetax() {
        return unitPriceExcluetax;
    }

    /**
     * 单价（无税）
     */
    public void setUnitPriceExcluetax(BigDecimal unitPriceExcluetax) {
        this.unitPriceExcluetax = unitPriceExcluetax;
    }
    /**
     * 金额（含税）
     */
    public BigDecimal getAmountIncluetax() {
        return amountIncluetax;
    }

    /**
     * 金额（含税）
     */
    public void setAmountIncluetax(BigDecimal amountIncluetax) {
        this.amountIncluetax = amountIncluetax;
    }
    /**
     * 金额（无税）
     */
    public BigDecimal getAmountExcluetax() {
        return amountExcluetax;
    }

    /**
     * 金额（无税）
     */
    public void setAmountExcluetax(BigDecimal amountExcluetax) {
        this.amountExcluetax = amountExcluetax;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 变更单据id
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更单据id
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public String getChangeState() {
        return changeState;
    }

    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 保管员签字
     */
    public String getSignatureCust() {
        return signatureCust;
    }

    /**
     * 保管员签字
     */
    public void setSignatureCust(String signatureCust) {
        this.signatureCust = signatureCust;
    }
    /**
     * 项目物资部
     */
    public String getProjectMaterial() {
        return projectMaterial;
    }

    /**
     * 项目物资部
     */
    public void setProjectMaterial(String projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    /**
     * 项目物资部
     */
    public String getProjectEngineer() {
        return projectEngineer;
    }

    /**
     * 项目物资部
     */
    public void setProjectEngineer(String projectEngineer) {
        this.projectEngineer = projectEngineer;
    }
    /**
     * 商务部
     */
    public String getMinistry() {
        return ministry;
    }

    /**
     * 商务部
     */
    public void setMinistry(String ministry) {
        this.ministry = ministry;
    }
    /**
     * 审批日期
     */
    public java.util.Date getApprovalDate() {
        return approvalDate;
    }

    /**
     * 审批日期
     */
    public void setApprovalDate(java.util.Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public BigDecimal getReserve() {
        return reserve;
    }

    public void setReserve(BigDecimal reserve) {
        this.reserve = reserve;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public BigDecimal getNotReturnedQuantity() {
        return notReturnedQuantity;
    }

    public void setNotReturnedQuantity(BigDecimal notReturnedQuantity) {
        this.notReturnedQuantity = notReturnedQuantity;
    }

    public Long getDeliveryDetailId() {
        return deliveryDetailId;
    }

    public void setDeliveryDetailId(Long deliveryDetailId) {
        this.deliveryDetailId = deliveryDetailId;
    }
}
