package com.ejianc.business.outputValue.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 公司月度产值录入
 * 
 * @author generator
 * 
 */
 @TableName("ejc_output_value_company_month")
public class CompanyMonthEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 区域公司
    @TableField(value="org_name")
    private String orgName; // 区域公司名称
    @TableField(value="org_short_name")
    private String orgShortName; // 区域简称
    @TableField(value="year")
    private String year; // 年度
    @TableField(value="month")
    private String month; // 月份
    @TableField(value="this_year_actual_total_output_value")
    private BigDecimal thisYearActualTotalOutputValue; // 本年累计完成产值合计（万元）
    @TableField(value="this_year_confirmed_output_value")
    private BigDecimal thisYearConfirmedOutputValue; // 本年累计确认产值合计（万元）
    @TableField(value="change_id")
    private Long changeId; // 变更单id
    @TableField(value="change_state")
    private String changeState; // 变更状态1未变更、2变更中、3已变更
    @TableField(value="effect_last_date")
    private Date effectLastDate; // 生效日期
    
    @TableField(exist=false)
    @SubEntity(serviceName="companyMonthProjectDetailService", pidName="companyMonthId")//此处有pid="xxx"，默认值pid="pid"
    private List<CompanyMonthProjectDetailEntity> detailList = new ArrayList<>(); // 公司月度产值录入-项目
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgShortName() {
        return orgShortName;
    }

    public void setOrgShortName(String orgShortName) {
        this.orgShortName = orgShortName;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }
    public BigDecimal getThisYearActualTotalOutputValue() {
        return thisYearActualTotalOutputValue;
    }

    public void setThisYearActualTotalOutputValue(BigDecimal thisYearActualTotalOutputValue) {
        this.thisYearActualTotalOutputValue = thisYearActualTotalOutputValue;
    }
    public BigDecimal getThisYearConfirmedOutputValue() {
        return thisYearConfirmedOutputValue;
    }

    public void setThisYearConfirmedOutputValue(BigDecimal thisYearConfirmedOutputValue) {
        this.thisYearConfirmedOutputValue = thisYearConfirmedOutputValue;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }

    public List<CompanyMonthProjectDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CompanyMonthProjectDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
