package com.ejianc.business.outputValue.bean;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 工厂月度实际产值
 *
 * @author generator
 *
 */
 @TableName("ejc_output_value_month_pc_actual")
public class PcMonthActualOutputValueEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="change_state")
    private String changeState; // 变更状态
    @TableField(value="change_id")
    private Long changeId; // 变更单据
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="year")
    private String year; // 年度
    @TableField(value="month")
    private String month; // 月份
    @TableField(value="this_month_presence_management_person_num")
    private Long thisMonthPresenceManagementPersonNum; //本月在场管理人员数量
    @TableField(value="this_month_own_industry_person_num")
    private Long thisMonthOwnIndustryPersonNum; // 本月自有产业工人数量
    @TableField(value="this_month_external_labor_person_num")
    private Long thisMonthExternalLaborPersonNum; // 本月外部劳务工人数量

    @TableField(value="this_month_completed_total_output_value")
    private BigDecimal thisMonthCompletedTotalOutputValue; // 本月完成总产值（万元）
    @TableField(value="this_month_within_output_value")
    private BigDecimal thisMonthWithinOutputValue; // 本月中建科技内总产值（万元）
    @TableField(value="this_month_brother_output_value")
    private BigDecimal thisMonthBrotherOutputValue; // 本月中建内(除科技)总产值（万元）
    @TableField(value="this_month_outside_output_value")
    private BigDecimal thisMonthOutsideOutputValue; // 本月中建外总产值（万元）

    @TableField(value="reward_punishment_situation")
    private String rewardPunishmentSituation; // '奖罚情况'
    @TableField(value="remarks")
    private String remarks; // '备注'

    @TableField(value = "effect_last_date",fill = FieldFill.UPDATE)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date effectLastDate; // 最后生效日期

    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public Long getThisMonthPresenceManagementPersonNum() {
        return thisMonthPresenceManagementPersonNum;
    }

    public void setThisMonthPresenceManagementPersonNum(Long thisMonthPresenceManagementPersonNum) {
        this.thisMonthPresenceManagementPersonNum = thisMonthPresenceManagementPersonNum;
    }

    public Long getThisMonthOwnIndustryPersonNum() {
        return thisMonthOwnIndustryPersonNum;
    }

    public void setThisMonthOwnIndustryPersonNum(Long thisMonthOwnIndustryPersonNum) {
        this.thisMonthOwnIndustryPersonNum = thisMonthOwnIndustryPersonNum;
    }

    public Long getThisMonthExternalLaborPersonNum() {
        return thisMonthExternalLaborPersonNum;
    }

    public void setThisMonthExternalLaborPersonNum(Long thisMonthExternalLaborPersonNum) {
        this.thisMonthExternalLaborPersonNum = thisMonthExternalLaborPersonNum;
    }

    public BigDecimal getThisMonthCompletedTotalOutputValue() {
        return thisMonthCompletedTotalOutputValue;
    }

    public void setThisMonthCompletedTotalOutputValue(BigDecimal thisMonthCompletedTotalOutputValue) {
        this.thisMonthCompletedTotalOutputValue = thisMonthCompletedTotalOutputValue;
    }

    public BigDecimal getThisMonthWithinOutputValue() {
        return thisMonthWithinOutputValue;
    }

    public void setThisMonthWithinOutputValue(BigDecimal thisMonthWithinOutputValue) {
        this.thisMonthWithinOutputValue = thisMonthWithinOutputValue;
    }

    public BigDecimal getThisMonthBrotherOutputValue() {
        return thisMonthBrotherOutputValue;
    }

    public void setThisMonthBrotherOutputValue(BigDecimal thisMonthBrotherOutputValue) {
        this.thisMonthBrotherOutputValue = thisMonthBrotherOutputValue;
    }

    public BigDecimal getThisMonthOutsideOutputValue() {
        return thisMonthOutsideOutputValue;
    }

    public void setThisMonthOutsideOutputValue(BigDecimal thisMonthOutsideOutputValue) {
        this.thisMonthOutsideOutputValue = thisMonthOutsideOutputValue;
    }

    public String getRewardPunishmentSituation() {
        return rewardPunishmentSituation;
    }

    public void setRewardPunishmentSituation(String rewardPunishmentSituation) {
        this.rewardPunishmentSituation = rewardPunishmentSituation;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }
}
