package com.ejianc.business.outputValue.controller;

import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaRecordService;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公司经营指标
 *
 */
@RestController
@RequestMapping("/companyBusinessQuotaRecord/")
public class CompanyBusinessQuotaRecordController {

	@Autowired
	private ICompanyBusinessQuotaRecordService recordService;
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompanyBusinessQuotaRecordVO> queryDetail(Long id) {
        CompanyBusinessQuotaRecordEntity entity = recordService.selectById(id);
        CompanyBusinessQuotaRecordVO vo = BeanMapper.map(entity, CompanyBusinessQuotaRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
