package com.ejianc.business.outputValue.controller;

import com.ejianc.business.outputValue.bean.CompanyMonthRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyMonthRecordService;
import com.ejianc.business.outputValue.vo.CompanyMonthRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 公司月度产值录入记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("companyMonthRecord")
public class CompanyMonthRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ICompanyMonthRecordService recordService;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompanyMonthRecordVO> queryDetail(Long id) {
        CompanyMonthRecordEntity entity = recordService.selectById(id);
        CompanyMonthRecordVO vo = BeanMapper.map(entity, CompanyMonthRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
}
