package com.ejianc.business.outputValue.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outputValue.service.IOutputValueIndexService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 产值分析-门户
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outputValueIndex")
public class OutputValueIndexController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutputValueIndexService service;

    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryData() {
        JSONObject result = service.queryData();
        return CommonResponse.success("查询详情数据成功！", result);
    }
}
