package com.ejianc.business.outputValue.controller;

import com.alibaba.excel.util.ListUtils;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.OutputValueReportEntity;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaService;
import com.ejianc.business.outputValue.service.IOutputValueReportService;
import com.ejianc.business.outputValue.utils.EasyExcelUtil;
import com.ejianc.business.outputValue.utils.ExcelFillCellMerge;
import com.ejianc.business.outputValue.vo.OutputValueReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 产值分析表（统计表）
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outputValueReport")
public class OutputValueReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutputValueReportService service;
    @Autowired
    private ICompanyUndertakeQuotaService companyUndertakeQuotaService;

    /**
     * @Description queryList 查询列表
     * @param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("twoOrgName");
        fuzzyFields.add("projectStatus");
        Calendar cal = Calendar.getInstance();  // 获取当前时间的Calendar实例
        String year = String.valueOf(cal.get(Calendar.YEAR));
        if(param.getParams().get("year")!=null){
            year = param.getParams().get("year").getValue().toString();
        }else{
            param.getParams().put("year", new Parameter(QueryParam.EQ, year));
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        param.getOrderMap().put("twoOrgSequence",QueryParam.ASC);
        param.getOrderMap().put("twoOrgId",QueryParam.DESC);
        param.getOrderMap().put("orgId",QueryParam.DESC);
        param.getOrderMap().put("projectNum",QueryParam.ASC);
        param.getOrderMap().put("createTime",QueryParam.DESC);
        List<OutputValueReportEntity> entitys = service.queryList(param);

        List<OutputValueReportVO> vos = this.dealResultVOList(entitys, year);
        JSONObject margeData = this.getMargeData(vos);

        JSONObject result = new JSONObject();
        result.put("data", vos);
        result.put("margeData", margeData);
        return CommonResponse.success("查询列表数据成功！",result);
    }

    private JSONObject getMargeData(List<OutputValueReportVO> vos) {
        LinkedHashMap<String, JSONObject> colMarge = new LinkedHashMap<>();
        List<JSONObject> orgNameRowMarge = new ArrayList<>();
        List<Integer> totalPlanIndex = new ArrayList<>();
        JSONObject margeData = new JSONObject();
        Long twoOrgId = null;
        Integer twoOrgMargeIndex = 0;
        Integer twoOrgMargeRange = 0;

        Long orgId = null;
        Integer orgMargeIndex = 0;
        Integer orgMargeRange = 0;
        Long projectId = null;

        for(int i=0; i<vos.size(); i++){
            OutputValueReportVO vo = vos.get(i);
            vo.setRowId((long) i);
            if(twoOrgId!=null){
                if(!vo.getTwoOrgId().equals(twoOrgId)){
                    //二级组织不一致，则说明数据已是下一个区域公司的数据，则区域公司的合并数据需要另行计算,且要补充上一次的合并信息
                    //存放旧数据处理
                    JSONObject olMarge = new JSONObject();
                    olMarge.put("dataMargeIndex", i-twoOrgMargeRange-1);
                    olMarge.put("dataMargeRange", twoOrgMargeRange);
                    colMarge.put("twoOrgId"+twoOrgId, olMarge);

                    //新数据初始化
                    twoOrgMargeIndex = i;
                    twoOrgMargeRange = 0;
                    twoOrgId = vo.getTwoOrgId();
                }else{
                    twoOrgMargeRange ++;
                }
            }else{
                twoOrgId = vo.getTwoOrgId();
            }
            if(orgId!=null){
                if(!vo.getOrgId().equals(orgId)){
                    //二级组织不一致，则说明数据已是下一个区域公司的数据，则区域公司的合并数据需要另行计算,且要补充上一次的合并信息
                    //存放旧数据处理
                    JSONObject olMarge = new JSONObject();
                    olMarge.put("dataMargeIndex", i-orgMargeRange-1);
                    olMarge.put("dataMargeRange", orgMargeRange);
                    colMarge.put("orgId"+orgId, olMarge);

                    //新数据初始化
                    orgMargeIndex = i;
                    orgMargeRange = 0;
                    orgId = vo.getOrgId();
                }else{
                    orgMargeRange ++;
                }
            }else{
                orgId = vo.getOrgId();
            }
            if("预计新承接项目".equals(vo.getOrgName())){
                JSONObject olMarge = new JSONObject();
                olMarge.put("dataMargeIndex", i);
                olMarge.put("dataMargeRange", 1);
                orgNameRowMarge.add(olMarge);
                JSONObject oMarge = new JSONObject();
                oMarge.put("dataMargeIndex", i-2);
                oMarge.put("dataMargeRange", 1);
                colMarge.put("projectId"+projectId, oMarge);
                projectId = null;
                continue;
            }
            if("小计".equals(vo.getOrgName())){
                JSONObject olMarge = new JSONObject();
                olMarge.put("dataMargeIndex", i);
                olMarge.put("dataMargeRange", 4);
                orgNameRowMarge.add(olMarge);
                if("计划".equals(vo.getDataType())){
                    totalPlanIndex.add(i);
                    JSONObject oMarge = new JSONObject();
                    oMarge.put("dataMargeIndex", i);
                    oMarge.put("dataMargeRange", 1);
                    colMarge.put("projectId"+vo.getTwoOrgId(), oMarge);
                }
                projectId = null;
                continue;
            }
            if(projectId!=null){
                if(!vo.getProjectId().equals(projectId)){
                    projectId = vo.getProjectId();
                    JSONObject olMarge = new JSONObject();
                    olMarge.put("dataMargeIndex", i);
                    olMarge.put("dataMargeRange", 1);
                    colMarge.put("projectId"+projectId, olMarge);
                }
            }else{
                projectId = vo.getProjectId();
                JSONObject olMarge = new JSONObject();
                olMarge.put("dataMargeIndex", i);
                olMarge.put("dataMargeRange", 1);
                colMarge.put("projectId"+projectId, olMarge);
            }
        }
        //判断最后一条数据是否在统计中（应该没有的），没有则添加信息，
        if(colMarge.get(twoOrgId)==null){
            JSONObject olMarge = new JSONObject();
            olMarge.put("dataMargeIndex", twoOrgMargeIndex);
            olMarge.put("dataMargeRange", twoOrgMargeRange);
            colMarge.put("twoOrgId"+twoOrgId, olMarge);
        }
        if(colMarge.get(orgId)==null){
            JSONObject olMarge = new JSONObject();
            olMarge.put("dataMargeIndex", orgMargeIndex);
            olMarge.put("dataMargeRange", orgMargeRange);
            colMarge.put("orgId"+orgId, olMarge);
        }

        for(String key : colMarge.keySet()){
            if(key.startsWith("twoOrgId")){
                if(margeData.get("twoOrgNameColMarge")!=null){
                    List<JSONObject> d = (List<JSONObject>) margeData.get("twoOrgNameColMarge");
                    d.add(colMarge.get(key));
                    margeData.put("twoOrgNameColMarge", d);
                }else{
                    List<JSONObject> d = new ArrayList<>();
                    d.add(colMarge.get(key));
                    margeData.put("twoOrgNameColMarge", d);
                }
            }
            if(key.startsWith("orgId")){
                if(margeData.get("orgNameColMarge")!=null){
                    List<JSONObject> d = (List<JSONObject>) margeData.get("orgNameColMarge");
                    d.add(colMarge.get(key));
                    margeData.put("orgNameColMarge", d);
                }else{
                    List<JSONObject> d = new ArrayList<>();
                    d.add(colMarge.get(key));
                    margeData.put("orgNameColMarge", d);
                }
            }
            if(key.startsWith("projectId")){
                if(margeData.get("projectNameColMarge")!=null){
                    List<JSONObject> d = (List<JSONObject>) margeData.get("projectNameColMarge");
                    d.add(colMarge.get(key));
                    margeData.put("projectNameColMarge", d);
                }else{
                    List<JSONObject> d = new ArrayList<>();
                    d.add(colMarge.get(key));
                    margeData.put("projectNameColMarge", d);
                }

                margeData.put("projectNumColMarge", margeData.get("projectNameColMarge"));
                margeData.put("actualStartDateColMarge", margeData.get("projectNameColMarge"));
                margeData.put("actualEndDateColMarge", margeData.get("projectNameColMarge"));
                margeData.put("planEndDateColMarge", margeData.get("projectNameColMarge"));
                margeData.put("contractAmountColMarge", margeData.get("projectNameColMarge"));
                margeData.put("provisionalAmountColMarge", margeData.get("projectNameColMarge"));
                margeData.put("builtAreaColMarge", margeData.get("projectNameColMarge"));
                margeData.put("lastYearAccumulateCompletedOutputValueColMarge", margeData.get("projectNameColMarge"));
                margeData.put("accumulateCompletedOutputValueColMarge", margeData.get("projectNameColMarge"));
                margeData.put("surplusOutputValueColMarge", margeData.get("projectNameColMarge"));
                margeData.put("projectStatusColMarge", margeData.get("projectNameColMarge"));
                margeData.put("thisYearProjectColMarge", margeData.get("projectNameColMarge"));
            }
        }
        margeData.put("orgNameRowMarge", orgNameRowMarge);
        margeData.put("totalPlanIndex", totalPlanIndex);
        return margeData;
    }

    private List<OutputValueReportVO> dealResultVOList(List<OutputValueReportEntity> entitys, String year) {
        Long twoOrgId = null;
        String twoOrgName = null;
        List<OutputValueReportVO> vos = new ArrayList<>();
        OutputValueReportVO allPlanVo = new OutputValueReportVO();
        OutputValueReportVO allActualVo = new OutputValueReportVO();
        for(OutputValueReportEntity entity : entitys){
            //添加该区域公司的预计承接项目和小计行数据
            if(twoOrgId!=null){
                if(!entity.getTwoOrgId().equals(twoOrgId)){
                    //统计区域公司数据---
                    QueryWrapper<CompanyUndertakeQuotaEntity> wrapper = new QueryWrapper<>();
                    wrapper.eq("year", year);
                    wrapper.in("bill_state", 1,3);
                    wrapper.eq("org_id", twoOrgId);
                    List<CompanyUndertakeQuotaEntity> list = companyUndertakeQuotaService.list(wrapper);

                    OutputValueReportVO undertakeQuota = new OutputValueReportVO();
                    undertakeQuota.setTwoOrgId(twoOrgId);
                    undertakeQuota.setTwoOrgName(twoOrgName);
                    undertakeQuota.setOrgId(twoOrgId+2222);
                    undertakeQuota.setOrgName("预计新承接项目");
                    undertakeQuota.setProjectName("预计新承接项目");
                    if(list!=null && list.size()>0){
                        CompanyUndertakeQuotaEntity en = list.get(0);
                        undertakeQuota.setYearOutputValue(en.getContractQuota());
                        undertakeQuota.setJanuaryOutputValue(en.getJanuaryContractQuota()); //1月计划/实际产值（万元）
                        undertakeQuota.setFebruaryOutputValue(en.getFebruaryContractQuota()); //2月计划/实际产值（万元）
                        undertakeQuota.setMarchOutputValue(en.getMarchContractQuota()); //3月计划/实际产值（万元）
                        undertakeQuota.setAprilOutputValue(en.getAprilContractQuota()); //4月计划/实际产值（万元）
                        undertakeQuota.setMayOutputValue(en.getMayContractQuota()); //5月计划产/实际值（万元）
                        undertakeQuota.setJuneOutputValue(en.getJuneContractQuota()); //6月计划/实际产值（万元）
                        undertakeQuota.setJulyOutputValue(en.getJulyContractQuota()); //7月计划/实际产值（万元）
                        undertakeQuota.setAugustOutputValue(en.getAugustContractQuota()); //8月计划/实际产值（万元）
                        undertakeQuota.setSeptemberOutputValue(en.getSeptemberContractQuota()); //9月计划/实际产值（万元）
                        undertakeQuota.setOctoberOutputValue(en.getOctoberContractQuota()); //10月计划/实际产值（万元）
                        undertakeQuota.setNovemberOutputValue(en.getNovemberContractQuota()); //11月计划/实际产值（万元）
                        undertakeQuota.setDecemberOutputValue(en.getDecemberContractQuota()); //12月计划/实际产值（万元）
                    }
                    vos.add(undertakeQuota);

                    //统计合计数据
                    allPlanVo.setTwoOrgId(twoOrgId);
                    allPlanVo.setTwoOrgName(twoOrgName);
                    allPlanVo.setOrgId(twoOrgId+1111);
                    allPlanVo.setOrgName("小计");
                    allPlanVo.setProjectName("小计");
                    allPlanVo.setDataType("计划");
                    vos.add(allPlanVo);
                    allActualVo.setTwoOrgId(twoOrgId);
                    allActualVo.setTwoOrgName(twoOrgName);
                    allActualVo.setOrgId(twoOrgId+1111);
                    allActualVo.setOrgName("小计");
                    allActualVo.setProjectName("小计");
                    allActualVo.setDataType("实际");
                    vos.add(allActualVo);

                    twoOrgId = entity.getTwoOrgId();
                    twoOrgName = entity.getTwoOrgName();
                    allPlanVo = new OutputValueReportVO();
                    allActualVo = new OutputValueReportVO();
                }else{
                    twoOrgId = entity.getTwoOrgId();
                    twoOrgName = entity.getTwoOrgName();

                    allPlanVo.setContractAmount(CommonUtils.addBigDecimal(allPlanVo.getContractAmount(), entity.getContractAmount()));
                    allPlanVo.setProvisionalAmount(CommonUtils.addBigDecimal(allPlanVo.getProvisionalAmount(), entity.getProvisionalAmount()));
                    allPlanVo.setBuiltArea(CommonUtils.addBigDecimal(allPlanVo.getBuiltArea(), entity.getBuiltArea()));
                    allPlanVo.setThisYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getThisYearAccumulateCompletedOutputValue(), entity.getThisYearAccumulateCompletedOutputValue()));
                    allPlanVo.setAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAccumulateCompletedOutputValue(), entity.getAccumulateCompletedOutputValue()));
                    allPlanVo.setLastYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getLastYearAccumulateCompletedOutputValue(), entity.getLastYearAccumulateCompletedOutputValue()));
                    allPlanVo.setSurplusOutputValue(CommonUtils.addBigDecimal(allPlanVo.getSurplusOutputValue(), entity.getSurplusOutputValue()));
                    allPlanVo.setYearOutputValue(CommonUtils.addBigDecimal(allPlanVo.getYearOutputValue(), entity.getYearPlanOutputValue()));
                    allPlanVo.setJanuaryOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJanuaryOutputValue(), entity.getJanuaryPlanOutputValue()));
                    allPlanVo.setFebruaryOutputValue(CommonUtils.addBigDecimal(allPlanVo.getFebruaryOutputValue(), entity.getFebruaryPlanOutputValue()));
                    allPlanVo.setMarchOutputValue(CommonUtils.addBigDecimal(allPlanVo.getMarchOutputValue(), entity.getMarchPlanOutputValue()));
                    allPlanVo.setAprilOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAprilOutputValue(), entity.getAprilPlanOutputValue()));
                    allPlanVo.setMayOutputValue(CommonUtils.addBigDecimal(allPlanVo.getMayOutputValue(), entity.getMayPlanOutputValue()));
                    allPlanVo.setJuneOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJuneOutputValue(), entity.getJunePlanOutputValue()));
                    allPlanVo.setJulyOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJulyOutputValue(), entity.getJulyPlanOutputValue()));
                    allPlanVo.setAugustOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAugustOutputValue(), entity.getAugustPlanOutputValue()));
                    allPlanVo.setSeptemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getSeptemberOutputValue(), entity.getSeptemberPlanOutputValue()));
                    allPlanVo.setOctoberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getOctoberOutputValue(), entity.getOctoberPlanOutputValue()));
                    allPlanVo.setNovemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getNovemberOutputValue(), entity.getNovemberPlanOutputValue()));
                    allPlanVo.setDecemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getDecemberOutputValue(), entity.getDecemberPlanOutputValue()));

                    allActualVo.setContractAmount(allPlanVo.getContractAmount());
                    allActualVo.setProvisionalAmount(allPlanVo.getProvisionalAmount());
                    allActualVo.setBuiltArea(allPlanVo.getBuiltArea());
                    allActualVo.setThisYearAccumulateCompletedOutputValue(allPlanVo.getThisYearAccumulateCompletedOutputValue());
                    allActualVo.setAccumulateCompletedOutputValue(allPlanVo.getAccumulateCompletedOutputValue());
                    allActualVo.setLastYearAccumulateCompletedOutputValue(allPlanVo.getLastYearAccumulateCompletedOutputValue());
                    allActualVo.setSurplusOutputValue(allPlanVo.getSurplusOutputValue());
                    allActualVo.setYearOutputValue(CommonUtils.addBigDecimal(allActualVo.getYearOutputValue(), entity.getYearActualOutputValue()));
                    allActualVo.setJanuaryOutputValue(CommonUtils.addBigDecimal(allActualVo.getJanuaryOutputValue(), entity.getJanuaryActualOutputValue()));
                    allActualVo.setFebruaryOutputValue(CommonUtils.addBigDecimal(allActualVo.getFebruaryOutputValue(), entity.getFebruaryActualOutputValue()));
                    allActualVo.setMarchOutputValue(CommonUtils.addBigDecimal(allActualVo.getMarchOutputValue(), entity.getMarchActualOutputValue()));
                    allActualVo.setAprilOutputValue(CommonUtils.addBigDecimal(allActualVo.getAprilOutputValue(), entity.getAprilActualOutputValue()));
                    allActualVo.setMayOutputValue(CommonUtils.addBigDecimal(allActualVo.getMayOutputValue(), entity.getMayActualOutputValue()));
                    allActualVo.setJuneOutputValue(CommonUtils.addBigDecimal(allActualVo.getJuneOutputValue(), entity.getJuneActualOutputValue()));
                    allActualVo.setJulyOutputValue(CommonUtils.addBigDecimal(allActualVo.getJulyOutputValue(), entity.getJulyActualOutputValue()));
                    allActualVo.setAugustOutputValue(CommonUtils.addBigDecimal(allActualVo.getAugustOutputValue(), entity.getAugustActualOutputValue()));
                    allActualVo.setSeptemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getSeptemberOutputValue(), entity.getSeptemberActualOutputValue()));
                    allActualVo.setOctoberOutputValue(CommonUtils.addBigDecimal(allActualVo.getOctoberOutputValue(), entity.getOctoberActualOutputValue()));
                    allActualVo.setNovemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getNovemberOutputValue(), entity.getNovemberActualOutputValue()));
                    allActualVo.setDecemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getDecemberOutputValue(), entity.getDecemberActualOutputValue()));

                }

            }else{
                twoOrgId = entity.getTwoOrgId();
                twoOrgName = entity.getTwoOrgName();
                allPlanVo = new OutputValueReportVO();
                allActualVo = new OutputValueReportVO();


                allPlanVo.setContractAmount(CommonUtils.addBigDecimal(allPlanVo.getContractAmount(), entity.getContractAmount()));
                allPlanVo.setProvisionalAmount(CommonUtils.addBigDecimal(allPlanVo.getProvisionalAmount(), entity.getProvisionalAmount()));
                allPlanVo.setBuiltArea(CommonUtils.addBigDecimal(allPlanVo.getBuiltArea(), entity.getBuiltArea()));
                allPlanVo.setThisYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getThisYearAccumulateCompletedOutputValue(), entity.getThisYearAccumulateCompletedOutputValue()));
                allPlanVo.setAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAccumulateCompletedOutputValue(), entity.getAccumulateCompletedOutputValue()));
                allPlanVo.setLastYearAccumulateCompletedOutputValue(CommonUtils.addBigDecimal(allPlanVo.getLastYearAccumulateCompletedOutputValue(), entity.getLastYearAccumulateCompletedOutputValue()));
                allPlanVo.setSurplusOutputValue(CommonUtils.addBigDecimal(allPlanVo.getSurplusOutputValue(), entity.getSurplusOutputValue()));
                allPlanVo.setYearOutputValue(CommonUtils.addBigDecimal(allPlanVo.getYearOutputValue(), entity.getYearPlanOutputValue()));
                allPlanVo.setJanuaryOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJanuaryOutputValue(), entity.getJanuaryPlanOutputValue()));
                allPlanVo.setFebruaryOutputValue(CommonUtils.addBigDecimal(allPlanVo.getFebruaryOutputValue(), entity.getFebruaryPlanOutputValue()));
                allPlanVo.setMarchOutputValue(CommonUtils.addBigDecimal(allPlanVo.getMarchOutputValue(), entity.getMarchPlanOutputValue()));
                allPlanVo.setAprilOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAprilOutputValue(), entity.getAprilPlanOutputValue()));
                allPlanVo.setMayOutputValue(CommonUtils.addBigDecimal(allPlanVo.getMayOutputValue(), entity.getMayPlanOutputValue()));
                allPlanVo.setJuneOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJuneOutputValue(), entity.getJunePlanOutputValue()));
                allPlanVo.setJulyOutputValue(CommonUtils.addBigDecimal(allPlanVo.getJulyOutputValue(), entity.getJulyPlanOutputValue()));
                allPlanVo.setAugustOutputValue(CommonUtils.addBigDecimal(allPlanVo.getAugustOutputValue(), entity.getAugustPlanOutputValue()));
                allPlanVo.setSeptemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getSeptemberOutputValue(), entity.getSeptemberPlanOutputValue()));
                allPlanVo.setOctoberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getOctoberOutputValue(), entity.getOctoberPlanOutputValue()));
                allPlanVo.setNovemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getNovemberOutputValue(), entity.getNovemberPlanOutputValue()));
                allPlanVo.setDecemberOutputValue(CommonUtils.addBigDecimal(allPlanVo.getDecemberOutputValue(), entity.getDecemberPlanOutputValue()));

                allActualVo.setContractAmount(allPlanVo.getContractAmount());
                allActualVo.setProvisionalAmount(allPlanVo.getProvisionalAmount());
                allActualVo.setBuiltArea(allPlanVo.getBuiltArea());
                allActualVo.setThisYearAccumulateCompletedOutputValue(allPlanVo.getThisYearAccumulateCompletedOutputValue());
                allActualVo.setAccumulateCompletedOutputValue(allPlanVo.getAccumulateCompletedOutputValue());
                allActualVo.setLastYearAccumulateCompletedOutputValue(allPlanVo.getLastYearAccumulateCompletedOutputValue());
                allActualVo.setSurplusOutputValue(allPlanVo.getSurplusOutputValue());
                allActualVo.setYearOutputValue(CommonUtils.addBigDecimal(allActualVo.getYearOutputValue(), entity.getYearActualOutputValue()));
                allActualVo.setJanuaryOutputValue(CommonUtils.addBigDecimal(allActualVo.getJanuaryOutputValue(), entity.getJanuaryActualOutputValue()));
                allActualVo.setFebruaryOutputValue(CommonUtils.addBigDecimal(allActualVo.getFebruaryOutputValue(), entity.getFebruaryActualOutputValue()));
                allActualVo.setMarchOutputValue(CommonUtils.addBigDecimal(allActualVo.getMarchOutputValue(), entity.getMarchActualOutputValue()));
                allActualVo.setAprilOutputValue(CommonUtils.addBigDecimal(allActualVo.getAprilOutputValue(), entity.getAprilActualOutputValue()));
                allActualVo.setMayOutputValue(CommonUtils.addBigDecimal(allActualVo.getMayOutputValue(), entity.getMayActualOutputValue()));
                allActualVo.setJuneOutputValue(CommonUtils.addBigDecimal(allActualVo.getJuneOutputValue(), entity.getJuneActualOutputValue()));
                allActualVo.setJulyOutputValue(CommonUtils.addBigDecimal(allActualVo.getJulyOutputValue(), entity.getJulyActualOutputValue()));
                allActualVo.setAugustOutputValue(CommonUtils.addBigDecimal(allActualVo.getAugustOutputValue(), entity.getAugustActualOutputValue()));
                allActualVo.setSeptemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getSeptemberOutputValue(), entity.getSeptemberActualOutputValue()));
                allActualVo.setOctoberOutputValue(CommonUtils.addBigDecimal(allActualVo.getOctoberOutputValue(), entity.getOctoberActualOutputValue()));
                allActualVo.setNovemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getNovemberOutputValue(), entity.getNovemberActualOutputValue()));
                allActualVo.setDecemberOutputValue(CommonUtils.addBigDecimal(allActualVo.getDecemberOutputValue(), entity.getDecemberActualOutputValue()));
            }

            //将数据一个项目分成两份（计划+实际）
            OutputValueReportVO vo = BeanMapper.map(entity, OutputValueReportVO.class);

            String actualStartDateString = null; // 实际开工日期
            String actualEndDateString = null; // 合同竣工日
            String planStartDateString = null; // 计划开工日期
            String planEndDateString = null; // 计划竣工日期

            DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
            if(entity.getActualStartDate()!=null){
                actualStartDateString = sdf.format(entity.getActualStartDate());
            }
            if(entity.getActualEndDate()!=null){
                actualEndDateString = sdf.format(entity.getActualEndDate());
            }
            if(entity.getPlanStartDate()!=null){
                planStartDateString = sdf.format(entity.getPlanStartDate());
            }
            if(entity.getPlanEndDate()!=null){
                planEndDateString = sdf.format(entity.getPlanEndDate());
            }
            vo.setActualStartDateString(actualStartDateString);
            vo.setActualEndDateString(actualEndDateString);
            vo.setPlanStartDateString(planStartDateString);
            vo.setPlanEndDateString(planEndDateString);
            vo.setActualStartDate(entity.getActualStartDate());
            vo.setActualEndDate(entity.getActualEndDate());
            vo.setPlanStartDate(entity.getPlanStartDate());
            vo.setPlanEndDate(entity.getPlanEndDate());
            vo.setDataType("计划");
            vo.setYearOutputValue(entity.getYearPlanOutputValue()); //年度预计/实际完成产值
            vo.setJanuaryOutputValue(entity.getJanuaryPlanOutputValue()); //1月计划/实际产值（万元）
            vo.setFebruaryOutputValue(entity.getFebruaryPlanOutputValue()); //2月计划/实际产值（万元）
            vo.setMarchOutputValue(entity.getMarchPlanOutputValue()); //3月计划/实际产值（万元）
            vo.setAprilOutputValue(entity.getAprilPlanOutputValue()); //4月计划/实际产值（万元）
            vo.setMayOutputValue(entity.getMayPlanOutputValue()); //5月计划产/实际值（万元）
            vo.setJuneOutputValue(entity.getJunePlanOutputValue()); //6月计划/实际产值（万元）
            vo.setJulyOutputValue(entity.getJulyPlanOutputValue()); //7月计划/实际产值（万元）
            vo.setAugustOutputValue(entity.getAugustPlanOutputValue()); //8月计划/实际产值（万元）
            vo.setSeptemberOutputValue(entity.getSeptemberPlanOutputValue()); //9月计划/实际产值（万元）
            vo.setOctoberOutputValue(entity.getOctoberPlanOutputValue()); //10月计划/实际产值（万元）
            vo.setNovemberOutputValue(entity.getNovemberPlanOutputValue()); //11月计划/实际产值（万元）
            vo.setDecemberOutputValue(entity.getDecemberPlanOutputValue()); //12月计划/实际产值（万元）
            vos.add(vo);
            OutputValueReportVO vo1 = BeanMapper.map(entity, OutputValueReportVO.class);
            vo1.setActualStartDateString(actualStartDateString);
            vo1.setActualEndDateString(actualEndDateString);
            vo1.setPlanStartDateString(planStartDateString);
            vo1.setPlanEndDateString(planEndDateString);
            vo1.setActualStartDate(entity.getActualStartDate());
            vo1.setActualEndDate(entity.getActualEndDate());
            vo1.setPlanStartDate(entity.getPlanStartDate());
            vo1.setPlanEndDate(entity.getPlanEndDate());
            vo1.setDataType("实际");
            vo1.setYearOutputValue(entity.getYearActualOutputValue()); //年度预计/实际完成产值
            vo1.setJanuaryOutputValue(entity.getJanuaryActualOutputValue()); //1月计划/实际产值（万元）
            vo1.setFebruaryOutputValue(entity.getFebruaryActualOutputValue()); //2月计划/实际产值（万元）
            vo1.setMarchOutputValue(entity.getMarchActualOutputValue()); //3月计划/实际产值（万元）
            vo1.setAprilOutputValue(entity.getAprilActualOutputValue()); //4月计划/实际产值（万元）
            vo1.setMayOutputValue(entity.getMayActualOutputValue()); //5月计划产/实际值（万元）
            vo1.setJuneOutputValue(entity.getJuneActualOutputValue()); //6月计划/实际产值（万元）
            vo1.setJulyOutputValue(entity.getJulyActualOutputValue()); //7月计划/实际产值（万元）
            vo1.setAugustOutputValue(entity.getAugustActualOutputValue()); //8月计划/实际产值（万元）
            vo1.setSeptemberOutputValue(entity.getSeptemberActualOutputValue()); //9月计划/实际产值（万元）
            vo1.setOctoberOutputValue(entity.getOctoberActualOutputValue()); //10月计划/实际产值（万元）
            vo1.setNovemberOutputValue(entity.getNovemberActualOutputValue()); //11月计划/实际产值（万元）
            vo1.setDecemberOutputValue(entity.getDecemberActualOutputValue()); //12月计划/实际产值（万元）
            vos.add(vo1);
            if(entitys.indexOf(entity)==entitys.size()-1){
                //最后一条
                //统计区域公司数据---
                QueryWrapper<CompanyUndertakeQuotaEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("year", year);
                wrapper.in("bill_state", 1,3);
                wrapper.eq("org_id", twoOrgId);
                List<CompanyUndertakeQuotaEntity> list = companyUndertakeQuotaService.list(wrapper);

                OutputValueReportVO undertakeQuota = new OutputValueReportVO();
                undertakeQuota.setTwoOrgId(twoOrgId);
                undertakeQuota.setTwoOrgName(twoOrgName);
                undertakeQuota.setOrgId(twoOrgId+2222);
                undertakeQuota.setOrgName("预计新承接项目");
                undertakeQuota.setProjectName("预计新承接项目");
                if(list!=null && list.size()>0){
                    CompanyUndertakeQuotaEntity en = list.get(0);
                    undertakeQuota.setYearOutputValue(en.getContractQuota());
                    undertakeQuota.setJanuaryOutputValue(en.getJanuaryContractQuota()); //1月计划/实际产值（万元）
                    undertakeQuota.setFebruaryOutputValue(en.getFebruaryContractQuota()); //2月计划/实际产值（万元）
                    undertakeQuota.setMarchOutputValue(en.getMarchContractQuota()); //3月计划/实际产值（万元）
                    undertakeQuota.setAprilOutputValue(en.getAprilContractQuota()); //4月计划/实际产值（万元）
                    undertakeQuota.setMayOutputValue(en.getMayContractQuota()); //5月计划产/实际值（万元）
                    undertakeQuota.setJuneOutputValue(en.getJuneContractQuota()); //6月计划/实际产值（万元）
                    undertakeQuota.setJulyOutputValue(en.getJulyContractQuota()); //7月计划/实际产值（万元）
                    undertakeQuota.setAugustOutputValue(en.getAugustContractQuota()); //8月计划/实际产值（万元）
                    undertakeQuota.setSeptemberOutputValue(en.getSeptemberContractQuota()); //9月计划/实际产值（万元）
                    undertakeQuota.setOctoberOutputValue(en.getOctoberContractQuota()); //10月计划/实际产值（万元）
                    undertakeQuota.setNovemberOutputValue(en.getNovemberContractQuota()); //11月计划/实际产值（万元）
                    undertakeQuota.setDecemberOutputValue(en.getDecemberContractQuota()); //12月计划/实际产值（万元）
                }
                vos.add(undertakeQuota);
                //统计合计数据
                allPlanVo.setTwoOrgId(twoOrgId);
                allPlanVo.setTwoOrgName(twoOrgName);
                allPlanVo.setOrgId(twoOrgId+1111);
                allPlanVo.setOrgName("小计");
                allPlanVo.setProjectName("小计");
                allPlanVo.setDataType("计划");
                vos.add(allPlanVo);
                allActualVo.setTwoOrgId(twoOrgId);
                allActualVo.setTwoOrgName(twoOrgName);
                allActualVo.setOrgId(twoOrgId+1111);
                allActualVo.setOrgName("小计");
                allActualVo.setProjectName("小计");
                allActualVo.setDataType("实际");
                vos.add(allActualVo);
            }
        }
        return vos;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletRequest request, HttpServletResponse response) throws IOException {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("twoOrgName");
        fuzzyFields.add("projectStatus");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = sessionManager.getUserContext();
        Calendar cal = Calendar.getInstance();  // 获取当前时间的Calendar实例
        String year = String.valueOf(cal.get(Calendar.YEAR));
        if(param.getParams().get("year")!=null){
            year = param.getParams().get("year").getValue().toString();
        }else{
            param.getParams().put("year", new Parameter(QueryParam.EQ, year));
        }
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        param.getOrderMap().put("twoOrgSequence",QueryParam.ASC);
        param.getOrderMap().put("twoOrgId",QueryParam.DESC);
        param.getOrderMap().put("orgId",QueryParam.DESC);
        param.getOrderMap().put("projectNum",QueryParam.ASC);
        param.getOrderMap().put("createTime",QueryParam.DESC);
        List<OutputValueReportEntity> entitys = service.queryList(param);

        List<OutputValueReportVO> vos = this.dealResultVOList(entitys, year);
        JSONObject margeData = this.getMargeData(vos);
        ExcelFillCellMerge mergePrevCol = new ExcelFillCellMerge();
        List<Integer> totalPlanIndex = (List<Integer>) margeData.get("totalPlanIndex");
        Map<String, Integer> colIndexMap = new HashMap<>();
        colIndexMap.put("projectNumColMarge", 0);
        colIndexMap.put("twoOrgNameColMarge", 1);
        colIndexMap.put("orgNameColMarge", 2);
        colIndexMap.put("projectNameColMarge", 3);
        colIndexMap.put("actualStartDateColMarge", 4);
        colIndexMap.put("actualEndDateColMarge", 5);
        colIndexMap.put("planEndDateColMarge", 6);
        colIndexMap.put("contractAmountColMarge", 7);
        colIndexMap.put("provisionalAmountColMarge", 8);
        colIndexMap.put("builtAreaColMarge", 9);
        colIndexMap.put("lastYearAccumulateCompletedOutputValueColMarge", 10);
        colIndexMap.put("accumulateCompletedOutputValueColMarge", 11);
        colIndexMap.put("surplusOutputValueColMarge", 12);
        colIndexMap.put("projectStatusColMarge", 13);
        colIndexMap.put("thisYearProjectColMarge", 14);
        for(String key : margeData.keySet()){
            if(key.contains("RowMarge")){
                //行中合并列
            }else if(key.contains("ColMarge")){
                if("orgNameColMarge".equals(key)){
                    if(margeData.get("orgNameRowMarge")!=null){
                        List<JSONObject> orgNameRowMarge = (List<JSONObject>) margeData.get("orgNameRowMarge");
                        Map<String, Integer> margeRowMap = new HashMap<>();
                        for(JSONObject data : orgNameRowMarge){
                            Integer dataMargeIndex = data.getInteger("dataMargeIndex");
                            Integer dataMargeRange = data.getInteger("dataMargeRange");
                            margeRowMap.put("orgName"+dataMargeIndex, dataMargeRange);
                        }
                        List<JSONObject> colMarge = (List<JSONObject>) margeData.get(key);
                        Map<String, Integer> margeColMap = new HashMap<>();
                        for(JSONObject data : colMarge){
                            Integer dataMargeIndex = data.getInteger("dataMargeIndex");
                            Integer dataMargeRange = data.getInteger("dataMargeRange");
                            if(margeRowMap.get("orgName"+dataMargeIndex)!=null){
                                if(dataMargeRange>0 && margeRowMap.get("orgName"+dataMargeIndex)>0){
                                    mergePrevCol.addAll(dataMargeIndex+3, 2, margeRowMap.get("orgName"+dataMargeIndex), dataMargeRange);
                                }else if(dataMargeRange<=0 && margeRowMap.get("orgName"+dataMargeIndex)>0){
                                    mergePrevCol.addRow(dataMargeIndex+3, 2, margeRowMap.get("orgName"+dataMargeIndex));
                                }else if(dataMargeRange>0 && margeRowMap.get("orgName"+dataMargeIndex)<=0){
                                    mergePrevCol.addCol(dataMargeIndex+3, 2, dataMargeRange);
                                }
                            }else{
                                mergePrevCol.addCol(dataMargeIndex+3,2,dataMargeRange);
                            }
                        }

                    }else{
                        Integer colIndex = colIndexMap.get(key);
                        List<JSONObject> colMarge = (List<JSONObject>) margeData.get(key);
                        for(JSONObject data : colMarge){
                            Integer dataMargeIndex = data.getInteger("dataMargeIndex");
                            Integer dataMargeRange = data.getInteger("dataMargeRange");
                            mergePrevCol.addCol(dataMargeIndex+3,colIndex,dataMargeRange);//第6行，从第6列开始合并3列
                        }
                    }
                }else{
                    Integer colIndex = colIndexMap.get(key);
                    List<JSONObject> colMarge = (List<JSONObject>) margeData.get(key);
                    for(JSONObject data : colMarge){
                        Integer dataMargeIndex = data.getInteger("dataMargeIndex");
                        Integer dataMargeRange = data.getInteger("dataMargeRange");
                        if(!(totalPlanIndex.contains(dataMargeIndex) && (colIndex==2 || colIndex==3 || colIndex==4 || colIndex==5 || colIndex==6))){
                            //审批小计去除列
                            mergePrevCol.addCol(dataMargeIndex+3,colIndex,dataMargeRange);//第6行，从第6列开始合并3列
                        }
                    }
                }

            }
        }

        EasyExcelUtil excelExport = new EasyExcelUtil();
        List<String> heardKey = Arrays.asList("projectNum","twoOrgName","orgName","projectName","actualStartDateString","actualEndDateString",
                "planEndDateString","contractAmount","provisionalAmount","builtArea","lastYearAccumulateCompletedOutputValue",
                "accumulateCompletedOutputValue","surplusOutputValue","projectStatus","thisYearProject","dataType",
                "yearOutputValue","januaryOutputValue","februaryOutputValue","marchOutputValue","aprilOutputValue","mayOutputValue",
                "juneOutputValue","julyOutputValue","augustOutputValue","septemberOutputValue","octoberOutputValue",
                "novemberOutputValue","decemberOutputValue");
        List<List<String>> heardListData = ListUtils.newArrayList();
        List<String> heardKey1 = Arrays.asList("序号","序号");
        List<String> heardKey2 = Arrays.asList("区域","区域");
        List<String> heardKey3 = Arrays.asList("分（子）公司名称","分（子）公司名称");
        List<String> heardKey4 = Arrays.asList("工厂/工程名称（全称）","工厂/工程名称（全称）");
        List<String> heardKey5 = Arrays.asList("实际开工","实际开工");
        List<String> heardKey6 = Arrays.asList("合同竣工","合同竣工");
        List<String> heardKey7 = Arrays.asList("计划竣工","计划竣工");
        List<String> heardKey8 = Arrays.asList("合同额","合同额（万元）");
        List<String> heardKey9 = Arrays.asList("暂列金","暂列金（万元）");
        List<String> heardKey10 = Arrays.asList("建筑规模","建筑规模");

        Integer lastYear = Integer.valueOf(year) - 1;
        String t = lastYear + "年全年完成产值";
        List<String> heardKey11 = Arrays.asList(t,t);
        String a = "截止"+lastYear+"年年末项目完成产值";
        List<String> heardKey12 = Arrays.asList(a,a);
        String s = "截止"+lastYear+"年年末项目剩余产值";
        List<String> heardKey13 = Arrays.asList(s,s);
        List<String> heardKey14 = Arrays.asList("状态","状态");
        List<String> heardKey15 = Arrays.asList("是否本年新项目","是否本年新项目");
        List<String> heardKey16 = Arrays.asList("类型","类型");

        List<String> heardKey17 = Arrays.asList("年度预计完成产值","年度预计完成产值");
        List<String> heardKey18 = Arrays.asList("年度月度计划产值","1月");
        List<String> heardKey19 = Arrays.asList("年度月度计划产值","2月");
        List<String> heardKey20 = Arrays.asList("年度月度计划产值","3月");
        List<String> heardKey21 = Arrays.asList("年度月度计划产值","4月");
        List<String> heardKey22 = Arrays.asList("年度月度计划产值","5月");
        List<String> heardKey23 = Arrays.asList("年度月度计划产值","6月");
        List<String> heardKey24 = Arrays.asList("年度月度计划产值","7月");
        List<String> heardKey25 = Arrays.asList("年度月度计划产值","8月");
        List<String> heardKey26 = Arrays.asList("年度月度计划产值","9月");
        List<String> heardKey27 = Arrays.asList("年度月度计划产值","10月");
        List<String> heardKey28 = Arrays.asList("年度月度计划产值","11月");
        List<String> heardKey29 = Arrays.asList("年度月度计划产值","12月");
        heardListData.add(heardKey1);
        heardListData.add(heardKey2);
        heardListData.add(heardKey3);
        heardListData.add(heardKey4);
        heardListData.add(heardKey5);
        heardListData.add(heardKey6);
        heardListData.add(heardKey7);
        heardListData.add(heardKey8);
        heardListData.add(heardKey9);
        heardListData.add(heardKey10);
        heardListData.add(heardKey11);
        heardListData.add(heardKey12);
        heardListData.add(heardKey13);
        heardListData.add(heardKey14);
        heardListData.add(heardKey15);
        heardListData.add(heardKey16);
        heardListData.add(heardKey17);
        heardListData.add(heardKey18);
        heardListData.add(heardKey19);
        heardListData.add(heardKey20);
        heardListData.add(heardKey21);
        heardListData.add(heardKey22);
        heardListData.add(heardKey23);
        heardListData.add(heardKey24);
        heardListData.add(heardKey25);
        heardListData.add(heardKey26);
        heardListData.add(heardKey27);
        heardListData.add(heardKey28);
        heardListData.add(heardKey29);

        List<String> fieldFormat = Arrays.asList("string","string","string","string","yyyy-MM-dd","yyyy-MM-dd",
                "yyyy-MM-dd","fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers",
                "fourDecimalNumbers","fourDecimalNumbers","string","string","string",
                "fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers",
                "fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers","fourDecimalNumbers",
                "fourDecimalNumbers","fourDecimalNumbers");

        excelExport.setHeardListData(heardListData);
        excelExport.setData(BeanMapper.mapList(vos, JSONObject.class));
        if(ListUtil.isNotEmpty(heardKey)) {
            excelExport.setHeardKey(heardKey);
            excelExport.setFontSize(12);
            excelExport.setFieldFormat(fieldFormat);
            excelExport.setSheetName("产值分析表");

            excelExport.setMergePrevCol(mergePrevCol);
            excelExport.exportExport(request, response);
        }
    }


    /**
     * @Description 刷新当前年份数据
     */
    @RequestMapping(value = "/refreshData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> refreshData(@RequestParam(required = false) String year) {
        service.refreshData(year);
        return CommonResponse.success("刷新数据成功");
    }
}
