package com.ejianc.business.outputValue.controller;

import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * 工厂月度实际产值
 *
 */
@RestController
@RequestMapping("/pcMonthActualOutputValueRecord/")
public class PcMonthActualOutputValueRecordController {

	@Autowired
	private IPcMonthActualOutputValueRecordService recordService;
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PcMonthActualOutputValueRecordVO> queryDetail(Long id) {
        PcMonthActualOutputValueRecordEntity entity = recordService.selectById(id);
        PcMonthActualOutputValueRecordVO vo = BeanMapper.map(entity, PcMonthActualOutputValueRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
