package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaRecordEntity;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaChangeService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaRecordService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaService;
import com.ejianc.business.outputValue.vo.ProjectPcYearBusinessQuotaChangeVO;
import com.ejianc.business.outputValue.vo.ProjectPcYearBusinessQuotaRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 项目/工厂年度经营指标（产值）
 *
 */
@RestController
@RequestMapping("/projectPcYearBusinessQuotaChange/")
public class ProjectPcYearBusinessQuotaChangeController {

	@Autowired
	private IProjectPcYearBusinessQuotaService projectPcYearBusinessQuotaService;
	@Autowired
	private IProjectPcYearBusinessQuotaChangeService changeService;
	@Autowired
	private IProjectPcYearBusinessQuotaRecordService recordService;

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectPcYearBusinessQuotaChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("twoOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("year");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(param.getParams().get("dataId")==null){
        	throw new BusinessException("缺少公司经营指标id");
        }
        IPage<ProjectPcYearBusinessQuotaChangeEntity> page = changeService.queryPage(param,false);
        IPage<ProjectPcYearBusinessQuotaChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPcYearBusinessQuotaChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByDataId")
    public CommonResponse<ProjectPcYearBusinessQuotaChangeVO> queryDetailByDataId(@RequestParam(value = "dataId") Long dataId) {
        ProjectPcYearBusinessQuotaEntity projectEntity = projectPcYearBusinessQuotaService.selectById(dataId);
        ProjectPcYearBusinessQuotaChangeVO changeVO = BeanMapper.map(projectEntity, ProjectPcYearBusinessQuotaChangeVO.class);
        changeVO.setDataId(dataId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setUpdateUserCode(null);
        return CommonResponse.success("查询详情成功！", changeVO);
    	
    }
    
    /**
     * 查询变更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetail")
    public CommonResponse<ProjectPcYearBusinessQuotaChangeVO> queryDetail(@RequestParam(value = "id") Long id) {
        ProjectPcYearBusinessQuotaChangeEntity entity = changeService.selectById(id);
        ProjectPcYearBusinessQuotaChangeVO vo = BeanMapper.map(entity, ProjectPcYearBusinessQuotaChangeVO.class);

        //当前单据变更过则显示变更记录
//        QueryWrapper<ProjectPcYearBusinessQuotaRecordEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("dr", 0);
//        queryWrapper.eq("data_id", vo.getDataId());
//        List<ProjectPcYearBusinessQuotaRecordEntity> records = recordService.list(queryWrapper);
//        if(records!=null&&records.size()>0){
//            vo.setRecordList(BeanMapper.mapList(records, ProjectPcYearBusinessQuotaRecordVO.class));
//        }
        return CommonResponse.success("查询详情成功！", vo);
    	
    }

    /**
     * 项目申请保存/更新
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "saveChange")
    public CommonResponse<ProjectPcYearBusinessQuotaChangeVO> saveChange(@RequestBody ProjectPcYearBusinessQuotaChangeVO vo) {
    	return changeService.saveChange(vo);
    	
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectPcYearBusinessQuotaChangeVO> vos) {
        return changeService.delete(vos);
    }

}
