package com.ejianc.business.outputValue.controller;

import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaRecordEntity;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaRecordService;
import com.ejianc.business.outputValue.vo.ProjectPcYearBusinessQuotaRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * 项目/工厂年度经营指标（产值）
 *
 */
@RestController
@RequestMapping("/projectPcYearBusinessQuotaRecord/")
public class ProjectPcYearBusinessQuotaRecordController {

	@Autowired
	private IProjectPcYearBusinessQuotaRecordService recordService;
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectPcYearBusinessQuotaRecordVO> queryDetail(Long id) {
        ProjectPcYearBusinessQuotaRecordEntity entity = recordService.selectById(id);
        ProjectPcYearBusinessQuotaRecordVO vo = BeanMapper.map(entity, ProjectPcYearBusinessQuotaRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
