package com.ejianc.business.outputValue.controller;

import com.ejianc.business.outputValue.bean.ProjectSupplementRecordEntity;
import com.ejianc.business.outputValue.service.IProjectSupplementRecordService;
import com.ejianc.business.outputValue.vo.ProjectSupplementRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * 项目信息补充与维护
 *
 */
@RestController
@RequestMapping("/projectSupplementRecord/")
public class ProjectSupplementRecordController {

	@Autowired
	private IProjectSupplementRecordService recordService;
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectSupplementRecordVO> queryDetail(Long id) {
        ProjectSupplementRecordEntity entity = recordService.selectById(id);
        ProjectSupplementRecordVO vo = BeanMapper.map(entity, ProjectSupplementRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
