package com.ejianc.business.outputValue.mapper;

import com.ejianc.business.outputValue.bean.*;
import com.ejianc.business.outputValue.vo.OutputValueReportVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 产值分析表（统计表）
 * 
 * @author generator
 * 
 */
@Mapper
public interface OutputValueIndexMapper extends BaseCrudMapper<OutputValueReportEntity> {

    public CompanyBusinessQuotaEntity queryCompanySum(@Param("year") String year);
    public ProjectPcYearBusinessQuotaEntity queryPlanSum(@Param("year") String year,@Param("pcFactory") Integer pcFactory);
    public CompanyUndertakeQuotaEntity queryCompanyUndertakeSum(@Param("year") String year);
    public Integer queryProjectNum(@Param("year") String year,@Param("projectStatus") String projectStatus);
    public OutputValueReportEntity queryReportSum(@Param("year") String year,@Param("projectStatus") String projectStatus,@Param("thisYearProject") String thisYearProject);
    public List<OutputValueReportEntity> queryReportOutputValueTop10(@Param("year") String year);

    public ProjectSupplementEntity queryPersonNum(@Param("year") String year);

}
