package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyMonthEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthProjectDetailEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.service.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("companyMonth") 
public class CompanyMonthBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ICompanyMonthService companyMonthService;
	@Autowired
	private ICompanyMonthProjectDetailService detailService;
	@Autowired
	private IPcMonthActualOutputValueService pcMonthService;
	@Autowired
	private IProjectMonthActualOutputValueService projectMonthService;
	@Autowired
	private ICompanyBusinessQuotaService companyBusinessQuotaService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		CompanyMonthEntity companyMonthEntity = companyMonthService.selectById(billId);
		//TODO
		QueryWrapper<CompanyMonthProjectDetailEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("company_month_id", billId);
		List<CompanyMonthProjectDetailEntity> list = detailService.list(wrapper);
		if(list!=null && list.size()>0){
			List<Long> projectIds = new ArrayList<>();
			List<Long> pcIds = new ArrayList<>();
			Map<Long, CompanyMonthProjectDetailEntity> projectMap = new HashMap<>();
			Map<Long, CompanyMonthProjectDetailEntity> pcMap = new HashMap<>();
			for(CompanyMonthProjectDetailEntity detailEntity : list){
				if(detailEntity.getPcFactory()!=null && detailEntity.getPcFactory()){
					//工厂
					if(detailEntity.getThisMonthActualOutputValueAdjust()!=null){
						pcIds.add(detailEntity.getProjectActualId());
						pcMap.put(detailEntity.getProjectActualId(), detailEntity);
					}
				}else{
					//项目
					if(detailEntity.getThisMonthActualOutputValueAdjust()!=null || detailEntity.getThisMonthConfirmedOutputValueAdjust()!=null){
						projectIds.add(detailEntity.getProjectActualId());
						projectMap.put(detailEntity.getProjectActualId(), detailEntity);
					}
				}
			}
			if(projectIds!=null && projectIds.size()>0){
				List<ProjectMonthActualOutputValueEntity> projectList = (List<ProjectMonthActualOutputValueEntity>) projectMonthService.listByIds(projectIds);
				for(ProjectMonthActualOutputValueEntity entity : projectList){
					entity.setThisMonthActualOutputValue(projectMap.get(entity.getId()).getThisMonthActualOutputValueAdjust());
					entity.setThisMonthConfirmedOutputValue(projectMap.get(entity.getId()).getThisMonthConfirmedOutputValueAdjust());
				}
				projectMonthService.saveOrUpdateBatch(projectList, projectList.size(), false);
			}
			if(pcIds!=null && pcIds.size()>0){
				List<PcMonthActualOutputValueEntity> pcList = (List<PcMonthActualOutputValueEntity>) pcMonthService.listByIds(pcIds);
				for(PcMonthActualOutputValueEntity entity : pcList){
					entity.setThisMonthCompletedTotalOutputValue(projectMap.get(entity.getId()).getThisMonthActualOutputValueAdjust());
				}
				pcMonthService.saveOrUpdateBatch(pcList, pcList.size(), false);
			}
			//更新公司经营指标---先判断该组织是否存在单据，存在则修改
			companyBusinessQuotaService.updateProjectPcInfo(companyMonthEntity.getOrgId(), companyMonthEntity.getYear());
		}
		//
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
