package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyMonthChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthRecordEntity;
import com.ejianc.business.outputValue.mapper.CompanyMonthChangeMapper;
import com.ejianc.business.outputValue.service.ICompanyMonthChangeService;
import com.ejianc.business.outputValue.service.ICompanyMonthRecordService;
import com.ejianc.business.outputValue.service.ICompanyMonthService;
import com.ejianc.business.outputValue.vo.CompanyMonthChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 公司月度产值录入变更
 * 
 * @author generator
 * 
 */
@Service("companyMonthChangeService")
public class CompanyMonthChangeServiceImpl extends BaseServiceImpl<CompanyMonthChangeMapper, CompanyMonthChangeEntity> implements ICompanyMonthChangeService{

    @Autowired
    private ICompanyMonthService companyMonthService;
    @Autowired
    private ICompanyMonthRecordService recordService;
    @Override
    public CommonResponse<CompanyMonthChangeVO> saveChange(CompanyMonthChangeVO vo) {
        CompanyMonthChangeEntity entity = BeanMapper.map(vo, CompanyMonthChangeEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<CompanyMonthChangeEntity> queryWrapper = new QueryWrapper<CompanyMonthChangeEntity>();
        queryWrapper.eq("company_month_id", vo.getCompanyMonthId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 0,4);
        if(vo.getId()!=null){
            queryWrapper.ne("id", vo.getId());
        }
        List<CompanyMonthChangeEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //检验该单据是否是当前公司最新的单据，若是则允许变更，否则不允许；
        QueryWrapper<CompanyMonthEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("org_id", vo.getOrgId());
        wrapper.eq("dr", 0);
        wrapper.orderByDesc("year");
        List<CompanyMonthEntity> companyMonthList = companyMonthService.list(wrapper);
        if(companyMonthList!=null && companyMonthList.size()>0){
            if(!vo.getYear().equals(companyMonthList.get(0).getYear())){
                throw new BusinessException("只能变更该公司最新的数据");
            }
        }

        this.saveOrUpdate(entity, false);

        CompanyMonthChangeVO backVO = BeanMapper.map(entity, CompanyMonthChangeVO.class);
        backVO.setRecordList(vo.getRecordList());
        //查询当前合同信息，将状态改为变更中
        CompanyMonthEntity companyMonthEntity = companyMonthService.selectById(backVO.getCompanyMonthId());
        companyMonthEntity.setChangeState("2");//状态改为变更中
        companyMonthEntity.setChangeId(backVO.getId());
        companyMonthService.saveOrUpdate(companyMonthEntity, false);
        return CommonResponse.success("保存或修改单据成功！",backVO);
    }
    @Override
    public CommonResponse<String> delete(List<CompanyMonthChangeVO> vos) {
        for(CompanyMonthChangeVO vo : vos){
            CompanyMonthChangeEntity entity = this.getById(vo.getId());
            CompanyMonthEntity companyMonthEntity = companyMonthService.selectById(entity.getCompanyMonthId());
            QueryWrapper<CompanyMonthRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("company_month_id", companyMonthEntity.getId());
            List<CompanyMonthRecordEntity> records = recordService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                companyMonthEntity.setChangeState("3");//状态改为已变更
            }else{
                companyMonthEntity.setChangeState("1");//状态改为未变更
            }
            companyMonthEntity.setChangeId(null);
            companyMonthService.saveOrUpdate(companyMonthEntity, false);
        }
        this.removeByIds(vos.stream().map(CompanyMonthChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
