package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaEntity;
import com.ejianc.business.outputValue.bean.CompanyUndertakeQuotaRecordEntity;
import com.ejianc.business.outputValue.mapper.CompanyUndertakeQuotaChangeMapper;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaChangeService;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaRecordService;
import com.ejianc.business.outputValue.service.ICompanyUndertakeQuotaService;
import com.ejianc.business.outputValue.vo.CompanyUndertakeQuotaChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 公司新承接项目指标
 * 
 * @author generator
 * 
 */
@Service("companyUndertakeQuotaChangeService")
public class CompanyUndertakeQuotaChangeServiceImpl extends BaseServiceImpl<CompanyUndertakeQuotaChangeMapper, CompanyUndertakeQuotaChangeEntity> implements ICompanyUndertakeQuotaChangeService {

    @Autowired
    private ICompanyUndertakeQuotaService companyUndertakeQuotaService;
    @Autowired
    private ICompanyUndertakeQuotaRecordService recordService;
    @Override
    public CommonResponse<CompanyUndertakeQuotaChangeVO> saveChange(CompanyUndertakeQuotaChangeVO saveorUpdateVO) {
        CompanyUndertakeQuotaChangeEntity entity = BeanMapper.map(saveorUpdateVO, CompanyUndertakeQuotaChangeEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<CompanyUndertakeQuotaChangeEntity> queryWrapper = new QueryWrapper<CompanyUndertakeQuotaChangeEntity>();
        queryWrapper.eq("data_id", saveorUpdateVO.getDataId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 0,4);
        if(saveorUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<CompanyUndertakeQuotaChangeEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //检验该单据是否是当前公司最新的单据，若是则允许变更，否则不允许；
        QueryWrapper<CompanyUndertakeQuotaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("org_id", saveorUpdateVO.getOrgId());
        wrapper.eq("dr", 0);
        wrapper.orderByDesc("year");
        List<CompanyUndertakeQuotaEntity> companyUndertakeQuotaList = companyUndertakeQuotaService.list(wrapper);
        if(companyUndertakeQuotaList!=null && companyUndertakeQuotaList.size()>0){
            if(!saveorUpdateVO.getYear().equals(companyUndertakeQuotaList.get(0).getYear())){
                throw new BusinessException("只能变更该公司最新的数据");
            }
        }

        this.saveOrUpdate(entity, false);
        CompanyUndertakeQuotaChangeVO vo = BeanMapper.map(entity, CompanyUndertakeQuotaChangeVO.class);
        vo.setRecordList(saveorUpdateVO.getRecordList());
        //查询当前合同信息，将状态改为变更中
        CompanyUndertakeQuotaEntity companyUndertakeQuotaEntity = companyUndertakeQuotaService.selectById(vo.getDataId());
        companyUndertakeQuotaEntity.setChangeState("2");//状态改为变更中
        companyUndertakeQuotaEntity.setChangeId(vo.getId());
        companyUndertakeQuotaService.saveOrUpdate(companyUndertakeQuotaEntity, false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<CompanyUndertakeQuotaChangeVO> vos) {
        for(CompanyUndertakeQuotaChangeVO vo : vos){
            CompanyUndertakeQuotaChangeEntity entity = this.getById(vo.getId());
            CompanyUndertakeQuotaEntity companyUndertakeQuotaEntity = companyUndertakeQuotaService.selectById(entity.getDataId());
            QueryWrapper<CompanyUndertakeQuotaRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("data_id", companyUndertakeQuotaEntity.getId());
            List<CompanyUndertakeQuotaRecordEntity> records = recordService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                companyUndertakeQuotaEntity.setChangeState("3");//状态改为已变更
            }else{
                companyUndertakeQuotaEntity.setChangeState("1");//状态改为未变更
            }
            companyUndertakeQuotaEntity.setChangeId(null);
            companyUndertakeQuotaService.saveOrUpdate(companyUndertakeQuotaEntity, false);
        }
        this.removeByIds(vos.stream().map(CompanyUndertakeQuotaChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
