package com.ejianc.business.outputValue.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.material.utils.ComputeUtil;
import com.ejianc.business.outputValue.bean.*;
import com.ejianc.business.outputValue.mapper.OutputValueIndexMapper;
import com.ejianc.business.outputValue.mapper.PcMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectPcYearBusinessQuotaMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IOutputValueIndexService;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectPcYearBusinessQuotaVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;

/**
 * 产值分析表（统计表）
 *
 * @author generator
 *
 */
@Service("outputValueIndexService")
public class OutputValueIndexServiceImpl implements IOutputValueIndexService {

    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private OutputValueIndexMapper mapper;
    @Autowired
    private PcMonthActualOutputValueMapper pcMonthActualOutputValueMapper;
    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;
    @Autowired
    private ProjectPcYearBusinessQuotaMapper projectPcYearBusinessQuotaMapper;
    @Autowired
    private ICompanyBusinessQuotaService companyBusinessQuotaService;

    @Override
    public JSONObject queryData() {
        JSONObject result = new JSONObject();
        LocalDate today = LocalDate.now();
        String year =  String.valueOf(today.getYear()); // 今年
        //查询【公司经营指标】单据数据
        /**
         * 1、页面【年度营收指标（亿元）】--【本年下达的营业收入指标(亿元)】合计
         private BigDecimal thisYearRevenueQuota; // 本年下达的营业收入指标(亿元)
         * 2、页面【年度总产值计划指标（亿元）】--单据【总计划完成产值(亿元)】合计
         private BigDecimal thisYearPlanTotalOutputValue; // 本年计划产值-总计划完成产值(亿元)
         * 6、页面【年度完成总产值（亿元）】--单据【总完成产值(亿元)】合计（理论上来说应该查询工厂/项目每月产值的合计的，但是这两个数据最后会汇总到【公司经营指标】中，故直接取公司经营指标中的本年【总完成产值】合计）
         private BigDecimal thisYearCompleteTotalOutputValue; // 本年完成产值-总完成产值(亿元)
         * 8、页面【年度项目完成产值（亿元）】--单据【项目完成产值(亿元)】合计（理论上来说应该查询项目每月产值的合计的，但是这数据最后会汇总到【公司经营指标】中，故直接取公司经营指标中的本年【项目完成产值(亿元)】合计）
         private BigDecimal thisYearCompleteProjectOutputValue; // 本年完成产值-项目完成产值(亿元)
         * 9、页面【年度工厂完成产值（亿元）】--单据【PC工厂完成产值(亿元)】合计（理论上来说应该查询PC工厂每月产值的合计的，但是这数据最后会汇总到【公司经营指标】中，故直接取公司经营指标中的本年【PC工厂完成产值(亿元)】合计）
         private BigDecimal thisYearCompletePcOutputValue; // 本年完成产值-PC工厂完成产值(亿元)
         **/
        CompanyBusinessQuotaEntity sumAllCompany = mapper.queryCompanySum(year);
        BigDecimal thisYearRevenueQuota = sumAllCompany!=null?sumAllCompany.getThisYearRevenueQuota():new BigDecimal(0); // 本年下达的营业收入指标(亿元)
        BigDecimal thisYearPlanTotalOutputValue = sumAllCompany!=null?sumAllCompany.getThisYearPlanTotalOutputValue():new BigDecimal(0); // 本年计划产值-总计划完成产值(亿元)
        BigDecimal thisYearCompleteTotalOutputValue = sumAllCompany!=null?sumAllCompany.getThisYearCompleteTotalOutputValue():new BigDecimal(0); // 本年完成产值-总完成产值(亿元)
        BigDecimal thisYearCompleteProjectOutputValue = sumAllCompany!=null?sumAllCompany.getThisYearCompleteProjectOutputValue():new BigDecimal(0); // 本年完成产值-项目完成产值(亿元)
        BigDecimal thisYearCompletePcOutputValue = sumAllCompany!=null?sumAllCompany.getThisYearCompletePcOutputValue():new BigDecimal(0); // 本年完成产值-PC工厂完成产值(亿元)
        result.put("thisYearRevenueQuota", thisYearRevenueQuota);//年度营收指标（亿元）
        result.put("thisYearPlanTotalOutputValue", thisYearPlanTotalOutputValue);//年度总产值计划指标（亿元）
        result.put("thisYearCompleteTotalOutputValue", thisYearCompleteTotalOutputValue);//年度完成总产值（亿元）
        result.put("thisYearCompleteProjectOutputValue", thisYearCompleteProjectOutputValue);//年度项目完成产值（亿元）
        result.put("thisYearCompletePcOutputValue", thisYearCompletePcOutputValue);//年度工厂完成产值（亿元）
        //查询【项目/工厂年度经营指标】单据数据
        /**
         * 3、页面【年度项目产值计划（亿元）】--单据是项目的【年度计划产值（万元）】合计
         * 4、页面【年度PC厂产值计划（亿元）】--单据是PC厂的【年度计划产值（万元）】合计
         **/
        ProjectPcYearBusinessQuotaEntity planProjectAll = mapper.queryPlanSum(year, 0);
        BigDecimal projectYearPlanOutputValue = planProjectAll!=null?planProjectAll.getYearPlanOutputValue():new BigDecimal(0); // 年度计划产值（万元）
        projectYearPlanOutputValue = CommonUtils.parseDivide4(projectYearPlanOutputValue, 4);//万元转亿元
        result.put("projectYearPlanOutputValue", projectYearPlanOutputValue);//年度项目产值计划（亿元）
        ProjectPcYearBusinessQuotaEntity planPcAll = mapper.queryPlanSum(year, 1);
        BigDecimal pcYearPlanOutputValue = planPcAll!=null?planPcAll.getYearPlanOutputValue():new BigDecimal(0); // 年度计划产值（万元）
        pcYearPlanOutputValue = CommonUtils.parseDivide4(pcYearPlanOutputValue, 4);//万元转亿元
        result.put("pcYearPlanOutputValue", pcYearPlanOutputValue);//年度PC厂产值计划（亿元）

        //查询【公司新承接项目指标】单据数据
        /**
         * 5、页面【年度新承接项目产值计划（亿元）】--【合同指标（万元）】合计
         **/
        CompanyUndertakeQuotaEntity companyUndertakeSum = mapper.queryCompanyUndertakeSum(year);
        BigDecimal contractQuota = companyUndertakeSum!=null?companyUndertakeSum.getContractQuota():new BigDecimal(0);
        contractQuota = CommonUtils.parseDivide4(contractQuota, 4);//万元转亿元
        result.put("contractQuota", contractQuota);//年度新承接项目产值计划（亿元）

        //查询【项目】单据数据
        /**
         * 7、页面【年度施工项目个数】--取自产值报表中项目状态为在施的项目个数
         **/
        Integer buildingProjectNum = mapper.queryProjectNum(year, "在施");
        result.put("buildingProjectNum", buildingProjectNum);//年度施工项目个数

        //查询【项目】单据数据
        /**
         * 10、页面【年度在施项目合同额（亿元）】--取自产值报表中项目状态为在施的项目档案中的【合同额】合计
         private BigDecimal contractAmount; // 合同额（万元）
         * 11、页面【年度在施项目合同余额（亿元）】--取自产值报表中项目状态为在施的项目(截至上年项目剩余产值-本年完成产值)合计(取自产值报表中项目状态为在施的项目剩余产值合计)
         private BigDecimal thisYearAccumulateCompletedOutputValue; // 本年完成产值(万元)
         private BigDecimal surplusOutputValue; // 截至上年项目剩余产值(万元)
         **/
        OutputValueReportEntity reportSum = mapper.queryReportSum(year, "在施", null);
        BigDecimal contractAmount = reportSum!=null?reportSum.getContractAmount():new BigDecimal(0);
        contractAmount = CommonUtils.parseDivide4(contractAmount, 4);//万元转亿元
        result.put("contractAmount", contractAmount);//年度在施项目合同额（亿元）
        BigDecimal thisYearAccumulateCompletedOutputValue = reportSum!=null?reportSum.getThisYearAccumulateCompletedOutputValue():new BigDecimal(0);
        BigDecimal surplusOutputValue = reportSum!=null?reportSum.getSurplusOutputValue():new BigDecimal(0);
        BigDecimal contractBalance = CommonUtils.subtractBigDecimal(surplusOutputValue, thisYearAccumulateCompletedOutputValue);
        contractBalance = CommonUtils.parseDivide4(contractBalance, 4);//万元转亿元
        result.put("contractBalance", contractBalance);//年度在施项目合同余额（亿元）
        //仪表盘
        /**
         * 12、页面【年度产值仪表盘】--年度完成总产值/年度营收指标的占比
         * 13、页面【年在施项目合同产值完成率】--当年实际完成产值/ (当年新签合同额*20%+去年新签合同额*50%+前年新签合同额*30%)*100%---(当前，根据项目补充信息单据的创建时间来判断)
         **/
        BigDecimal yearValueProportion = ComputeUtil.bigDecimalPercent(thisYearCompleteTotalOutputValue, thisYearRevenueQuota, 2);
        result.put("yearValueProportion", yearValueProportion);//【年度产值仪表盘】--年度完成总产值/年度营收指标的占比

        OutputValueReportEntity nowYearReportSum = mapper.queryReportSum(year, null, "是");
        BigDecimal nowYearContractAmount = nowYearReportSum!=null?nowYearReportSum.getContractAmount():new BigDecimal(0);
        nowYearContractAmount = nowYearContractAmount.multiply(new BigDecimal(0.2));

        Integer lastYear = today.getYear() - 1; // 去年
        OutputValueReportEntity lastYearReportSum = mapper.queryReportSum(String.valueOf(lastYear), null, "是");
        BigDecimal lastYearContractAmount = lastYearReportSum!=null?lastYearReportSum.getContractAmount():new BigDecimal(0);
        lastYearContractAmount = lastYearContractAmount.multiply(new BigDecimal(0.5));
        Integer last2Year = today.getYear() - 2; // 去年
        OutputValueReportEntity last2YearReportSum = mapper.queryReportSum(String.valueOf(last2Year), null, "是");
        BigDecimal last2nowYearContractAmount = last2YearReportSum!=null?last2YearReportSum.getContractAmount():new BigDecimal(0);
        last2nowYearContractAmount = last2nowYearContractAmount.multiply(new BigDecimal(0.3));
        BigDecimal allContractAmount = nowYearContractAmount.add(lastYearContractAmount).add(last2nowYearContractAmount);
        allContractAmount = CommonUtils.parseDivide4(allContractAmount, 4);//万元转亿元
        BigDecimal contractOutputValueCompletionRate = ComputeUtil.bigDecimalPercent(thisYearCompleteTotalOutputValue, allContractAmount, 2);
        result.put("allContractAmount", allContractAmount);// 年在施项目合同产值完成率
        result.put("contractOutputValueCompletionRate", contractOutputValueCompletionRate);// 年在施项目合同产值完成率

        //查询【产值报表】单据数据
        /**
         * 14、页面【年度施工面积-万平米】--取自产值报表中状态=在施的建筑规模合计
         * 15、页面【年度开工面积-万平米】--取自产值报表中状态=在施的本年新项目建筑规模合计
         * 16、页面【年度竣工面积-万平米】--取自产值报表中状态=已竣未结的建筑规模合计
         **/
        BigDecimal buildingBuiltArea = reportSum!=null?reportSum.getBuiltArea():new BigDecimal(0);
        buildingBuiltArea = CommonUtils.parseDivide4(buildingBuiltArea, 4);//
        result.put("buildingBuiltArea", buildingBuiltArea);// 年度施工面积-万平米
        OutputValueReportEntity buildingThisYearSum = mapper.queryReportSum(year, "在施", "是");
        BigDecimal yearStartBuiltArea = buildingThisYearSum!=null?buildingThisYearSum.getBuiltArea():new BigDecimal(0);
        yearStartBuiltArea = CommonUtils.parseDivide4(yearStartBuiltArea, 4);//
        result.put("yearStartBuiltArea", yearStartBuiltArea);// 年度开工面积-万平米
        OutputValueReportEntity finishReportSum = mapper.queryReportSum(year, "竣工未结", null);
        BigDecimal finishBuiltArea = finishReportSum!=null?finishReportSum.getBuiltArea():new BigDecimal(0);
        finishBuiltArea = CommonUtils.parseDivide4(finishBuiltArea, 4);//
        result.put("finishBuiltArea", finishBuiltArea);// 年度竣工面积-万平米
        //查询【项目/工厂年度经营指标】单据数据
        /**
         * 17、页面【年度产值完成TOP10项目（万元）】--年度项目完成产值排名前10名
         **/
        List<OutputValueReportEntity> outputValueTop10 = mapper.queryReportOutputValueTop10(year);
        result.put("outputValueTop10", outputValueTop10);// 年度产值完成TOP10项目

        //查询【项目信息补充】单据数据
        /**
         * 18、页面【年度项目管理人员人均产值】--年度项目完成产值/【项目信息补充-项目管理人员】
         * 19、页面【年度劳务人员劳动生产率（万元）/人月】--按年度项目完成产值/【项目信息补充-劳务人员】/12
         **/
        ProjectSupplementEntity personNum = mapper.queryPersonNum(year);
        Integer managementPersonNum = personNum!=null?personNum.getManagementPersonNum():0; // 管理人员数量
        BigDecimal managementPerCapita = ComputeUtil.bigDecimalPercent(thisYearCompleteTotalOutputValue, new BigDecimal(managementPersonNum), 6);
        managementPerCapita = managementPerCapita.multiply(new BigDecimal(10000));
        result.put("managementPerCapita", managementPerCapita);// 年度项目管理人员人均产值

        Integer laborPersonNum = personNum!=null?personNum.getLaborPersonNum():0; // 劳务人员数量
        BigDecimal laborPerCapita = ComputeUtil.bigDecimalPercent(thisYearCompleteTotalOutputValue, new BigDecimal(laborPersonNum).multiply(new BigDecimal(12)), 6);
        laborPerCapita = laborPerCapita.multiply(new BigDecimal(10000));
        result.put("laborPerCapita", laborPerCapita);// 年度劳务人员劳动生产率

        //查询【公司经营指标】单据数据
        /**
         * 20、页面【年度产值计划与实际对比分析】--取每个区域公司的【计划总产值】与【总完成产值】
         **/
        QueryWrapper<CompanyBusinessQuotaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("year", year);
        List<CompanyBusinessQuotaEntity> companyList = companyBusinessQuotaService.list(wrapper);
        Map<Long, CompanyBusinessQuotaEntity> companyMap = new HashMap<>();
        if(companyList!=null && companyList.size()>0){
            companyList.forEach(item->{
                companyMap.put(item.getOrgId(), item);
            });
        }

        QueryWrapper<CompanyBusinessQuotaEntity> lastYearWrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("year", String.valueOf(lastYear));
        List<CompanyBusinessQuotaEntity> lastYearCompanyList = companyBusinessQuotaService.list(lastYearWrapper);
        Map<Long, CompanyBusinessQuotaEntity> lastYearCompanyMap = new HashMap<>();
        if(lastYearCompanyList!=null && lastYearCompanyList.size()>0){
            lastYearCompanyList.forEach(item->{
                lastYearCompanyMap.put(item.getOrgId(), item);
            });
        }

        LinkedHashMap<Long, BigDecimal> planTotalMap = new LinkedHashMap<>();//计划总产值
        LinkedHashMap<Long, BigDecimal> actualTotalMap = new LinkedHashMap<>();//总完成产值
        LinkedHashMap<Long, BigDecimal> lastYearActualTotalMap = new LinkedHashMap<>();//去年总完成产值
        LinkedList<String> orgNameList = new LinkedList<>();//公司
        CommonResponse<List<DefdocDetailVO>> defResrones =iDefdocApi.getDefDocByDefCode("zjkj_output_portal_org");
        for (DefdocDetailVO defdocDetailVO :defResrones.getData()){
            orgNameList.add(defdocDetailVO.getName());
            Long orgId = Long.valueOf(defdocDetailVO.getCode());
            if(companyMap!=null && companyMap.size()>0 && companyMap.get(orgId)!=null){
                planTotalMap.put(orgId, companyMap.get(orgId).getThisYearPlanTotalOutputValue());
                actualTotalMap.put(orgId, companyMap.get(orgId).getThisYearCompleteTotalOutputValue());
            }else{
                planTotalMap.put(orgId, new BigDecimal(0));
                actualTotalMap.put(orgId, new BigDecimal(0));
            }
            if(lastYearCompanyMap!=null && lastYearCompanyMap.size()>0 && lastYearCompanyMap.get(orgId)!=null){
                lastYearActualTotalMap.put(orgId, lastYearCompanyMap.get(orgId).getThisYearCompleteTotalOutputValue());
            }else{
                lastYearActualTotalMap.put(orgId, new BigDecimal(0));
            }
        }

        JSONObject yearPlanActualCompare = new JSONObject();

        JSONArray yearPlanActualCompareArray = new JSONArray();
        JSONObject yearPlanCompare = new JSONObject();
        yearPlanCompare.put("name","计划总产值(亿元)");
        yearPlanCompare.put("data",new ArrayList<BigDecimal>(planTotalMap.values()));
        yearPlanCompare.put("color","#4688FA");
        yearPlanActualCompareArray.add(yearPlanCompare);
        JSONObject yearActualCompare = new JSONObject();
        yearActualCompare = new JSONObject();
        yearActualCompare.put("name","总完成产值(亿元)");
        yearActualCompare.put("data",new ArrayList<BigDecimal>(actualTotalMap.values()));
        yearActualCompare.put("color","#FFA355");
        yearPlanActualCompareArray.add(yearActualCompare);
        yearPlanActualCompare.put("ladyList",yearPlanActualCompareArray);
        yearPlanActualCompare.put("legendData",orgNameList);
        result.put("yearPlanActualCompare", yearPlanActualCompare);// 年度产值计划与实际对比分析

        //查询【产值报表】单据数据
        /**
         * 21、页面【本年产值与上年同期产值对比分析】--按区域公司顺序显示【本年最后一期完成总产值】与【上年完成产值】对比
         **/
        JSONObject yearAndLastYearActualCompare = new JSONObject();
        JSONArray yearAndLastYearActualCompareArray = new JSONArray();
        yearAndLastYearActualCompareArray.add(yearActualCompare);//今年的上面已经查询了，直接用就行
        JSONObject lastYearActualCompare = new JSONObject();
        lastYearActualCompare.put("name","去年同期产值(亿元)");
        lastYearActualCompare.put("data",new ArrayList<BigDecimal>(lastYearActualTotalMap.values()));
        lastYearActualCompare.put("color","#4688FA");
        yearAndLastYearActualCompareArray.add(lastYearActualCompare);
        yearAndLastYearActualCompare.put("ladyList",yearAndLastYearActualCompareArray);
        yearAndLastYearActualCompare.put("legendData",orgNameList);
        result.put("yearAndLastYearActualCompare", yearAndLastYearActualCompare);// 本年产值与上年同期产值对比分析

        /**
         * 21、当月各区域公司产值数据分析表
         **/
        String month = String.valueOf(today.getMonthValue());
        if(month.length()==1){
            month = ("0"+month);
        }
        month += "月";
        JSONArray companyValueList = new JSONArray();
        for (DefdocDetailVO defdocDetailVO :defResrones.getData()){
            orgNameList.add(defdocDetailVO.getName());
            Long orgId = Long.valueOf(defdocDetailVO.getCode());

            JSONObject data = new JSONObject();
            data.put("orgName", defdocDetailVO.getName());//单位
            data.put("year", year);//年度
            data.put("month", month);//月份

            Map<String,Object> param = new HashMap<>();
            param.put("twoOrgId", orgId);
            param.put("year", year);
            param.put("month", '"'+month+'"');
            ProjectMonthActualOutputValueVO projectData = projectMonthActualOutputValueMapper.selectSumData(param);
            BigDecimal projectMonth = projectData!=null?projectData.getThisMonthActualOutputValue():new BigDecimal(0);

            PcMonthActualOutputValueVO pcData = pcMonthActualOutputValueMapper.selectSumData(param);
            BigDecimal pcMonth = pcData!=null?pcData.getThisMonthCompletedTotalOutputValue():new BigDecimal(0);
            BigDecimal monthActualValue = projectMonth.add(pcMonth);

            Map<String,Object> param2 = new HashMap<>();
            param2.put("twoOrgId", orgId);
            param2.put("year", year);
            ProjectPcYearBusinessQuotaVO projectPcYearData = projectPcYearBusinessQuotaMapper.selectSumData(param2);
            BigDecimal monthPlanValue = getMonthValue(projectPcYearData, month);
            BigDecimal monthValueRate = ComputeUtil.bigDecimalPercent(monthActualValue, monthPlanValue, 2);

            data.put("monthPlanValue", monthPlanValue);//月计划产值（万元）
            data.put("monthActualValue", monthActualValue);//月完成产值（万元）
            data.put("monthValueRate", monthValueRate);//月产值完成率

            BigDecimal yearTargetValue = new BigDecimal(0);
            BigDecimal yearPlanValue = new BigDecimal(0);
            BigDecimal yearActualValue = new BigDecimal(0);
            BigDecimal yearProjectPlanValue = new BigDecimal(0);
            BigDecimal yearPcPlanValue = new BigDecimal(0);
            BigDecimal yearUndertakePlanValue = new BigDecimal(0);
            if(companyMap!=null && companyMap.size()>0 && companyMap.get(orgId)!=null){
                yearTargetValue = companyMap.get(orgId).getThisYearRevenueQuota();
                yearPlanValue = companyMap.get(orgId).getThisYearPlanTotalOutputValue();
                yearActualValue = companyMap.get(orgId).getThisYearCompleteTotalOutputValue();
                yearProjectPlanValue = companyMap.get(orgId).getThisYearPlanBuildingOutputValue();
                yearPcPlanValue = companyMap.get(orgId).getThisYearPlanPcOutputValue();
                yearUndertakePlanValue = companyMap.get(orgId).getThisYearPlanUndertakeOutputValue();
            }
            BigDecimal yearValueRate = ComputeUtil.bigDecimalPercent(yearActualValue, yearPlanValue, 2);
            BigDecimal yearTargetRate = ComputeUtil.bigDecimalPercent(yearActualValue, yearTargetValue, 2);
            data.put("yearTargetValue", yearTargetValue);//年度目标产值（亿元）
            data.put("yearPlanValue", yearPlanValue);//年累计划产值（亿元）
            data.put("yearActualValue", yearActualValue);//年累完成产值（亿元）
            data.put("yearValueRate", yearValueRate);//年累产值完成率
            data.put("yearTargetRate", yearTargetRate);//年度目标完成率
            data.put("yearProjectPlanValue", yearProjectPlanValue);//年累项目计划产值（亿元）
            data.put("yearPcPlanValue", yearPcPlanValue);//年累工厂计划产值（亿元）
            data.put("yearUndertakePlanValue", yearUndertakePlanValue);//年累新承接计划产值（亿元）
            data.put("yearInHandValueRate", yearValueRate);//年累在手产值完成率
            data.put("monthInHandValueRate", monthValueRate);//月度在手产值完成率
            companyValueList.add(data);
        }
        result.put("companyValueList", companyValueList);// 当月各区域公司产值数据分析表
        return result;
    }

    private BigDecimal getMonthValue(ProjectPcYearBusinessQuotaVO projectPcYearData, String month){
        BigDecimal monthPlanValue = null;
        switch (month){
            case "1月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getJanuaryPlanOutputValue():new BigDecimal(0);
                break;
            case "2月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getFebruaryPlanOutputValue():new BigDecimal(0);
                break;
            case "3月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getMarchPlanOutputValue():new BigDecimal(0);
                break;
            case "4月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getAprilPlanOutputValue():new BigDecimal(0);
                break;
            case "5月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getMayPlanOutputValue():new BigDecimal(0);
                break;
            case "6月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getJunePlanOutputValue():new BigDecimal(0);
                break;
            case "7月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getJulyPlanOutputValue():new BigDecimal(0);
                break;
            case "8月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getAugustPlanOutputValue():new BigDecimal(0);
                break;
            case "9月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getSeptemberPlanOutputValue():new BigDecimal(0);
                break;
            case "10月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getOctoberPlanOutputValue():new BigDecimal(0);
                break;
            case "11月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getNovemberPlanOutputValue():new BigDecimal(0);
                break;
            case "12月":
                monthPlanValue = projectPcYearData!=null?projectPcYearData.getDecemberPlanOutputValue():new BigDecimal(0);
                break;
            default:
                break;
        }
        return monthPlanValue;
    }
}