package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.OutputValueReportEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;
import com.ejianc.business.outputValue.mapper.OutputValueReportMapper;
import com.ejianc.business.outputValue.mapper.PcMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.service.IOutputValueReportService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaService;
import com.ejianc.business.outputValue.vo.OutputValueReportVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 产值分析表（统计表）
 *
 * @author generator
 *
 */
@Service("outputValueReportService")
public class OutputValueReportServiceImpl extends BaseServiceImpl<OutputValueReportMapper, OutputValueReportEntity> implements IOutputValueReportService {

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private OutputValueReportMapper reportMapper;
    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;
    @Autowired
    private PcMonthActualOutputValueMapper pcMonthActualOutputValueMapper;
    @Autowired
    private IProjectPcYearBusinessQuotaService projectPcYearBusinessQuotaService;
    @Autowired
    private IProjectMonthActualOutputValueService projectMonthActualOutputValueService;
    @Autowired
    private IPcMonthActualOutputValueService pcMonthActualOutputValueService;

    @Override
    public void refreshData(String year) {
        if(StringUtils.isBlank(year)){
            Calendar cal = Calendar.getInstance();  // 获取当前时间的Calendar实例
            year = String.valueOf(cal.get(Calendar.YEAR));
        }
        //获取本年的报表数据，有的话处理
        QueryWrapper<OutputValueReportEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        wrapper.eq("dr", 0);
        wrapper.eq("year", year);
        List<OutputValueReportEntity> oldList = this.list(wrapper);
        Map<Long, OutputValueReportEntity> oldMap = new HashMap<>();
        Map<Long, OrgVO> twoOrgMap = new HashMap<>();
        List<Long> allProjectIds = new ArrayList<>();
        List<Long> exitProjectIds = new ArrayList<>();
        List<Long> delProjectIds = new ArrayList<>();
        List<OutputValueReportEntity> addList = new ArrayList<>();

        for(OutputValueReportEntity entity : oldList){
            oldMap.put(entity.getProjectId(), entity);
        }

        //获取项目基础数据
        List<OutputValueReportVO> projectList = reportMapper.queryProjectList();

        Integer nowYear = new Date().getYear();
        String da = nowYear + "/01/01";
        for(OutputValueReportVO vo : projectList){
            allProjectIds.add(vo.getProjectId());
            if(oldMap.get(vo.getProjectId())!=null){
                exitProjectIds.add(vo.getProjectId());
                //有历史数据，执行修改
                OutputValueReportEntity entity = oldMap.get(vo.getProjectId());
                entity.setProjectId(vo.getProjectId());
                entity.setProjectName(vo.getProjectName());
                entity.setProjectCode(vo.getProjectCode());
                entity.setProjectDepartmentId(vo.getProjectDepartmentId());
                entity.setProjectNum(vo.getProjectNum());
                if(entity.getOrgId()!=vo.getOrgId()){
                    if(twoOrgMap.get(vo.getOrgId())!=null){
                        OrgVO orgVO = twoOrgMap.get(vo.getOrgId());
                        entity.setTwoOrgId(orgVO.getId());
                        entity.setTwoOrgName(orgVO.getName());
                    }else{
                        OrgVO orgVO = this.getTwoOrg(vo.getOrgId());
                        twoOrgMap.put(vo.getOrgId(), orgVO);
                        entity.setTwoOrgId(orgVO.getId());
                        entity.setTwoOrgName(orgVO.getName());
                    }
                }
                entity.setOrgId(vo.getOrgId());
                entity.setOrgName(vo.getOrgName());
                entity.setActualStartDate(vo.getActualStartDate());
                entity.setActualEndDate(vo.getActualEndDate());
                entity.setPlanEndDate(vo.getPlanEndDate());
                entity.setPlanStartDate(vo.getPlanStartDate());

                BigDecimal contractAmount = vo.getContractAmount(); // 合同额(万元)
                contractAmount = CommonUtils.parseDivide4(contractAmount, 4);//万元转亿元
                BigDecimal provisionalAmount = vo.getProvisionalAmount(); // 暂列金金额(万元)
                provisionalAmount = CommonUtils.parseDivide4(provisionalAmount, 4);//万元转亿元
                entity.setContractAmount(contractAmount);
                entity.setProvisionalAmount(provisionalAmount);
                entity.setProjectStatus(vo.getProjectStatus());
                entity.setPcFactory(vo.getPcFactory());
                try {
                    entity.setBuiltArea(new BigDecimal(vo.getProjectBuiltArea()));
                }catch (Exception e){
                    entity.setBuiltArea(null);
                }
                if(vo.getCreateTime().getTime()>new Date(da).getTime()){
                    entity.setThisYearProject("是");
                }else{
                    entity.setThisYearProject("否");
                }
                addList.add(entity);
            }else{
                OutputValueReportEntity entity = BeanMapper.map(vo, OutputValueReportEntity.class);
                if(entity.getCreateTime().getTime()>new Date(da).getTime()){
                    entity.setThisYearProject("是");
                }else{
                    entity.setThisYearProject("否");
                }
                entity.setCreateTime(null);
                if(twoOrgMap.get(vo.getOrgId())!=null){
                    OrgVO orgVO = twoOrgMap.get(vo.getOrgId());
                    entity.setTwoOrgId(orgVO.getId());
                    entity.setTwoOrgName(orgVO.getName());
                    entity.setTwoOrgSequence(orgVO.getSequence());
                }else{
                    OrgVO orgVO = this.getTwoOrg(vo.getOrgId());
                    twoOrgMap.put(vo.getOrgId(), orgVO);
                    entity.setTwoOrgId(orgVO.getId());
                    entity.setTwoOrgName(orgVO.getName());
                    entity.setTwoOrgSequence(orgVO.getSequence());
                }
                //无数据，新增
                addList.add(entity);
            }
        }

        //获取删除的ids
        for(OutputValueReportEntity entity : oldList){
            if(!exitProjectIds.contains(entity.getProjectId())){
                delProjectIds.add(entity.getProjectId());
            }
        }
        //获取项目月度计划产值数据（根据年份查询当年最后一期的）
        Map<String, Object> param = new HashMap<>();
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        param.put("year", year);
        List<ProjectMonthActualOutputValueVO> projectMonthActualList = projectMonthActualOutputValueMapper.selectLastDataByYear(param);
        Map<Long, ProjectMonthActualOutputValueVO> projectMonthActualMap = new HashMap<>();
        for(ProjectMonthActualOutputValueVO vo : projectMonthActualList){
            projectMonthActualMap.put(vo.getProjectId(), vo);
        }
        //获取项目月度计划产值截至年份，开累
        List<ProjectMonthActualOutputValueVO> projectMonthAllActualList = projectMonthActualOutputValueMapper.selectAllDataByYear(param);
        Map<Long, ProjectMonthActualOutputValueVO> projectMonthAllActualMap = new HashMap<>();
        for(ProjectMonthActualOutputValueVO vo : projectMonthAllActualList){
            projectMonthAllActualMap.put(vo.getProjectId(), vo);
        }

        //获取项目月度计划产值数据（根据年份查询去年最后一期的）
        Map<String, Object> paramLastYear = new HashMap<>();
        paramLastYear.put("tenantId", InvocationInfoProxy.getTenantid());
        String lastYear = String.valueOf(Integer.parseInt(year) -1);
        paramLastYear.put("year", lastYear);
        List<ProjectMonthActualOutputValueVO> projectMonthActualLastYearList = projectMonthActualOutputValueMapper.selectLastDataByYear(paramLastYear);
        Map<Long, ProjectMonthActualOutputValueVO> projectMonthActualLastYearMap = new HashMap<>();
        for(ProjectMonthActualOutputValueVO vo : projectMonthActualLastYearList){
            projectMonthActualLastYearMap.put(vo.getProjectId(), vo);
        }

        //获取 项目/工厂年度经营指标数据（根据年份查询去年最后一期的）
        QueryWrapper<ProjectPcYearBusinessQuotaEntity> projectPcYearWrapper = new QueryWrapper<>();
        projectPcYearWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        projectPcYearWrapper.in("bill_state", 1,3);
        projectPcYearWrapper.eq("year", year);
        List<ProjectPcYearBusinessQuotaEntity> projectPcYearList = projectPcYearBusinessQuotaService.list(projectPcYearWrapper);
        Map<Long, ProjectPcYearBusinessQuotaEntity> projectPcYearMap = new HashMap<>();
        for(ProjectPcYearBusinessQuotaEntity entity : projectPcYearList){
            projectPcYearMap.put(entity.getProjectId(), entity);
        }

        //获取 项目月度计划产值------获取每月的数据
        QueryWrapper<ProjectMonthActualOutputValueEntity> projectMonthActualWrapper = new QueryWrapper<>();
        projectMonthActualWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        projectMonthActualWrapper.in("bill_state", 1,3);
        projectMonthActualWrapper.eq("year", year);
        List<ProjectMonthActualOutputValueEntity> projectMonthActualAllList = projectMonthActualOutputValueService.list(projectMonthActualWrapper);
        Map<String, ProjectMonthActualOutputValueEntity> projectMonthActualAllMap = new HashMap<>();
        for(ProjectMonthActualOutputValueEntity entity : projectMonthActualAllList){
            projectMonthActualAllMap.put(entity.getProjectId()+entity.getMonth(), entity);
        }

        //获取 工厂月度计划产值------本年获取每月的数据
        QueryWrapper<PcMonthActualOutputValueEntity> pcMonthActualWrapper = new QueryWrapper<>();
        pcMonthActualWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        pcMonthActualWrapper.in("bill_state", 1,3);
        pcMonthActualWrapper.eq("year", year);
        List<PcMonthActualOutputValueEntity> pcMonthActualAllList = pcMonthActualOutputValueService.list(pcMonthActualWrapper);
        Map<String, PcMonthActualOutputValueEntity> pcMonthActualAllMap = new HashMap<>();
        for(PcMonthActualOutputValueEntity entity : pcMonthActualAllList){
            pcMonthActualAllMap.put(entity.getProjectId()+entity.getMonth(), entity);
        }
        //获取项目月度计划产值截至年份，开累
        List<PcMonthActualOutputValueEntity> pcMonthAllActualList = pcMonthActualOutputValueMapper.selectAllDataByYear(param);
        Map<Long, PcMonthActualOutputValueEntity> pcMonthAllActualMap = new HashMap<>();
        for(PcMonthActualOutputValueEntity vo : pcMonthAllActualList){
            pcMonthAllActualMap.put(vo.getProjectId(), vo);
        }

        //获取 工厂月度计划产值------去年获取每月的数据
        QueryWrapper<PcMonthActualOutputValueEntity> pcMonthActualLastYearWrapper = new QueryWrapper<>();
        pcMonthActualLastYearWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        pcMonthActualLastYearWrapper.in("bill_state", 1,3);
        pcMonthActualLastYearWrapper.eq("year", lastYear);
        List<PcMonthActualOutputValueEntity> pcMonthActualLastYearAllList = pcMonthActualOutputValueService.list(pcMonthActualLastYearWrapper);
        Map<String, PcMonthActualOutputValueEntity> pcMonthActualLastYearAllMap = new HashMap<>();
        for(PcMonthActualOutputValueEntity entity : pcMonthActualLastYearAllList){
            pcMonthActualLastYearAllMap.put(entity.getProjectId()+entity.getMonth(), entity);
        }

        for(OutputValueReportEntity entity : addList){
            //项目总产值计划：
            entity.setYear(year);
            BigDecimal totalPlanOutputValue = new BigDecimal(0);
            //获取 项目/工厂年度经营指标数据（根据年份查询去年最后一期的）------------
            if(projectPcYearMap.get(entity.getProjectId())!=null){
                totalPlanOutputValue = projectPcYearMap.get(entity.getProjectId()).getTotalPlanOutputValue();
                entity.setJanuaryPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getJanuaryPlanOutputValue());
                entity.setFebruaryPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getFebruaryPlanOutputValue());
                entity.setMarchPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getMarchPlanOutputValue());
                entity.setAprilPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getAprilPlanOutputValue());
                entity.setMayPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getMayPlanOutputValue());
                entity.setJunePlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getJunePlanOutputValue());
                entity.setJulyPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getJulyPlanOutputValue());
                entity.setAugustPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getAugustPlanOutputValue());
                entity.setSeptemberPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getSeptemberPlanOutputValue());
                entity.setOctoberPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getOctoberPlanOutputValue());
                entity.setNovemberPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getNovemberPlanOutputValue());
                entity.setDecemberPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getDecemberPlanOutputValue());
                entity.setYearPlanOutputValue(projectPcYearMap.get(entity.getProjectId()).getYearPlanOutputValue());
            }else{
                entity.setJanuaryPlanOutputValue(null);
                entity.setFebruaryPlanOutputValue(null);
                entity.setMarchPlanOutputValue(null);
                entity.setAprilPlanOutputValue(null);
                entity.setMayPlanOutputValue(null);
                entity.setJunePlanOutputValue(null);
                entity.setJulyPlanOutputValue(null);
                entity.setAugustPlanOutputValue(null);
                entity.setSeptemberPlanOutputValue(null);
                entity.setOctoberPlanOutputValue(null);
                entity.setNovemberPlanOutputValue(null);
                entity.setDecemberPlanOutputValue(null);
            }
            BigDecimal januaryActualOutputValue = new BigDecimal(0); //1月实际产值（万元）
            BigDecimal februaryActualOutputValue = new BigDecimal(0); //2月实际产值（万元）
            BigDecimal marchActualOutputValue = new BigDecimal(0); //3月实际产值（万元）
            BigDecimal aprilActualOutputValue = new BigDecimal(0); //4月实际产值（万元）
            BigDecimal mayActualOutputValue = new BigDecimal(0); //5月实际产值（万元）
            BigDecimal juneActualOutputValue = new BigDecimal(0); //6月实际产值（万元）
            BigDecimal julyActualOutputValue = new BigDecimal(0); //7月实际产值（万元）
            BigDecimal augustActualOutputValue = new BigDecimal(0); //8月实际产值（万元）
            BigDecimal septemberActualOutputValue = new BigDecimal(0); //9月实际产值（万元）
            BigDecimal octoberActualOutputValue = new BigDecimal(0); //10月实际产值（万元）
            BigDecimal novemberActualOutputValue = new BigDecimal(0); //11月实际产值（万元）
            BigDecimal decemberActualOutputValue = new BigDecimal(0); //12月实际产值（万元）
            if("是".equals(entity.getPcFactory())){
                //工厂
                if(pcMonthActualAllMap.get(entity.getProjectId()+"01月")!=null){
                    januaryActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"02月")!=null){
                    februaryActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"02月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"03月")!=null){
                    marchActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"03月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"04月")!=null){
                    aprilActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"04月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"05月")!=null){
                    mayActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"05月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"06月")!=null){
                    juneActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"06月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"07月")!=null){
                    julyActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"07月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"08月")!=null){
                    augustActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"08月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"09月")!=null){
                    septemberActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"09月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"10月")!=null){
                    octoberActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"10月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"11月")!=null){
                    novemberActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"11月").getThisMonthCompletedTotalOutputValue();
                }
                if(pcMonthActualAllMap.get(entity.getProjectId()+"12月")!=null){
                    decemberActualOutputValue = pcMonthActualAllMap.get(entity.getProjectId()+"12月").getThisMonthCompletedTotalOutputValue();
                }
                //计算本年实际合计值
                BigDecimal thisYearAccumulateCompletedOutputValue = januaryActualOutputValue.add(februaryActualOutputValue)
                        .add(marchActualOutputValue).add(aprilActualOutputValue).add(mayActualOutputValue)
                        .add(juneActualOutputValue).add(julyActualOutputValue).add(augustActualOutputValue)
                        .add(septemberActualOutputValue).add(octoberActualOutputValue).add(novemberActualOutputValue)
                        .add(decemberActualOutputValue);
                entity.setThisYearAccumulateCompletedOutputValue(thisYearAccumulateCompletedOutputValue);
                entity.setYearActualOutputValue(thisYearAccumulateCompletedOutputValue);

                //计算去年开累产值
                BigDecimal lastYearAccumulateCompletedOutputValue = new BigDecimal(0);
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"02月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"03月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"04月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"05月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"06月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"07月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"08月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"09月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"10月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"11月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }
                if(pcMonthActualLastYearAllMap.get(entity.getProjectId()+"12月")!=null){
                    lastYearAccumulateCompletedOutputValue = CommonUtils.addBigDecimal(lastYearAccumulateCompletedOutputValue, pcMonthActualLastYearAllMap.get(entity.getProjectId()+"01月").getThisMonthCompletedTotalOutputValue());
                }

                //截至去年完成产值
                entity.setAccumulateCompletedOutputValue(pcMonthAllActualMap.get(entity.getProjectId()).getThisMonthCompletedTotalOutputValue());
                //去年完成产值
                entity.setLastYearAccumulateCompletedOutputValue(lastYearAccumulateCompletedOutputValue);

//            截至上年项目剩余产值：项目总产值计划-开累实际完成产值
                entity.setSurplusOutputValue(CommonUtils.subtractBigDecimal(totalPlanOutputValue, entity.getAccumulateCompletedOutputValue()));
            }else{
                //项目

                //截至去年完成产值
                if(projectMonthAllActualMap.get(entity.getProjectId())!=null){
                    entity.setAccumulateCompletedOutputValue(projectMonthAllActualMap.get(entity.getProjectId()).getThisMonthActualOutputValue());
                }else{
                    entity.setAccumulateCompletedOutputValue(new BigDecimal(0));
                }
                //去年完成产值
//            截止上年项目完成产值：取此项目上年12月-实际产值利润情况的本年实际完成产值
                //获取项目月度计划产值数据（根据年份查询去年最后一期的）------------
                if(projectMonthActualLastYearMap.get(entity.getProjectId())!=null){
                    entity.setLastYearAccumulateCompletedOutputValue(projectMonthActualLastYearMap.get(entity.getProjectId()).getThisYearAccumulateCompletedOutputValue());
                }else{
                    entity.setLastYearAccumulateCompletedOutputValue(null);
                }
//            截至上年项目剩余产值：项目总产值计划-开累实际完成产值
                entity.setSurplusOutputValue(CommonUtils.subtractBigDecimal(totalPlanOutputValue, entity.getAccumulateCompletedOutputValue()));

                if(projectMonthActualAllMap.get(entity.getProjectId()+"01月")!=null){
                    januaryActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"01月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"02月")!=null){
                    februaryActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"02月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"03月")!=null){
                    marchActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"03月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"04月")!=null){
                    aprilActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"04月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"05月")!=null){
                    mayActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"05月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"06月")!=null){
                    juneActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"06月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"07月")!=null){
                    julyActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"07月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"08月")!=null){
                    augustActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"08月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"09月")!=null){
                    septemberActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"09月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"10月")!=null){
                    octoberActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"10月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"11月")!=null){
                    novemberActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"11月").getThisMonthActualOutputValue();
                }
                if(projectMonthActualAllMap.get(entity.getProjectId()+"12月")!=null){
                    decemberActualOutputValue = projectMonthActualAllMap.get(entity.getProjectId()+"12月").getThisMonthActualOutputValue();
                }
                //计算本年实际合计值
                BigDecimal thisYearAccumulateCompletedOutputValue = januaryActualOutputValue.add(februaryActualOutputValue)
                        .add(marchActualOutputValue).add(aprilActualOutputValue).add(mayActualOutputValue)
                        .add(juneActualOutputValue).add(julyActualOutputValue).add(augustActualOutputValue)
                        .add(septemberActualOutputValue).add(octoberActualOutputValue).add(novemberActualOutputValue)
                        .add(decemberActualOutputValue);
                entity.setThisYearAccumulateCompletedOutputValue(thisYearAccumulateCompletedOutputValue);
                entity.setYearActualOutputValue(thisYearAccumulateCompletedOutputValue);
            }
            entity.setJanuaryActualOutputValue(januaryActualOutputValue); //1月实际产值（万元）
            entity.setFebruaryActualOutputValue(februaryActualOutputValue); //2月实际产值（万元）
            entity.setMarchActualOutputValue(marchActualOutputValue); //3月实际产值（万元）
            entity.setAprilActualOutputValue(aprilActualOutputValue); //4月实际产值（万元）
            entity.setMayActualOutputValue(mayActualOutputValue); //5月实际产值（万元）
            entity.setJuneActualOutputValue(juneActualOutputValue); //6月实际产值（万元）
            entity.setJulyActualOutputValue(julyActualOutputValue); //7月实际产值（万元）
            entity.setAugustActualOutputValue(augustActualOutputValue); //8月实际产值（万元）
            entity.setSeptemberActualOutputValue(septemberActualOutputValue); //9月实际产值（万元）
            entity.setOctoberActualOutputValue(octoberActualOutputValue); //10月实际产值（万元）
            entity.setNovemberActualOutputValue(novemberActualOutputValue); //11月实际产值（万元）
            entity.setDecemberActualOutputValue(decemberActualOutputValue); //12月实际产值（万元）
        }

        if(delProjectIds!=null && delProjectIds.size()>0){
            QueryWrapper<OutputValueReportEntity> deleteWrapper = new QueryWrapper<>();
            deleteWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
            deleteWrapper.eq("year", year);
            deleteWrapper.in("project_id", delProjectIds);
            this.remove(deleteWrapper);
        }
        if(addList!=null && addList.size()>0){
            this.saveOrUpdateBatch(addList, addList.size(), false);
        }
    }

    private OrgVO getTwoOrg(Long orgId){
        OrgVO orgVO = new OrgVO();
        //获取二级组织
        CommonResponse<OrgVO> orgResponse = iOrgApi.detailById(orgId);
        if(orgResponse.isSuccess() && orgResponse.getData()!=null){
            String innerCode = orgResponse.getData().getInnerCode();
            String[] orgIds = innerCode.split("\\|");
            if(orgIds.length>1){
                Long twoOrgId = Long.parseLong(orgIds[1]); // 二级组织
                String twoOrgName = null; // 二级组织名称
                CommonResponse<OrgVO> twoOrgResponse = iOrgApi.detailById(twoOrgId);
                if(twoOrgResponse.isSuccess() && twoOrgResponse.getData()!=null){
                    orgVO = twoOrgResponse.getData();
                }
            }else{
                orgVO = orgResponse.getData();
            }
        }
        return orgVO;
    }
}